/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a.pc;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.ConnectorUtils;
import anywheresoftware.b4a.DebugConnector;
import anywheresoftware.b4a.pc.B4XTypes;
import anywheresoftware.b4a.pc.DebugExpressions;
import anywheresoftware.b4a.pc.PCBA;
import anywheresoftware.b4a.pc.RDebug;
import anywheresoftware.b4a.pc.RapidSub;
import anywheresoftware.b4a.pc.RemoteObject;
import anywheresoftware.b4a.shell.ShellConnector;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicIntegerArray;

public class Debug
implements DebugConnector.MessageHandler {
    private static final byte IDE_REACH_BP = 2;
    private static final byte IDE_CONTINUE = 3;
    private static final byte IDE_NEW_BP = 4;
    private static final byte IDE_SEND_BP_DATA = 5;
    private static final byte IDE_STOP = 6;
    private static final byte IDE_STEP = 7;
    private static final byte IDE_STEP_OVER = 8;
    private static final byte IDE_STEP_OUT = 9;
    private static final byte IDE_PAUSE = 10;
    private static final byte IDE_BRIDGE_LOG_PORT = 13;
    public static final byte IDE_ENGINE_CONNECTED_TO_DEVICE = 14;
    private static final byte IDE_SET_LINES_NUMBERS = 15;
    private static final byte IDE_CODE_SWAP = 50;
    private static final byte IDE_GET_REMOTE = 51;
    private static final byte IDE_JUMP_TO_LINE = 52;
    public static final byte IDE_RETURN_TO_CODE_CHAIN_START = 53;
    public static final byte DEBUG_EXPRESSION = 54;
    public static final byte REMOVE_ALL_EXPRESSION = 55;
    public static final byte REMOVE_ONE_EXPRESSION = 56;
    public static boolean useVirtualAssetsFolder;
    public static LinkedHashMap<String, Object> locals;
    private static volatile int stackSize;
    public static volatile int stackLimit;
    public static SubFrame currentSubFrame;
    private static ArrayList<SubFrame> subsStackFrames;
    public static ArrayList<Object> SubsStack;
    public static AtomicIntegerArray[] breakPoints;
    public static volatile boolean waiting;
    private static int currentBPline;
    public static DebugConnector ideConnector;
    public static ShellConnector deviceConnector;
    public static boolean dontPauseUntilEndOfChain;
    private static String packageName;
    public static String errorSub;
    public static B4XTypes.B4XClass deviceModule;
    public static B4XTypes.B4XClass[] moduleNumberToName;
    private static final ConcurrentHashMap<String, RemoteObject> debuggerVars;

    static {
        subsStackFrames = new ArrayList();
        SubsStack = new ArrayList();
        waiting = false;
        dontPauseUntilEndOfChain = false;
        debuggerVars = new ConcurrentHashMap();
    }

    public static void PushSubsStack(String sub, String Module2, int moduleNumber, RemoteObject ba, Object mostCurrent, int subStartLine) throws Exception {
        if (SubsStack.size() > 0) {
            SubsStack.add(BA.debugLineNum);
        }
        B4XTypes.B4XClass module = new B4XTypes.B4XClass(Module2);
        Debug.setModule(module);
        Debug.setDeviceCurrentLine(subStartLine);
        if (packageName == null) {
            packageName = mostCurrent.getClass().getPackage().getName();
        }
        SubsStack.add(sub);
        currentSubFrame = new SubFrame(module, moduleNumber, ba, mostCurrent);
        locals = Debug.currentSubFrame.locals;
        subsStackFrames.add(currentSubFrame);
    }

    public static void PopSubsStack() throws Exception {
        SubsStack.remove(SubsStack.size() - 1);
        subsStackFrames.remove(subsStackFrames.size() - 1);
        if (SubsStack.size() > 0) {
            if (Debug.currentSubFrame.finishedWithNoExceptions) {
                BA.debugLineNum = (Integer)SubsStack.get(SubsStack.size() - 1);
            }
            SubsStack.remove(SubsStack.size() - 1);
        }
        if (subsStackFrames.size() > 0) {
            currentSubFrame = subsStackFrames.get(subsStackFrames.size() - 1);
            locals = Debug.currentSubFrame.locals;
            Debug.setModule(Debug.currentSubFrame.moduleName);
        } else {
            currentSubFrame = null;
            locals = null;
        }
    }

    private static void setModule(B4XTypes.B4XClass module) throws Exception {
        if (!module.equals(deviceModule)) {
            BA.rdebugUtils.setField("currentModule", module.getStringToSend());
            deviceModule = module;
        }
    }

    private static void setDeviceCurrentLine(int line) throws Exception {
        BA.rdebugUtils.setField("currentLine", line);
    }

    public static void ShouldStop(int mask) throws Exception {
        Debug.setDeviceCurrentLine(BA.debugLineNum);
        if (stackLimit >= SubsStack.size() || (breakPoints[Debug.currentSubFrame.moduleNumber].get(BA.debugLineNum / 32) & mask) != 0) {
            if (!dontPauseUntilEndOfChain && !((Boolean)BA.rdebugUtils.runMethod(true, "msgboxDismissing", new Object[0]).get()).booleanValue()) {
                Debug.reachBP(BA.debugLineNum);
            } else {
                System.out.println("skipping breakpoint (MsgboxDismisses = true)");
            }
        }
    }

    private static void reachBP(int line) throws Exception {
        Object[] globals;
        System.out.println("reach bp: " + line);
        if (Debug.currentSubFrame.mostCurrent instanceof RemoteObject) {
            Class<?> cls = new B4XTypes.PCClass(Debug.currentSubFrame.moduleName).getJavaClass();
            globals = (Object[])cls.getMethod("GetGlobals", RemoteObject.class).invoke(null, Debug.currentSubFrame.mostCurrent);
        } else {
            globals = (Object[])Debug.currentSubFrame.mostCurrent.getClass().getMethod("GetGlobals", null).invoke(Debug.currentSubFrame.mostCurrent, new Object[0]);
        }
        ConnectorUtils.startMessage((byte)2);
        ConnectorUtils.writeString(Debug.currentSubFrame.moduleName.getStringToSend());
        ConnectorUtils.writeInt(line);
        currentBPline = line;
        stackSize = SubsStack.size();
        ConnectorUtils.sendMessage(ideConnector);
        Debug.sendBPData(globals);
        RDebug.INSTANCE.debugPause(Debug.currentSubFrame.ba, BA.debugLineNum, BA.debugLine);
        waiting = true;
        try {
            RDebug.INSTANCE.waitForTask();
        }
        finally {
            waiting = false;
        }
    }

    private static void sendBPData(Object[] globals) throws IOException {
        try {
            SubsStack.add(String.valueOf(currentBPline));
            ConnectorUtils.startMessage((byte)5);
            Debug.runAllExpressions();
            Debug.writeLocals(locals.size());
            Debug.writeGlobals(globals, globals.length / 2);
            ConnectorUtils.writeInt(SubsStack.size());
            int i = SubsStack.size() - 2;
            while (i >= 0) {
                ConnectorUtils.writeString(String.valueOf(SubsStack.get(i)));
                ConnectorUtils.writeString(String.valueOf(SubsStack.get(i + 1)));
                i -= 2;
            }
            ConnectorUtils.sendMessage(ideConnector);
        }
        finally {
            SubsStack.remove(SubsStack.size() - 1);
        }
    }

    public static void runAfterNewExpression(int id) throws Exception {
        RDebug.INSTANCE.debugDontPrintErrors();
        ConnectorUtils.startMessage((byte)51);
        ConnectorUtils.writeString(String.valueOf(id));
        ConnectorUtils.writeByte((byte)2);
        ConnectorUtils.writeInt(2);
        Debug.runAndSendExpression(id, new DebugExpressions.LocalsMap(locals, Debug.currentSubFrame.mostCurrent));
        ConnectorUtils.sendMessage(ideConnector);
        RDebug.INSTANCE.debugPause(Debug.currentSubFrame.ba, BA.debugLineNum, BA.debugLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runAllExpressions() throws IOException {
        RDebug.INSTANCE.debugDontPrintErrors();
        ConcurrentHashMap<Integer, Method> concurrentHashMap = DebugExpressions.loadedClasses;
        synchronized (concurrentHashMap) {
            int numOfExpressions = DebugExpressions.loadedClasses.size();
            ConnectorUtils.writeInt(numOfExpressions * 2);
            DebugExpressions.LocalsMap lm = new DebugExpressions.LocalsMap(locals, Debug.currentSubFrame.mostCurrent);
            ArrayList<Integer> al = new ArrayList<Integer>(numOfExpressions);
            Iterator iterator = DebugExpressions.loadedClasses.keySet().iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                al.add(id);
            }
            Collections.sort(al);
            int i = al.size() - 1;
            while (i >= 0) {
                Debug.runAndSendExpression((Integer)al.get(i), lm);
                --i;
            }
        }
    }

    private static void runAndSendExpression(int id, DebugExpressions.LocalsMap lm) {
        Object expr = DebugExpressions.run(id, lm, Debug.currentSubFrame.ba);
        Debug.writeVariable("", String.valueOf(id), expr);
    }

    private static void writeGlobals(Object[] globals, int limit) {
        ConnectorUtils.mark();
        ConnectorUtils.writeInt(limit * 2);
        int i = 0;
        while (i < limit * 2) {
            boolean success = Debug.writeVariable("", (String)globals[i], globals[i + 1]);
            if (!success) {
                ConnectorUtils.resetToMark();
                Debug.writeGlobals(globals, i / 2);
                break;
            }
            i += 2;
        }
    }

    private static void writeLocals(int limit) {
        ConnectorUtils.mark();
        ConnectorUtils.writeInt(limit * 2);
        int count = 0;
        for (Map.Entry<String, Object> e : locals.entrySet()) {
            boolean success = Debug.writeVariable("", e.getKey(), e.getValue());
            if (!success) {
                ConnectorUtils.resetToMark();
                Debug.writeLocals(count);
                break;
            }
            ++count;
        }
    }

    public static RemoteObject moduleToString(Class<?> c) {
        return RemoteObject.declareNull(c.getName());
    }

    public static void CheckDeviceExceptions() throws Exception {
        BA.rdebugUtils.getField(true, "currentLine").get();
    }

    public static void ErrorCaught(Exception e) throws Exception {
        Debug.currentSubFrame.finishedWithNoExceptions = false;
    }

    public static void stopWaiting() throws IOException {
        if (waiting) {
            debuggerVars.clear();
            RDebug.INSTANCE.mainThreadTasks.add(new byte[]{4});
        }
    }

    @Override
    public void connectionStatus(boolean connected) {
        RDebug.INSTANCE.IdeConnectionStatus(connected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleIncomingData(int firstByte, InputStream in) throws IOException {
        DataInputStream din = new DataInputStream(in);
        switch (firstByte) {
            case 3: {
                stackLimit = 0;
                Debug.stopWaiting();
                break;
            }
            case 7: {
                stackLimit = Integer.MAX_VALUE;
                Debug.stopWaiting();
                break;
            }
            case 8: {
                stackLimit = stackSize;
                Debug.stopWaiting();
                break;
            }
            case 9: {
                stackLimit = stackSize - 1;
                Debug.stopWaiting();
                break;
            }
            case 10: {
                stackLimit = Integer.MAX_VALUE;
                break;
            }
            case 4: {
                this.handleNewBreakPoints(din);
                break;
            }
            case 6: {
                Debug.stopProgram();
                break;
            }
            case 15: {
                this.getLineNumbers(din);
                break;
            }
            case 50: {
                this.codeSwap(din);
                break;
            }
            case 53: {
                Debug.returnToCodeChainStart();
                break;
            }
            case 51: {
                this.getRemoteObject(din);
                break;
            }
            case 13: {
                Debug.debugBridgePort(din);
                break;
            }
            case 54: {
                Debug.newDebugExpression(din);
                break;
            }
            case 55: {
                ConcurrentHashMap<Integer, Method> concurrentHashMap = DebugExpressions.loadedClasses;
                synchronized (concurrentHashMap) {
                    DebugExpressions.loadedClasses.clear();
                    break;
                }
            }
            case 56: {
                ConcurrentHashMap<Integer, Method> concurrentHashMap = DebugExpressions.loadedClasses;
                synchronized (concurrentHashMap) {
                    int id = ConnectorUtils.readInt(din);
                    DebugExpressions.loadedClasses.remove(id);
                    break;
                }
            }
        }
    }

    private static void newDebugExpression(DataInputStream din) throws IOException {
        int id = ConnectorUtils.readInt(din);
        String expr = ConnectorUtils.readString(din);
        System.out.println("expression arrived: " + expr);
        DebugExpressions.expressionArrived(id, expr);
        if (waiting) {
            ByteBuffer bb = ByteBuffer.wrap(new byte[5]);
            bb.put((byte)54);
            bb.putInt(id);
            RDebug.INSTANCE.mainThreadTasks.add(bb.array());
        }
    }

    private static void debugBridgePort(DataInputStream din) throws IOException {
        int port = ConnectorUtils.readInt(din);
        System.out.println("debug bridge port: " + port);
        ByteBuffer bb = ByteBuffer.wrap(new byte[5]);
        bb.put((byte)13);
        bb.putInt(port);
        RDebug.INSTANCE.deviceConnector.sendControlMessage(bb.array());
    }

    private static void returnToCodeChainStart() {
        if (waiting) {
            stackLimit = Integer.MAX_VALUE;
            debuggerVars.clear();
            RDebug.INSTANCE.mainThreadTasks.add(new byte[]{53});
        }
    }

    private static boolean writeVariable(String baseName, String name, Object value) {
        ConnectorUtils.writeString(name);
        if (value instanceof RemoteObject) {
            RemoteObject ro = (RemoteObject)value;
            if (ro.wrappedValue != null) {
                value = ro.wrappedValue;
            } else {
                ConnectorUtils.writeByte((byte)1);
                debuggerVars.put(String.valueOf(baseName) + name, ro);
                return true;
            }
        }
        ConnectorUtils.writeByte((byte)0);
        return ConnectorUtils.writeString(String.valueOf(value));
    }

    public static void jumpToLine(B4XTypes.B4XClass module, int line) {
        ConnectorUtils.startMessage((byte)52);
        ConnectorUtils.writeString(module.getStringToSend());
        ConnectorUtils.writeInt(line);
        ConnectorUtils.sendMessage(ideConnector);
    }

    private void getRemoteObject(DataInputStream din) throws IOException {
        try {
            String name = ConnectorUtils.readString(din);
            byte local = din.readByte();
            if (!waiting) {
                return;
            }
            RemoteObject ro = debuggerVars.get(name);
            if (ro == null) {
                System.out.println("Variable not found: " + name);
                return;
            }
            if (ro.slot == 0) {
                if (ro.JavaClass == null) {
                    return;
                }
                Debug.sendSingleton(ro, name, local);
            } else {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                DataOutputStream dout = new DataOutputStream(bout);
                dout.writeByte(5);
                RDebug.INSTANCE.deviceConnector.writeObject(dout, name);
                dout.write(local);
                RDebug.INSTANCE.deviceConnector.writeObject(dout, ro);
                RDebug.INSTANCE.deviceConnector.sendControlMessage(bout.toByteArray());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void sendSingleton(RemoteObject ro, String name, byte local) throws IllegalArgumentException, IllegalAccessException {
        if (!waiting) {
            return;
        }
        Class<?> cls = null;
        try {
            cls = Class.forName(ro.JavaClass);
        }
        catch (ClassNotFoundException cfe) {
            System.out.println("class not found: " + ro.JavaClass);
            return;
        }
        ConnectorUtils.startMessage((byte)51);
        ConnectorUtils.writeString(name);
        ConnectorUtils.writeByte(local);
        LinkedHashMap<String, Object> vars = new LinkedHashMap<String, Object>();
        Field[] fieldArray = cls.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                Object value;
                String fname;
                block9: {
                    Field f = fieldArray[n2];
                    fname = f.getName();
                    if (!fname.startsWith("_") || fname.equals("__c") || !Modifier.isStatic(f.getModifiers())) break block8;
                    f.setAccessible(true);
                    value = f.get(null);
                    if (value == null) break block8;
                    if (!(value instanceof RemoteObject) || ((RemoteObject)value).wrappedValue != null) break block9;
                    RemoteObject roo = (RemoteObject)value;
                    if (roo.slot == 0) break block8;
                }
                vars.put(fname.substring(1), value);
            }
            ++n2;
        }
        ConnectorUtils.writeInt(vars.size() * 2);
        for (Map.Entry e : vars.entrySet()) {
            Debug.writeVariable(String.valueOf(name) + "/", (String)e.getKey(), e.getValue());
        }
        ConnectorUtils.sendMessage(ideConnector);
    }

    public static void remoteObjectArrivedFromDevice(DataInputStream din) throws Exception {
        if (!waiting) {
            return;
        }
        String name = (String)RDebug.INSTANCE.deviceConnector.readObject(din, false);
        byte local = din.readByte();
        ConnectorUtils.startMessage((byte)51);
        ConnectorUtils.writeString(name);
        ConnectorUtils.writeByte(local);
        System.out.println("remoteObjectArrivedFromDevice: " + name);
        LinkedHashMap<String, Object> vars = new LinkedHashMap<String, Object>();
        while (din.readByte() == 1) {
            String fieldName = (String)RDebug.INSTANCE.deviceConnector.readObject(din, false);
            Object fieldValue = RDebug.INSTANCE.deviceConnector.readObject(din, false);
            vars.put(fieldName, fieldValue);
        }
        ConnectorUtils.writeInt(vars.size() * 2);
        for (Map.Entry e : vars.entrySet()) {
            Debug.writeVariable(String.valueOf(name) + "/", (String)e.getKey(), e.getValue());
        }
        ConnectorUtils.sendMessage(ideConnector);
    }

    private void codeSwap(DataInputStream din) throws IOException {
        B4XTypes.B4XClass module = new B4XTypes.B4XClass(ConnectorUtils.readString(din));
        int version = ConnectorUtils.readInt(din);
        System.out.println("code swap: " + module + ", " + version);
        RapidSub.codeSwap();
        try {
            PCBA.fillSubs(new B4XTypes.PCClass(module).getJavaClass(), version);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void getLineNumbers(DataInputStream din) throws IOException {
        System.out.println("getLineNumbers");
        if (RDebug.INSTANCE.B4A) {
            useVirtualAssetsFolder = din.read() == 1;
        }
        int numberOfModules = ConnectorUtils.readInt(din);
        moduleNumberToName = new B4XTypes.B4XClass[numberOfModules];
        int i = 0;
        while (i < moduleNumberToName.length) {
            Debug.moduleNumberToName[i] = new B4XTypes.B4XClass(ConnectorUtils.readString(din));
            ++i;
        }
        breakPoints = new AtomicIntegerArray[numberOfModules];
        i = 0;
        while (i < breakPoints.length) {
            Debug.breakPoints[i] = new AtomicIntegerArray(ConnectorUtils.readInt(din));
            ++i;
        }
        try {
            RDebug.deviceIsReady.await();
            RDebug.debuggerIsReady.countDown();
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    private void handleNewBreakPoints(DataInputStream din) throws IOException {
        int numberOfBP = ConnectorUtils.readInt(din);
        int i = 0;
        while (i < numberOfBP) {
            int module = ConnectorUtils.readInt(din);
            int line = ConnectorUtils.readInt(din);
            byte on = din.readByte();
            int a = line / 32;
            if (a < breakPoints[module].length()) {
                int p = breakPoints[module].get(a);
                HashMap<String, RapidSub> subs = RapidSub.modules.get(moduleNumberToName[module]);
                RapidSub targetSub = null;
                for (RapidSub rs : subs.values()) {
                    if (line < rs.startLine || line > rs.endLine) continue;
                    targetSub = rs;
                    break;
                }
                if (targetSub == null) {
                    System.out.println("*** invalid breakpoint: " + line);
                } else {
                    if (on == 1) {
                        p |= 1 << line % 32 - 1;
                        ++targetSub.numberOfBreakpoints;
                    } else {
                        p &= ~(1 << line % 32 - 1);
                        --targetSub.numberOfBreakpoints;
                    }
                    breakPoints[module].set(a, p);
                }
            }
            ++i;
        }
    }

    public static void stopProgram() throws IOException {
        if (RDebug.INSTANCE.deviceConnector != null) {
            RDebug.INSTANCE.deviceConnector.sendControlMessage(new byte[]{3});
        }
        RDebug.INSTANCE.deviceConnector.stop();
        ideConnector.stop();
    }

    public static class SubFrame {
        public final B4XTypes.B4XClass moduleName;
        public final int moduleNumber;
        public final RemoteObject ba;
        public final Object mostCurrent;
        public boolean finishedWithNoExceptions = true;
        public final LinkedHashMap<String, Object> locals = new LinkedHashMap();

        public SubFrame(B4XTypes.B4XClass moduleName, int moduleNumber, RemoteObject ba, Object mostCurrent) {
            this.moduleName = moduleName;
            this.moduleNumber = moduleNumber;
            this.ba = ba;
            this.mostCurrent = mostCurrent;
        }
    }
}

