/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a.pc;

import anywheresoftware.b4a.pc.RapidSub;
import anywheresoftware.b4a.pc.RemoteObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.SecureClassLoader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class DebugExpressions {
    private static JavaCompiler compiler;
    private static JavaFileManager fileManager;
    public static final ConcurrentHashMap<Integer, Method> loadedClasses;

    static {
        loadedClasses = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void expressionArrived(int id, String expression) {
        ConcurrentHashMap<Integer, Method> concurrentHashMap = loadedClasses;
        synchronized (concurrentHashMap) {
            StringBuilder sb = new StringBuilder();
            String name = "e" + id;
            try {
                sb.append("import anywheresoftware.b4a.BA;\nimport anywheresoftware.b4a.pc.*;\n");
                sb.append("import ").append(RapidSub.packageName).append(".*;\n").append("public class ").append(name).append("{public static RemoteObject run(java.util.Map<String, RemoteObject> locals, RemoteObject _ba) throws Exception {return ").append(expression).append(";}}");
                Class<?> cls = DebugExpressions.compile(name, sb.toString());
                loadedClasses.put(id, cls.getMethod("run", Map.class, RemoteObject.class));
            }
            catch (Throwable e) {
                System.err.println("error compiling expression.");
                e.printStackTrace();
                try {
                    loadedClasses.put(id, DebugExpressions.class.getMethod("run", Map.class, RemoteObject.class));
                }
                catch (Exception e1) {
                    throw new RuntimeException(e1);
                }
            }
        }
    }

    private static Class<?> compile(String name, String src) throws Exception {
        if (compiler == null) {
            compiler = ToolProvider.getSystemJavaCompiler();
            fileManager = new ClassFileManager(compiler.getStandardFileManager(null, null, null));
        }
        System.out.println("compiler: " + compiler.getTask(null, fileManager, null, null, null, Arrays.asList(new StringFileObject(name, src))).call());
        return fileManager.getClassLoader(null).loadClass(name);
    }

    public static Object run(int id, Map<String, RemoteObject> locals, RemoteObject ba) {
        try {
            RemoteObject ro = (RemoteObject)loadedClasses.get(id).invoke(null, locals, ba);
            return ro.get();
        }
        catch (Exception e) {
            return "Error evaluating expression.";
        }
    }

    public static RemoteObject run(Map<String, RemoteObject> locals, RemoteObject ba) {
        return RemoteObject.createImmutable("Error compiling expression.");
    }

    static class ClassFileManager
    extends ForwardingJavaFileManager<JavaFileManager> {
        public JavaClassObject jclassObject;

        public ClassFileManager(StandardJavaFileManager standardManager) {
            super(standardManager);
        }

        @Override
        public ClassLoader getClassLoader(JavaFileManager.Location location) {
            return new SecureClassLoader(){

                @Override
                protected Class<?> findClass(String name) throws ClassNotFoundException {
                    byte[] b = ClassFileManager.this.jclassObject.getBytes();
                    return super.defineClass(name, ClassFileManager.this.jclassObject.getBytes(), 0, b.length);
                }
            };
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            this.jclassObject = new JavaClassObject(className, kind);
            return this.jclassObject;
        }
    }

    static class JavaClassObject
    extends SimpleJavaFileObject {
        private final ByteArrayOutputStream bos = new ByteArrayOutputStream();

        public JavaClassObject(String name, JavaFileObject.Kind kind) {
            super(URI.create("string:///" + name.replace('.', '/') + kind.extension), kind);
        }

        public byte[] getBytes() {
            return this.bos.toByteArray();
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return this.bos;
        }
    }

    public static class LocalsMap
    extends HashMap<String, RemoteObject> {
        private final Map<String, Object> map;
        private final RemoteObject _ref;

        public LocalsMap(Map<String, Object> m, Object _ref) {
            this.map = m;
            this._ref = _ref instanceof RemoteObject ? (RemoteObject)_ref : null;
        }

        @Override
        public RemoteObject get(Object s) {
            if (s.equals("_ref")) {
                return this._ref;
            }
            if (!this.map.containsKey(s)) {
                throw new RuntimeException("Unknown variable: " + s);
            }
            Object o = this.map.get(s);
            if (!(o instanceof RemoteObject)) {
                return RemoteObject.createImmutable(o);
            }
            return (RemoteObject)o;
        }

        @Override
        public Set<String> keySet() {
            return this.map.keySet();
        }
    }

    static class StringFileObject
    extends SimpleJavaFileObject {
        private CharSequence content;

        public StringFileObject(String className, CharSequence content) {
            super(URI.create("string:///" + className.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.content = content;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.content;
        }
    }
}

