/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a.pc;

import anywheresoftware.b4a.pc.B4XTypes;
import anywheresoftware.b4a.pc.ClassesManager;
import anywheresoftware.b4a.pc.RapidSub;
import anywheresoftware.b4a.pc.RemoteObject;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;

public class PCBA {
    public static final Locale cul = Locale.US;
    private static final ConcurrentHashMap<Class<?>, MethodsAndVersion> allSubs = new ConcurrentHashMap();
    public HashMap<B4XTypes.HtSubName, Method> htSubs;
    public final Object eventsTarget;
    public static RemoteObject deviceBA;
    public final Class<?> targetClass;
    public final B4XTypes.B4XClass b4xclass;

    public PCBA(Object target, Class<?> targetClass) {
        if (deviceBA == null) {
            deviceBA = RemoteObject.declareNull("anywheresoftware.b4a.BA");
            RapidSub.packageName = targetClass.getPackage().getName();
        }
        this.eventsTarget = target;
        this.targetClass = targetClass;
        this.b4xclass = new B4XTypes.B4XClass(new B4XTypes.PCClass(targetClass));
        try {
            PCBA.fillSubs(targetClass, 0);
            this.htSubs = PCBA.allSubs.get(targetClass).subs;
        }
        catch (ClassNotFoundException c) {
            throw new RuntimeException(c);
        }
    }

    public static void fillSubs(Class<?> targetClass, int classVersion) throws ClassNotFoundException {
        MethodsAndVersion mv = allSubs.get(targetClass);
        if (mv == null) {
            mv = new MethodsAndVersion();
            mv.subs = new HashMap();
            allSubs.put(targetClass, mv);
        } else if (classVersion <= mv.version) {
            return;
        }
        mv.subs.clear();
        Class<?> target = Class.forName(String.valueOf(targetClass.getName()) + "_subs_" + classVersion);
        boolean isClass = ClassesManager.classes.contains(new B4XTypes.B4XClass(new B4XTypes.PCClass(targetClass)));
        Method[] methodArray = target.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().startsWith("_")) {
                mv.subs.put(new B4XTypes.HtSubName(new B4XTypes.SubName(m.getName().substring(1)), m.getParameterTypes().length, isClass), m);
            }
            ++n2;
        }
    }

    public Object raiseEvent(String htSubName, Object[] params) throws Exception {
        Method m = this.htSubs.get(new B4XTypes.HtSubName(htSubName));
        if (m != null) {
            try {
                if (params != null) {
                    int i = 0;
                    while (i < m.getParameterTypes().length) {
                        if (m.getParameterTypes()[i] == RemoteObject.class && !(params[i] instanceof RemoteObject)) {
                            params[i] = RemoteObject.createImmutable(params[i]);
                        }
                        ++i;
                    }
                }
                return m.invoke(this.eventsTarget, params);
            }
            catch (IllegalArgumentException e) {
                String msg = "Sub " + htSubName + " signature does not match expected signature.\n" + m.toString();
                throw new Exception(msg);
            }
            catch (ArrayIndexOutOfBoundsException ee) {
                String msg = "Sub " + htSubName + " signature does not match expected signature.\n" + m.toString();
                throw new Exception(msg);
            }
        }
        System.out.println("PCBA.raiseEvent not found: " + htSubName);
        return null;
    }

    static class MethodsAndVersion {
        public int version;
        public HashMap<B4XTypes.HtSubName, Method> subs;

        MethodsAndVersion() {
        }
    }
}

