/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a.pc;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.DebugConnector;
import anywheresoftware.b4a.keywords.Common;
import anywheresoftware.b4a.pc.B4XTypes;
import anywheresoftware.b4a.pc.ClassesManager;
import anywheresoftware.b4a.pc.Debug;
import anywheresoftware.b4a.pc.PCBA;
import anywheresoftware.b4a.pc.RapidSub;
import anywheresoftware.b4a.pc.RemoteObject;
import anywheresoftware.b4a.shell.ShellConnector;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class RDebug
implements ShellConnector.ShellHandler {
    public static RDebug INSTANCE;
    public final boolean B4A;
    public final boolean B4J;
    public static final byte CODE_CHAIN_START = 2;
    public static final byte STOP = 3;
    public static final byte CONTINUE = 4;
    public static final byte GET_DEBUG_VAR = 5;
    public static final byte STOP_MESSAGE_LOOP = 6;
    public static final byte VIRTUAL_FILES = 7;
    private static final byte RUN_METHOD = 1;
    private static final byte CREATE_OBJECT = 2;
    private static final byte FILL_HTSUBS = 3;
    private static final byte CODE_CHAIN_END = 4;
    private static final byte CLEAN_MEMORY = 5;
    private static final byte RUN_VOID_METHOD = 6;
    private static final byte GET_FIELD = 7;
    private static final byte SET_FIELD = 8;
    private static final byte CREATE_ARRAY = 9;
    private static final byte ARRAY_GET = 10;
    private static final byte ARRAY_SET = 11;
    private static final byte GET = 12;
    private static final byte RUN_METHOD_WITH_SYNC = 13;
    private static final byte PAUSE = 14;
    private static final byte START_MESSAGE_LOOP = 15;
    private static final byte SET_STATE_BEFORE_USER_SUB = 16;
    private static final byte GET_STATE_AFTER_USER_SUB = 17;
    private static final byte DONT_PRINT_ERRORS = 18;
    private static final byte FILL_CLASSES_HTSUBS = 19;
    private static final byte SEND_BREAKPOINTS_TO_DEVICE = 20;
    private static final byte SPECIAL_NESTED_EVENT = 1;
    private static final byte SPECIAL_LOADLAYOUT = 2;
    private static final byte SPECIAL_CREATE_CUSTOM_VIEW = 3;
    private static final byte SPECIAL_ROLLBACK_AFTER_MSGBOX_DISMISSED = 4;
    public static final CountDownLatch deviceIsReady;
    public static final CountDownLatch debuggerIsReady;
    public ShellConnector deviceConnector;
    private DebugConnector ideConnector;
    public DataOutputStream dout;
    private DataInputStream din;
    public final LinkedBlockingQueue<byte[]> mainThreadTasks = new LinkedBlockingQueue();
    public final HashMap<B4XTypes.DeviceClass, WeakReference<PCBA>> eventTargets = new HashMap();
    private final HashMap<Class<?>, IRemote> singletons = new HashMap();
    private final Deque<PCBA> baStack = new ArrayDeque<PCBA>();
    private Thread mainThread = Thread.currentThread();
    private final String IP;
    private final int devicePort;

    static {
        deviceIsReady = new CountDownLatch(1);
        debuggerIsReady = new CountDownLatch(1);
    }

    public RDebug(String IP, int devicePort, int listenToIDEPort, String productName) {
        INSTANCE = this;
        this.IP = IP;
        this.devicePort = devicePort;
        if (productName.equals("B4A")) {
            this.B4A = true;
            this.B4J = false;
        } else if (productName.equals("B4J")) {
            this.B4A = false;
            this.B4J = true;
        } else {
            throw new RuntimeException("Unknown product name: " + productName);
        }
        Common.init();
        this.ideConnector = new DebugConnector(new Debug(), listenToIDEPort);
        Thread t = new Thread(this.ideConnector);
        t.setDaemon(true);
        if (listenToIDEPort != 0) {
            t.start();
        } else {
            this.deviceConnector = new ShellConnector(this, devicePort, IP);
            Thread connectorT = new Thread(this.deviceConnector);
            connectorT.setDaemon(true);
            connectorT.start();
        }
        RapidSub.loadData();
        Debug.ideConnector = this.ideConnector;
    }

    public void IdeConnectionStatus(boolean connected) {
        if (!connected) {
            if (this.deviceConnector != null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.exit();
        } else {
            Debug.deviceConnector = this.deviceConnector = new ShellConnector(this, this.devicePort, this.IP);
            if (!this.IP.equals("127.0.0.1")) {
                this.deviceConnector.timeoutToConnect = 60000;
            }
            Thread connectorT = new Thread(this.deviceConnector);
            connectorT.setDaemon(true);
            connectorT.start();
        }
    }

    public void exit() {
        System.out.println("exit");
        System.exit(0);
    }

    public void waitForTask() {
        try {
            debuggerIsReady.await();
            if (Thread.currentThread() != this.mainThread) {
                throw new RuntimeException("Wrong thread...");
            }
            while (true) {
                byte[] command = this.mainThreadTasks.take();
                switch (command[0]) {
                    case 2: {
                        Debug.dontPauseUntilEndOfChain = false;
                        this.codeChainStart(false, new EventData(this.din));
                        break;
                    }
                    case 7: {
                        this.virtualFiles();
                        break;
                    }
                    case 4: {
                        System.out.println("CONTINUE: " + Debug.waiting);
                        if (!Debug.waiting) break;
                        this.debugContinue();
                        return;
                    }
                    case 6: {
                        Debug.dontPauseUntilEndOfChain = true;
                        Debug.stackLimit = 0;
                        System.out.println("STOP_MESSAGE_LOOP: " + Debug.waiting);
                        if (Debug.waiting) {
                            this.debugContinue();
                            this.mainThreadTasks.put(new byte[]{6});
                        }
                        return;
                    }
                    case 5: {
                        System.out.println("GET_DEBUG_VAR");
                        ByteArrayInputStream bin = new ByteArrayInputStream(command, 1, command.length - 1);
                        Debug.remoteObjectArrivedFromDevice(new DataInputStream(bin));
                        break;
                    }
                    case 53: {
                        if (Debug.waiting) {
                            this.debugContinue();
                        }
                        throw new ReturnToCodeChainStartError();
                    }
                    case 54: {
                        if (Debug.waiting) {
                            this.debugContinue();
                        }
                        ByteBuffer bb = ByteBuffer.wrap(command, 1, 4);
                        Debug.runAfterNewExpression(bb.getInt());
                    }
                }
            }
        }
        catch (Exception se) {
            se.printStackTrace();
            return;
        }
    }

    @Override
    public void handleIncomingData(int firstByte, InputStream in) throws IOException {
        byte[] buffer;
        if (firstByte == 5) {
            try {
                DataInputStream din = new DataInputStream(in);
                int len = din.readInt();
                buffer = new byte[len + 1];
                buffer[0] = (byte)firstByte;
                din.readFully(buffer, 1, buffer.length - 1);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        } else {
            buffer = new byte[]{(byte)firstByte};
        }
        this.mainThreadTasks.add(buffer);
    }

    @Override
    public void connectionStatus(boolean connected) {
        System.out.println("connected: " + connected);
        if (connected) {
            this.din = new DataInputStream(this.deviceConnector.getMainInputStream());
            this.dout = new DataOutputStream(this.deviceConnector.getMainOutputStream());
            System.out.println("deviceIsReady.countDown");
            deviceIsReady.countDown();
            this.ideConnector.putTask(new byte[]{14});
        }
        if (!connected) {
            if (this.deviceConnector.connectedOnce) {
                System.exit(0);
            } else {
                System.exit(1);
            }
        }
    }

    private void virtualFiles() {
        File map = null;
        try {
            try {
                HashMap deviceFiles;
                System.out.println("virtualFiles");
                byte areThereAnyFilesOnDevice = this.din.readByte();
                if (areThereAnyFilesOnDevice == 1) {
                    int size = this.din.readInt();
                    byte[] mapData = new byte[size];
                    this.din.readFully(mapData);
                    ObjectInputStream oin = new ObjectInputStream(new GZIPInputStream(new ByteArrayInputStream(mapData)));
                    deviceFiles = (HashMap)oin.readObject();
                    oin.close();
                } else {
                    deviceFiles = new HashMap();
                }
                if (!Debug.useVirtualAssetsFolder) {
                    this.dout.writeInt(-1);
                } else {
                    File filesFolder = new File("../../../../Files/");
                    String rootPath = filesFolder.getCanonicalPath();
                    ArrayList<File> allFiles = new ArrayList<File>();
                    this.getAllFiles(filesFolder, allFiles);
                    HashMap<File, Long> mapOfFiles = new HashMap<File, Long>();
                    Iterator<File> it = allFiles.iterator();
                    while (it.hasNext()) {
                        File f = it.next();
                        long stamp = f.length() ^ f.lastModified();
                        mapOfFiles.put(f, stamp);
                        if (!deviceFiles.containsKey(f) || (Long)deviceFiles.get(f) != stamp) continue;
                        it.remove();
                    }
                    if (allFiles.size() > 0) {
                        map = new File(filesFolder, "_assets_map");
                        ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(map)));
                        oos.writeObject(mapOfFiles);
                        oos.close();
                        allFiles.add(map);
                    }
                    this.dout.writeInt(allFiles.size());
                    byte[] buffer = new byte[8192];
                    for (File f : allFiles) {
                        String folder;
                        System.out.println("sending: " + f);
                        if (f.getParentFile().equals(filesFolder)) {
                            folder = "";
                        } else {
                            StringBuilder sb = new StringBuilder();
                            File ff = f.getParentFile();
                            while (!ff.equals(filesFolder)) {
                                sb.insert(0, String.valueOf(ff.getName()) + (sb.length() > 0 ? "/" : ""));
                                ff = ff.getParentFile();
                            }
                            folder = sb.toString();
                        }
                        this.deviceConnector.writeObject(this.dout, folder);
                        this.deviceConnector.writeObject(this.dout, f.getName());
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        GZIPOutputStream gout = new GZIPOutputStream(bout);
                        int count = 0;
                        FileInputStream in = new FileInputStream(f);
                        while ((count = ((InputStream)in).read(buffer)) > 0) {
                            gout.write(buffer, 0, count);
                        }
                        ((InputStream)in).close();
                        gout.close();
                        byte[] data = bout.toByteArray();
                        this.dout.writeInt(data.length);
                        this.dout.write(data);
                    }
                }
                this.dout.flush();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (map != null) {
                map.delete();
            }
        }
    }

    private void getAllFiles(File folder, ArrayList<File> list) {
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                this.getAllFiles(f, list);
            } else {
                list.add(f);
            }
            ++n2;
        }
    }

    public void debugDontPrintErrors() throws IOException {
        this.dout.write(18);
    }

    private void debugContinue() throws IOException {
        this.deviceConnector.sendControlMessage(new byte[]{4});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void codeChainStart(boolean nested, EventData eventData) throws Exception {
        Object ret;
        block19: {
            Throwable ex2;
            String methodName = eventData.method.getStringToSend();
            if (this.B4A && (methodName.equals("activity_pause") || methodName.endsWith("_sensorchanged"))) {
                Debug.dontPauseUntilEndOfChain = true;
            }
            ret = null;
            if (methodName.equals("CREATE")) {
                this.createSingletonModule(eventData.className, eventData.args);
            }
            PCBA ba = (PCBA)this.eventTargets.get(eventData.className).get();
            block9: while (true) {
                try {
                    this.baStack.push(ba);
                    RapidSub.firstCall = true;
                    ret = ba.raiseEvent(eventData.method.getStringToSend(), eventData.args);
                    this.baStack.pop();
                    break block19;
                }
                catch (Throwable ex2) {
                    try {
                        while (true) {
                            if (!(ex2 instanceof InvocationTargetException)) {
                                if (!(ex2 instanceof ReturnToCodeChainStartError)) break block9;
                                System.out.println("Return to code chain start");
                                continue block9;
                            }
                            ex2 = ex2.getCause();
                        }
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        this.baStack.pop();
                        continue;
                    }
                }
                break;
            }
            if (ex2 instanceof RollBackAfterMsgboxError) {
                System.out.println("catching RollBackAfterMsgboxError, nested=" + nested);
                if (nested) {
                    throw (Error)ex2;
                }
            } else {
                this.handleError(ex2);
            }
        }
        Runtime.getRuntime().gc();
        List<Integer> toClean = RemoteObject.getPhantoms();
        if (toClean.size() > 0) {
            this.dout.write(5);
            this.deviceConnector.writeList(this.dout, toClean.toArray());
        }
        if (eventData.state != null) {
            eventData.state.setStateBeforeUserSub();
        }
        this.dout.write(4);
        this.deviceConnector.writeObject(this.dout, ret);
        int goodChainCall = RapidSub.firstCallIsGood && !RapidSub.firstCall ? 1 : 0;
        this.dout.write(goodChainCall);
        RapidSub.firstCallIsGood = false;
        RapidSub.firstCall = false;
        this.dout.flush();
        if (nested) return;
        try {
            byte b = (Byte)this.deviceConnector.readObject(this.din, false);
            if (b == 4) return;
            throw new RuntimeException("Invalid stack state: " + b);
        }
        catch (ShellConnector.DeviceException de) {
            this.handleError(de);
        }
    }

    private void createSingletonModule(B4XTypes.DeviceClass className, Object[] args) throws Exception {
        IRemote ir = (IRemote)new B4XTypes.PCClass(className).getJavaClass().newInstance();
        PCBA ba = ir.create(args);
        System.out.println("createModule: " + className);
        this.eventTargets.put(className, new WeakReference<PCBA>(ba));
        this.singletons.put(ir.getClass(), ir);
        RapidSub.alreadySetVars.remove(RapidSub.moduleToObject.get(new B4XTypes.B4XClass(className)));
        RemoteObject ro = ir.getRemoteMe();
        if (ro.slot != 0) {
            RapidSub.moduleToObject.put(new B4XTypes.B4XClass(className), ro);
        }
        System.out.println("createModule: " + className + ", " + RapidSub.moduleToObject.keySet());
        RemoteObject processBA = (RemoteObject)args[1];
        Object[] subs = this.getSubsFromBA(ba);
        this.dout.write(3);
        this.deviceConnector.writeObject(this.dout, processBA);
        this.deviceConnector.writeList(this.dout, subs);
        this.loadClassesInformation();
    }

    private void loadClassesInformation() throws Exception {
        if (!ClassesManager.subsFilled) {
            ClassesManager.subsFilled = true;
            this.dout.write(19);
            this.dout.writeInt(ClassesManager.classes.size());
            for (B4XTypes.B4XClass cn : ClassesManager.classes) {
                PCBA classBA = (PCBA)new B4XTypes.PCClass(cn).getJavaClass().getDeclaredField("staticBA").get(null);
                Object[] subs = this.getSubsFromBA(classBA);
                this.deviceConnector.writeObject(this.dout, cn.getStringToSend());
                this.deviceConnector.writeList(this.dout, subs);
                B4XTypes.DeviceClass deviceClass = new B4XTypes.DeviceClass(cn);
                this.eventTargets.put(deviceClass, new WeakReference<PCBA>(classBA));
            }
        }
    }

    private Object[] getSubsFromBA(PCBA ba) {
        Object[] subs = new Object[ba.htSubs.size()];
        int i = 0;
        for (B4XTypes.HtSubName sub : ba.htSubs.keySet()) {
            subs[i] = sub.getStringToSend();
            ++i;
        }
        return subs;
    }

    private void handleError(Throwable e) throws Exception {
        int line;
        String error;
        e.printStackTrace();
        B4XTypes.B4XClass module = null;
        if (e instanceof ShellConnector.DeviceException) {
            error = "";
            line = ((ShellConnector.DeviceException)e).line;
            module = ((ShellConnector.DeviceException)e).module;
        } else {
            error = "An error occurred: \n(Line: " + BA.debugLineNum + ") " + BA.debugLine + "\n" + e.toString();
            line = BA.debugLineNum;
            module = Debug.deviceModule;
        }
        if (module != null) {
            Debug.jumpToLine(module, line);
        }
        System.out.println("handleError: " + e.toString() + ", " + line + ", " + module);
        BA.rdebugUtils.runMethod(true, "LogErrorAndExit", error).get();
        if (System.getProperty("continueOnErrors", "false").equals("false")) {
            Thread.sleep(100L);
            Debug.stopProgram();
        }
    }

    public void debugPause(RemoteObject ba, int line, String text) throws Exception {
        this.dout.write(14);
        this.deviceConnector.writeObject(this.dout, ba);
        this.dout.writeInt(line);
        this.deviceConnector.writeObject(this.dout, text);
        this.dout.flush();
    }

    public void createObject(RemoteObject ro) throws Exception {
        this.dout.write(2);
        this.deviceConnector.writeObject(this.dout, ro.JavaClass);
        this.dout.writeInt(ro.slot);
    }

    public void createArray(RemoteObject ro, int[] lengths, Object[] values) throws Exception {
        this.dout.write(9);
        this.deviceConnector.writeObject(this.dout, ro.JavaClass);
        this.dout.writeByte(lengths.length);
        Object[] objectArray = lengths;
        int n = lengths.length;
        int n2 = 0;
        while (n2 < n) {
            int l = objectArray[n2];
            this.dout.writeInt(l);
            ++n2;
        }
        this.dout.writeInt(values.length);
        objectArray = values;
        n = values.length;
        n2 = 0;
        while (n2 < n) {
            int o = objectArray[n2];
            this.deviceConnector.writeObject(this.dout, o);
            ++n2;
        }
        this.dout.writeInt(ro.slot);
    }

    public Object getValue(int slot) throws Exception {
        this.dout.write(12);
        this.dout.writeInt(slot);
        this.dout.flush();
        Object o = this.deviceConnector.readObject(this.din, false);
        return o;
    }

    public void getArrayElement(RemoteObject ro, int targetSlot, RemoteObject[] index) throws Exception {
        this.dout.write(10);
        this.deviceConnector.writeObject(this.dout, ro);
        this.deviceConnector.writeObject(this.dout, index);
        this.dout.writeInt(targetSlot);
    }

    public void getField(RemoteObject ro, int targetSlot, String field) throws Exception {
        this.dout.write(7);
        this.deviceConnector.writeObject(this.dout, ro);
        this.deviceConnector.writeObject(this.dout, field);
        this.dout.writeInt(targetSlot);
    }

    public void setArrayElement(RemoteObject ro, Object value, RemoteObject[] index) throws Exception {
        this.dout.write(11);
        this.deviceConnector.writeObject(this.dout, ro);
        this.deviceConnector.writeObject(this.dout, index);
        this.deviceConnector.writeObject(this.dout, value);
    }

    public void setField(RemoteObject ro, String field, Object value) throws Exception {
        this.dout.write(8);
        this.deviceConnector.writeObject(this.dout, ro);
        this.deviceConnector.writeObject(this.dout, field);
        this.deviceConnector.writeObject(this.dout, value);
    }

    public void runMethod(RemoteObject ro, int targetSlot, String method, Object[] args) throws Exception {
        this.dout.write(1);
        this.deviceConnector.writeObject(this.dout, ro);
        this.deviceConnector.writeObject(this.dout, method);
        this.deviceConnector.writeList(this.dout, args);
        this.dout.writeInt(targetSlot);
    }

    public void runMethodWithSync(RemoteObject ro, int targetSlot, String method, Object[] args, StateHolder state) throws Exception {
        byte b;
        this.dout.write(13);
        this.deviceConnector.writeObject(this.dout, ro);
        this.deviceConnector.writeObject(this.dout, method);
        this.deviceConnector.writeList(this.dout, args);
        this.dout.writeInt(targetSlot);
        this.dout.flush();
        while ((b = this.din.readByte()) != 13) {
            if (b == 1) {
                EventData ed = new EventData(this.din);
                ed.state = state;
                if (state != null) {
                    state.getStateAfterUserSub();
                }
                this.codeChainStart(true, ed);
                continue;
            }
            if (b == 2) {
                PCBA ba = this.B4J ? (PCBA)this.eventTargets.get(new B4XTypes.DeviceClass((String)this.deviceConnector.readObject(this.din, false))).get() : this.baStack.peek();
                Class<?> target = ba.targetClass;
                Object[] layoutArgs = this.deviceConnector.readList(this.din);
                int i = 0;
                while (i < layoutArgs.length) {
                    block16: {
                        String name = (String)layoutArgs[i];
                        Object o = layoutArgs[i + 1];
                        try {
                            Field field = target.getField("_" + name);
                            if (field == null) break block16;
                            try {
                                field.set(ba.eventsTarget, o);
                            }
                            catch (IllegalArgumentException e) {
                                throw new RuntimeException("Field " + name + " was declared with the wrong type.");
                            }
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            // empty catch block
                        }
                    }
                    i += 2;
                }
                continue;
            }
            if (b == 3) {
                ArrayList<Object[]> customViews = new ArrayList<Object[]>();
                do {
                    Object[] params = this.deviceConnector.readList(this.din);
                    customViews.add(params);
                } while ((b = this.din.readByte()) == 3);
                if (b != 13) {
                    throw new RuntimeException("RUN_METHOD_WITH_SYNC expected");
                }
                for (Object[] params : customViews) {
                    RemoteObject view = (RemoteObject)params[0];
                    try {
                        Class<?> cls = Class.forName(view.JavaClass);
                        view.runClassMethod(cls, "_initialize", params[1], params[2], params[3]);
                        view.runClassMethod(cls, "_designercreateview", params[4], params[5], params[6]);
                    }
                    catch (ClassNotFoundException cnf) {
                        view.runVoidMethod("_initialize", params[1], params[2], params[3]);
                        view.runVoidMethod("_designercreateview", params[4], params[5], params[6]);
                    }
                }
                break;
            }
            if (b != 4) continue;
            if (this.din.readByte() != 13) {
                throw new RuntimeException("Unexpected value.");
            }
            System.out.println("throwing RollBackAfterMsgboxError");
            throw new RollBackAfterMsgboxError();
        }
    }

    public RemoteObject runUserSub(RemoteObject ro, String subModule, boolean immutable, String method, Object[] args) throws Exception {
        B4XTypes.SubName subName = new B4XTypes.SubName(method);
        B4XTypes.DeviceSubName deviceSubName = new B4XTypes.DeviceSubName(subName, args.length);
        BA.debugLineNum = 0;
        RapidSub rs = RapidSub.get(new B4XTypes.B4XClass(subModule), method);
        StateHolder sh = StateHolder.createState(rs);
        sh.setStateBeforeUserSub();
        RemoteObject result = RemoteObject.createFutureHolder(immutable);
        ArrayList<Object> breakpoints = new ArrayList<Object>();
        boolean sync = rs.sync;
        for (RapidSub called : rs.callSubs) {
            if (!called.dirty && (called.numberOfBreakpoints <= 0 || RapidSub.disableDebuggerOptimizations)) continue;
            breakpoints.add(called.module.getStringToSend());
            breakpoints.add(called.name.getStringToSend());
            sync = true;
        }
        this.dout.write(20);
        this.deviceConnector.writeList2(this.dout, breakpoints);
        if (this.baStack.size() > 1) {
            sync = true;
        }
        if (!sync) {
            this.runMethod(ro, result.slot, deviceSubName.getStringToSend(), args);
        } else {
            this.runMethodWithSync(ro, result.slot, deviceSubName.getStringToSend(), args, sh);
        }
        sh.getStateAfterUserSub();
        BA.rdebugUtils.setField("currentModule", Debug.deviceModule.getStringToSend());
        return result;
    }

    public void runVoidMethod(RemoteObject ro, String method, Object[] args) throws Exception {
        if (this.B4J && ro.JavaClass != null && ro.JavaClass.equals("anywheresoftware.b4a.keywords.Common")) {
            if (method.equals("StartMessageLoop")) {
                this.startMessageLoop();
                return;
            }
            if (method.equals("StopMessageLoop")) {
                if (Debug.waiting) {
                    Debug.stopWaiting();
                }
                RDebug.INSTANCE.mainThreadTasks.add(new byte[]{6});
            }
        }
        this.dout.write(6);
        this.deviceConnector.writeObject(this.dout, ro);
        this.deviceConnector.writeObject(this.dout, method);
        this.deviceConnector.writeList(this.dout, args);
    }

    private void startMessageLoop() throws IOException {
        this.dout.write(15);
        this.dout.flush();
        this.waitForTask();
    }

    @Override
    public Object readRemoteObject(DataInputStream din, boolean unwrapRemoteObject, boolean array) throws Exception {
        if (array) {
            throw new RuntimeException("Array not expected...");
        }
        int slot = din.readInt();
        String javaClass = null;
        javaClass = (String)this.deviceConnector.readObject(din, false);
        RemoteObject ro = RemoteObject.createFromDevice(javaClass, slot);
        return ro;
    }

    @Override
    public void writeRemoteObject(DataOutputStream dout, Object o, boolean stringsCacheDisabled) throws Exception {
        if (o.getClass().isArray()) {
            dout.writeByte(13);
            RemoteObject[] ros = (RemoteObject[])o;
            dout.writeShort(ros.length);
            RemoteObject[] remoteObjectArray = ros;
            int n = ros.length;
            int n2 = 0;
            while (n2 < n) {
                RemoteObject ro = remoteObjectArray[n2];
                this.deviceConnector.writeObject(dout, ro, stringsCacheDisabled);
                ++n2;
            }
        } else {
            RemoteObject ro = (RemoteObject)o;
            if (ro == RemoteObject.NULL_OBJECT) {
                this.deviceConnector.writeObject(dout, null);
            } else if (ro.wrappedValue != null) {
                this.deviceConnector.writeObject(dout, ro.wrappedValue, stringsCacheDisabled);
            } else {
                dout.writeByte(8);
                dout.writeInt(ro.slot);
                if (ro.slot == 0) {
                    this.deviceConnector.writeObject(dout, ro.JavaClass, stringsCacheDisabled);
                }
            }
        }
    }

    class EventData {
        public B4XTypes.DeviceClass className;
        public B4XTypes.HtSubName method;
        public Object[] args;
        public StateHolder state;

        public EventData(DataInputStream din) throws Exception {
            this.className = new B4XTypes.DeviceClass((String)RDebug.this.deviceConnector.readObject(din, false));
            this.method = new B4XTypes.HtSubName((String)RDebug.this.deviceConnector.readObject(din, false));
            this.args = RDebug.this.deviceConnector.readList(din);
        }
    }

    public static interface IRemote {
        public PCBA create(Object[] var1) throws ClassNotFoundException;

        public boolean isSingleton();

        public RemoteObject getRemoteMe();
    }

    public static class ReturnToCodeChainStartError
    extends Error {
    }

    public static class RollBackAfterMsgboxError
    extends Error {
    }

    public static class StateHolder {
        private static final HashMap<RapidSub, StateHolder> cache = new HashMap();
        private Field[] usedFields;
        private Field[] assignedFields;
        private Object[] assigned;
        private RapidSub rs;

        private StateHolder() {
        }

        public static void clearCache() {
            cache.clear();
        }

        public static StateHolder createState(RapidSub rs) throws Exception {
            RapidSub.RapidVar v;
            StateHolder sh = cache.get(rs);
            if (sh != null) {
                return sh;
            }
            sh = new StateHolder();
            cache.put(rs, sh);
            sh.rs = rs;
            sh.usedFields = new Field[rs.usedVars.size()];
            int i = 0;
            while (i < rs.usedVars.size()) {
                v = rs.usedVars.get(i);
                sh.usedFields[i] = RapidSub.userClasses.get(v.module).getField("_" + v.name);
                ++i;
            }
            sh.assigned = new Object[rs.assignedVars.size() * 3];
            sh.assignedFields = new Field[rs.assignedVars.size()];
            i = 0;
            while (i < rs.assignedVars.size()) {
                v = rs.assignedVars.get(i);
                sh.assigned[i * 3 + 1] = "_" + v.name;
                sh.assignedFields[i] = RapidSub.userClasses.get(v.module).getField("_" + v.name);
                ++i;
            }
            return sh;
        }

        public void setStateBeforeUserSub() throws Exception {
            if (this.rs.usedVars.size() == 0) {
                return;
            }
            ArrayList<Object> ul = new ArrayList<Object>();
            int i = 0;
            while (i < this.rs.usedVars.size()) {
                RapidSub.RapidVar v = this.rs.usedVars.get(i);
                Object target = RapidSub.moduleToObject.get(v.module);
                HashSet<RapidSub.RapidVar> objectGoodVars = RapidSub.alreadySetVars.get(target);
                if (objectGoodVars == null) {
                    objectGoodVars = new HashSet();
                    RapidSub.alreadySetVars.put(target, objectGoodVars);
                }
                if (objectGoodVars.add(v)) {
                    Object tar = target;
                    if (target instanceof RemoteObject && ((RemoteObject)target).slot == 0) {
                        tar = ((RemoteObject)target).JavaClass;
                    }
                    ul.add(tar);
                    ul.add("_" + v.name);
                    ul.add(this.usedFields[i].get(null));
                }
                ++i;
            }
            if (ul.size() > 0) {
                RDebug.INSTANCE.dout.write(16);
                RDebug.INSTANCE.deviceConnector.writeList2(RDebug.INSTANCE.dout, ul);
            }
        }

        public void getStateAfterUserSub() throws Exception {
            if (this.rs.assignedVars.size() == 0) {
                return;
            }
            RDebug.INSTANCE.dout.write(17);
            int i = 0;
            while (i < this.rs.assignedVars.size()) {
                int slot;
                RapidSub.RapidVar v = this.rs.assignedVars.get(i);
                this.assigned[i * 3] = RapidSub.moduleToObject.get(v.module);
                RemoteObject currentValue = (RemoteObject)this.assignedFields[i].get(null);
                if (currentValue.wrappedValue == null && currentValue.slot != 0) {
                    slot = currentValue.slot;
                } else {
                    RemoteObject av = RemoteObject.createFutureHolder(false);
                    this.assignedFields[i].set(null, av);
                    slot = av.slot;
                }
                this.assigned[i * 3 + 2] = slot;
                ++i;
            }
            RDebug.INSTANCE.deviceConnector.writeList(RDebug.INSTANCE.dout, this.assigned);
        }
    }
}

