/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a.pc;

import anywheresoftware.b4a.pc.B4XTypes;
import anywheresoftware.b4a.pc.ClassesManager;
import anywheresoftware.b4a.pc.Debug;
import anywheresoftware.b4a.pc.RDebug;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class RapidSub {
    public static final HashMap<B4XTypes.B4XClass, Object> moduleToObject = new HashMap();
    public static final HashMap<B4XTypes.B4XClass, HashMap<String, RapidSub>> modules = new HashMap();
    public static final HashMap<B4XTypes.B4XClass, Class<?>> userClasses = new HashMap();
    public static final HashMap<Object, HashSet<RapidVar>> alreadySetVars = new HashMap();
    public B4XTypes.SubName name;
    public B4XTypes.B4XClass module;
    public boolean sync;
    public boolean dirty;
    public int startLine;
    public int endLine;
    public int numberOfBreakpoints;
    public final List<RapidVar> usedVars = new ArrayList<RapidVar>();
    public final List<RapidVar> assignedVars = new ArrayList<RapidVar>();
    public final List<RapidSub> callSubs = new ArrayList<RapidSub>();
    public static String packageName;
    public static boolean firstCall;
    public static boolean firstCallIsGood;
    public static boolean disableDebuggerOptimizations;

    public static boolean canDelegate(String sub) {
        boolean canDelegate;
        RapidSub rs = RapidSub.get(Debug.deviceModule, sub);
        boolean bl = canDelegate = !rs.dirty && rs.numberOfBreakpoints == 0 && Debug.stackLimit == 0;
        if (canDelegate && disableDebuggerOptimizations) {
            for (RapidSub called : rs.callSubs) {
                if (called.numberOfBreakpoints <= 0) continue;
                canDelegate = false;
                break;
            }
        }
        System.out.println(Debug.deviceModule + ": " + sub + " can delegate? " + canDelegate);
        if (!canDelegate) {
            for (RapidVar rv : rs.assignedVars) {
                Object target = moduleToObject.get(rv.module);
                HashSet<RapidVar> set = alreadySetVars.get(target);
                if (set == null) continue;
                set.remove(rv);
            }
        }
        if (firstCall) {
            firstCallIsGood = canDelegate && !rs.sync;
            firstCall = false;
        }
        return canDelegate;
    }

    public static void codeSwap() {
        RDebug.StateHolder.clearCache();
        alreadySetVars.clear();
        RapidSub.loadData();
    }

    public static void loadData() {
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("subs.txt"), "UTF8"));
            packageName = br.readLine();
            disableDebuggerOptimizations = br.readLine().equals("1");
            ClassesManager.readFromFile(br);
            while ((line = br.readLine()) != null) {
                String[] first = line.split(",");
                RapidSub rs = RapidSub.getAtLoad(new B4XTypes.B4XClass(first[0]), first[1]);
                rs.sync = first[2].equals("1");
                rs.dirty = first[3].equals("1");
                rs.startLine = Integer.parseInt(first[4]);
                rs.endLine = Integer.parseInt(first[5]);
                rs.usedVars.clear();
                rs.assignedVars.clear();
                rs.callSubs.clear();
                String[] second = br.readLine().split(",");
                int i = 0;
                while (i < second.length && second.length > 1) {
                    B4XTypes.B4XClass bc = second[i].length() == 0 ? rs.module : new B4XTypes.B4XClass(second[i]);
                    RapidVar v = new RapidVar(bc, second[i + 1]);
                    rs.usedVars.add(v);
                    i += 2;
                }
                String[] third = br.readLine().split(",");
                int i2 = 0;
                while (i2 < third.length && third.length > 1) {
                    B4XTypes.B4XClass bc = third[i2].length() == 0 ? rs.module : new B4XTypes.B4XClass(third[i2]);
                    RapidVar v = new RapidVar(bc, third[i2 + 1]);
                    rs.assignedVars.add(v);
                    i2 += 2;
                }
                String[] four = br.readLine().split(",");
                int i3 = 0;
                while (i3 < four.length && four.length > 1) {
                    B4XTypes.B4XClass bc = four[i3].length() == 0 ? rs.module : new B4XTypes.B4XClass(four[i3]);
                    RapidSub sub = RapidSub.getAtLoad(bc, four[i3 + 1]);
                    rs.callSubs.add(sub);
                    i3 += 2;
                }
            }
            br.close();
        }
        catch (Exception e) {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            System.out.println(new File("subs.txt").getAbsolutePath());
            throw new RuntimeException(e);
        }
    }

    public static RapidSub get(B4XTypes.B4XClass module, String name) {
        HashMap<String, RapidSub> moduleSubs = modules.get(module);
        if (moduleSubs == null) {
            return null;
        }
        return moduleSubs.get(name);
    }

    private static RapidSub getAtLoad(B4XTypes.B4XClass module, String name) throws ClassNotFoundException {
        RapidSub rs;
        HashMap<String, RapidSub> moduleSubs = modules.get(module);
        if (moduleSubs == null) {
            moduleSubs = new HashMap();
            modules.put(module, moduleSubs);
            userClasses.put(module, new B4XTypes.PCClass(module).getJavaClass());
        }
        if ((rs = moduleSubs.get(name)) == null) {
            rs = new RapidSub();
            rs.module = module;
            rs.name = new B4XTypes.SubName(name);
            moduleSubs.put(name, rs);
        }
        return rs;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.module == null ? 0 : this.module.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RapidSub other = (RapidSub)obj;
        if (this.module == null ? other.module != null : !this.module.equals(other.module)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public static class RapidVar {
        public final B4XTypes.B4XClass module;
        public final String name;

        public RapidVar(B4XTypes.B4XClass module, String name) {
            this.module = module;
            this.name = name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.module == null ? 0 : this.module.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            RapidVar other = (RapidVar)obj;
            if (this.module == null ? other.module != null : !this.module.equals(other.module)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

