/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a.pc;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.keywords.Common;
import anywheresoftware.b4a.pc.PCBA;
import anywheresoftware.b4a.pc.RDebug;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class RemoteObject {
    public static final int NULL_SLOT = 0;
    public static final int WRAPPED_SLOT = 1;
    private static int slotCounter = 1;
    private static final ReferenceQueue<RemoteObject> referenceQueue = new ReferenceQueue();
    private static final HashSet<MyPhantomReference> phantoms = new HashSet();
    public static final RemoteObject NULL_OBJECT = new RemoteObject(0, null, true);
    public final int slot;
    public final String JavaClass;
    private final boolean immutable;
    public Object wrappedValue;
    private static final HashMap<String, Method> commonMethods = new HashMap();
    private static final HashMap<String, Field> commonFields = new HashMap();
    private static final MethodCache stringMethodsCache = new MethodCache();
    private int arrayLen;

    static {
        AccessibleObject[] accessibleObjectArray = Common.class.getDeclaredMethods();
        int n = accessibleObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = accessibleObjectArray[n2];
            commonMethods.put(m.getName(), m);
            ++n2;
        }
        accessibleObjectArray = Common.class.getDeclaredFields();
        n = accessibleObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            AccessibleObject f = accessibleObjectArray[n2];
            commonFields.put(((Field)f).getName(), (Field)f);
            ++n2;
        }
    }

    public static List<Integer> getPhantoms() {
        MyPhantomReference p;
        ArrayList<Integer> list = new ArrayList<Integer>();
        while ((p = (MyPhantomReference)referenceQueue.poll()) != null) {
            if (p.slot != 0 && p.slot != 1) {
                list.add(p.slot);
            }
            p.clear();
            phantoms.remove(p);
        }
        return list;
    }

    private RemoteObject(int slot, String JavaClass, boolean immutable) {
        this.slot = slot;
        this.JavaClass = JavaClass;
        this.immutable = immutable;
        MyPhantomReference p = new MyPhantomReference(this, referenceQueue);
        phantoms.add(p);
    }

    public static RemoteObject createFromDevice(String JavaClass, int slot) {
        return new RemoteObject(slot, JavaClass, false);
    }

    public static RemoteObject declareNull(String JavaClass) {
        return new RemoteObject(0, JavaClass, true);
    }

    public static RemoteObject createFutureHolder(boolean immutable) {
        return new RemoteObject(++slotCounter, null, immutable);
    }

    public static RemoteObject createImmutable(Object value) {
        if (value == null) {
            return NULL_OBJECT;
        }
        if (value instanceof RemoteObject) {
            throw new RuntimeException("Local value expected.");
        }
        RemoteObject ro = new RemoteObject(1, null, true);
        ro.wrappedValue = value;
        return ro;
    }

    public static RemoteObject createNew(String JavaClass) throws Exception {
        RemoteObject ro = new RemoteObject(++slotCounter, JavaClass, false);
        RDebug.INSTANCE.createObject(ro);
        return ro;
    }

    public static RemoteObject createNewArray(String JavaClass, int[] lengths, Object[] values) throws Exception {
        RemoteObject ro = new RemoteObject(++slotCounter, JavaClass, false);
        RDebug.INSTANCE.createArray(ro, lengths, values);
        ro.arrayLen = lengths[0];
        return ro;
    }

    public RemoteObject getObject() throws Exception {
        return this.runMethod(false, "getObject", new Object[0]);
    }

    public void setObject(Object o) throws Exception {
        this.runVoidMethod("setObject", o);
    }

    public RemoteObject getObjectOrNull() throws Exception {
        return this.runMethod(false, "getObjectOrNull", new Object[0]);
    }

    public RemoteObject runMethodAndSync(boolean immutable, String method, Object ... args) throws Exception {
        RemoteObject holder = RemoteObject.createFutureHolder(immutable);
        RDebug.INSTANCE.runMethodWithSync(this, holder.slot, method, args, null);
        return holder;
    }

    public void runVoidMethodAndSync(String method, Object ... args) throws Exception {
        this.runMethodAndSync(true, method, args);
    }

    public RemoteObject runClassMethod(Class<?> cls, String method, Object ... args) throws Exception {
        Field baf = cls.getField("staticBA");
        PCBA ba = (PCBA)baf.get(null);
        return (RemoteObject)ba.raiseEvent(method.substring(1), RemoteObject.addItemToArray(this, args));
    }

    public static Object[] addItemToArray(Object item, Object[] args) {
        if (args == null) {
            args = new Object[]{};
        }
        Object[] argsWithRef = new Object[args.length + 1];
        argsWithRef[0] = item;
        System.arraycopy(args, 0, argsWithRef, 1, args.length);
        return argsWithRef;
    }

    public RemoteObject runMethod(boolean immutable, String method, Object ... args) throws Exception {
        RemoteObject ths = this;
        if (this.JavaClass != null && this.JavaClass.equals("anywheresoftware.b4a.keywords.Common") && commonMethods.containsKey(method) || this.wrappedValue instanceof String) {
            boolean allWrapped = true;
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Object a = objectArray[n2];
                if (a instanceof RemoteObject && ((RemoteObject)a).wrappedValue == null) {
                    allWrapped = false;
                    break;
                }
                ++n2;
            }
            if (allWrapped) {
                if (this.JavaClass != null && this.JavaClass.equals("anywheresoftware.b4a.keywords.Common")) {
                    Method m = commonMethods.get(method);
                    return RemoteObject.createImmutable(m.invoke(null, args));
                }
                if (!method.equals("getBytes")) {
                    int i = 0;
                    while (i < args.length) {
                        if (args[i] instanceof RemoteObject) {
                            args[i] = ((RemoteObject)args[i]).wrappedValue;
                        }
                        ++i;
                    }
                    Method m = RemoteObject.getMethod(method, args);
                    return RemoteObject.createImmutable(m.invoke(this.wrappedValue, args));
                }
            }
        }
        RemoteObject holder = RemoteObject.createFutureHolder(immutable);
        RDebug.INSTANCE.runMethod(ths, holder.slot, method, args);
        return holder;
    }

    public void runVoidMethod(String method, Object ... args) throws Exception {
        RDebug.INSTANCE.runVoidMethod(this, method, args);
    }

    public RemoteObject runUserSub(boolean immutable, String module, String method, Object ... args) throws Exception {
        return RDebug.INSTANCE.runUserSub(this, module, immutable, method, args);
    }

    public RemoteObject getField(boolean immutable, String field) throws Exception {
        if (this.JavaClass != null && this.JavaClass.equals("anywheresoftware.b4a.keywords.Common") && commonFields.containsKey(field)) {
            Field f = commonFields.get(field);
            Object value = f.get(null);
            return RemoteObject.createImmutable(value);
        }
        if (field.equals("length") && this.arrayLen != 0) {
            return RemoteObject.createImmutable(this.arrayLen);
        }
        RemoteObject holder = RemoteObject.createFutureHolder(immutable);
        RDebug.INSTANCE.getField(this, holder.slot, field);
        return holder;
    }

    public void setField(String field, Object value) throws Exception {
        RDebug.INSTANCE.setField(this, field, value);
    }

    public void setArrayElement(Object value, RemoteObject ... index) throws Exception {
        RDebug.INSTANCE.setArrayElement(this, value, index);
    }

    public RemoteObject getArrayElement(boolean immutable, RemoteObject ... index) throws Exception {
        RemoteObject holder = RemoteObject.createFutureHolder(immutable);
        RDebug.INSTANCE.getArrayElement(this, holder.slot, index);
        return holder;
    }

    public static RemoteObject concat(RemoteObject ... strings) throws Exception {
        boolean allWrapped = true;
        RemoteObject[] remoteObjectArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            RemoteObject r = remoteObjectArray[n2];
            if (r.wrappedValue == null) {
                allWrapped = false;
                break;
            }
            ++n2;
        }
        if (allWrapped) {
            String s = "";
            RemoteObject[] remoteObjectArray2 = strings;
            int n3 = strings.length;
            n = 0;
            while (n < n3) {
                RemoteObject r = remoteObjectArray2[n];
                String com = r.wrappedValue instanceof Number ? (String)BA.NumberToString(r).get() : String.valueOf(r.wrappedValue);
                s = String.valueOf(s) + com;
                ++n;
            }
            return RemoteObject.createImmutable(s);
        }
        return BA.rdebugUtils.runMethod(true, "concat", new Object[]{strings});
    }

    public static boolean solveBoolean(String operations, RemoteObject ... operands) throws Exception {
        boolean allWrapped = true;
        RemoteObject[] remoteObjectArray = operands;
        int n = operands.length;
        int n2 = 0;
        while (n2 < n) {
            RemoteObject r = remoteObjectArray[n2];
            if (r.wrappedValue == null) {
                allWrapped = false;
                break;
            }
            ++n2;
        }
        if (allWrapped) {
            int operandsIndex = 0;
            boolean currentResult = false;
            int i = 0;
            while (i < operations.length()) {
                char operator = operations.charAt(i);
                if (operator == '=' || operator == '!') {
                    currentResult = RemoteObject.equals(operands[operandsIndex++].wrappedValue, operands[operandsIndex++].wrappedValue);
                    if (operator == '!') {
                        currentResult = !currentResult;
                    }
                } else if (operator == '.') {
                    currentResult = (Boolean)operands[operandsIndex++].wrappedValue;
                } else if (operator == 'i') {
                    Object target = operands[operandsIndex++].wrappedValue;
                    if (target == null) {
                        currentResult = false;
                    }
                    Class<?> cls = Class.forName("java.lang." + (String)operands[operandsIndex++].wrappedValue);
                    currentResult = cls.isAssignableFrom(target.getClass());
                } else if (operator == 'n') {
                    currentResult = false;
                } else if (operator == 'N') {
                    currentResult = true;
                } else {
                    Number n1 = (Number)operands[operandsIndex++].wrappedValue;
                    Number n22 = (Number)operands[operandsIndex++].wrappedValue;
                    int compare = n1 instanceof Long ? ((Long)n1).compareTo(n22.longValue()) : Double.compare(n1.doubleValue(), n22.doubleValue());
                    if (operator == '<') {
                        currentResult = compare < 0;
                    } else if (operator == '>') {
                        currentResult = compare > 0;
                    } else if (operator == 'k') {
                        currentResult = compare <= 0;
                    } else if (operator == 'g') {
                        currentResult = compare >= 0;
                    }
                }
                ++i;
            }
            return currentResult;
        }
        return (Boolean)BA.rdebugUtils.runMethod(true, "solveBoolean", operations, operands).get();
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            if (o1 instanceof Long) {
                return ((Number)o1).longValue() == ((Number)o2).longValue();
            }
            return ((Number)o1).doubleValue() == ((Number)o2).doubleValue();
        }
        return o1.equals(o2);
    }

    public static RemoteObject solve(RemoteObject[] numbers, String operations, int numberOfSums, int calcType) throws Exception {
        boolean allWrapped = true;
        RemoteObject[] remoteObjectArray = numbers;
        int n = numbers.length;
        int n2 = 0;
        while (n2 < n) {
            RemoteObject r = remoteObjectArray[n2];
            if (r.wrappedValue == null) {
                allWrapped = false;
                break;
            }
            ++n2;
        }
        if (allWrapped) {
            int i;
            int sumIndex;
            Object[] sums;
            if (calcType == 0) {
                sums = new double[numberOfSums + 1];
                sumIndex = 0;
                i = 0;
                while (i < numbers.length - 1) {
                    char o = operations.charAt(i);
                    double d = ((Number)numbers[i].get()).doubleValue();
                    while (i < operations.length() && ((o = operations.charAt(i)) == '*' || o == '/' || o == '%')) {
                        d = o == '*' ? (d *= ((Number)numbers[i + 1].get()).doubleValue()) : (o == '/' ? (d /= ((Number)numbers[i + 1].get()).doubleValue()) : (d %= ((Number)numbers[i + 1].get()).doubleValue()));
                        ++i;
                    }
                    sums[sumIndex++] = d;
                    ++i;
                }
                if (sumIndex < sums.length) {
                    sums[sumIndex] = ((Number)numbers[numbers.length - 1].get()).doubleValue();
                }
                sumIndex = 1;
                double sum = sums[0];
                int i2 = 0;
                while (i2 < numbers.length - 1) {
                    char o = operations.charAt(i2);
                    if (o == '+') {
                        sum += sums[sumIndex++];
                    } else if (o == '-') {
                        sum -= sums[sumIndex++];
                    }
                    ++i2;
                }
                return RemoteObject.createImmutable(sum);
            }
            if (calcType == 1) {
                sums = new int[numberOfSums + 1];
                sumIndex = 0;
                i = 0;
                while (i < numbers.length - 1) {
                    char o = operations.charAt(i);
                    int d = ((Number)numbers[i].get()).intValue();
                    while (i < operations.length() && ((o = operations.charAt(i)) == '*' || o == '/' || o == '%')) {
                        d = o == '*' ? (d *= ((Number)numbers[i + 1].get()).intValue()) : (o == '/' ? (d /= ((Number)numbers[i + 1].get()).intValue()) : (d %= ((Number)numbers[i + 1].get()).intValue()));
                        ++i;
                    }
                    sums[sumIndex++] = d;
                    ++i;
                }
                if (sumIndex < sums.length) {
                    sums[sumIndex] = ((Number)numbers[numbers.length - 1].get()).intValue();
                }
                sumIndex = 1;
                double sum = sums[0];
                int i3 = 0;
                while (i3 < numbers.length - 1) {
                    char o = operations.charAt(i3);
                    if (o == '+') {
                        sum += sums[sumIndex++];
                    } else if (o == '-') {
                        sum -= sums[sumIndex++];
                    }
                    ++i3;
                }
                return RemoteObject.createImmutable((int)sum);
            }
            sums = new long[numberOfSums + 1];
            sumIndex = 0;
            i = 0;
            while (i < numbers.length - 1) {
                char o = operations.charAt(i);
                long d = ((Number)numbers[i].get()).longValue();
                while (i < operations.length() && ((o = operations.charAt(i)) == '*' || o == '/' || o == '%')) {
                    d = o == '*' ? (d *= ((Number)numbers[i + 1].get()).longValue()) : (o == '/' ? (d /= ((Number)numbers[i + 1].get()).longValue()) : (d %= ((Number)numbers[i + 1].get()).longValue()));
                    ++i;
                }
                sums[sumIndex++] = d;
                ++i;
            }
            if (sumIndex < sums.length) {
                sums[sumIndex] = ((Number)numbers[numbers.length - 1].get()).longValue();
            }
            sumIndex = 1;
            double sum = sums[0];
            int i4 = 0;
            while (i4 < numbers.length - 1) {
                char o = operations.charAt(i4);
                if (o == '+') {
                    sum += sums[sumIndex++];
                } else if (o == '-') {
                    sum -= sums[sumIndex++];
                }
                ++i4;
            }
            return RemoteObject.createImmutable((long)sum);
        }
        return BA.rdebugUtils.runMethod(true, "solve", numbers, operations, numberOfSums, calcType);
    }

    public <T> T get() throws Exception {
        if (this == NULL_OBJECT) {
            return null;
        }
        if (this.wrappedValue != null) {
            return (T)this.wrappedValue;
        }
        Object value = RDebug.INSTANCE.getValue(this.slot);
        if (this.immutable) {
            this.wrappedValue = value;
        }
        return (T)value;
    }

    public String toString() {
        throw new RuntimeException("toString not supported");
    }

    private static Method getMethod(String methodName, Object[] params) throws Exception {
        String className = "java.lang.String";
        List<Method> mm = stringMethodsCache.getMethod(className, methodName);
        if (mm.size() == 1) {
            return mm.get(0);
        }
        for (Method m : mm) {
            Class<?>[] mTypes = m.getParameterTypes();
            if (params.length != mTypes.length) continue;
            int i = 0;
            while (i < params.length) {
                if (params[i] != null) {
                    Class<?> p = params[i].getClass();
                    if (mTypes[i].isPrimitive()) {
                        mTypes[i] = MethodCache.primitiveToBoxed.get(mTypes[i]);
                    }
                    if (!mTypes[i].isAssignableFrom(p)) break;
                }
                ++i;
            }
            if (i != params.length) continue;
            return m;
        }
        throw new RuntimeException("Method: " + methodName + " not matched.");
    }

    static class MethodCache {
        public static final HashMap<Class<?>, Class<?>> primitiveToBoxed = new HashMap();
        private HashMap<String, HashMap<String, ArrayList<Method>>> cache = new HashMap();

        static {
            primitiveToBoxed.put(Byte.TYPE, Byte.class);
            primitiveToBoxed.put(Character.TYPE, Character.class);
            primitiveToBoxed.put(Short.TYPE, Short.class);
            primitiveToBoxed.put(Integer.TYPE, Integer.class);
            primitiveToBoxed.put(Long.TYPE, Long.class);
            primitiveToBoxed.put(Float.TYPE, Float.class);
            primitiveToBoxed.put(Double.TYPE, Double.class);
            primitiveToBoxed.put(Boolean.TYPE, Boolean.class);
        }

        MethodCache() {
        }

        public List<Method> getMethod(String className, String methodName) throws Exception {
            Object m;
            HashMap<String, ArrayList<Method>> classMethods = this.cache.get(className);
            if (classMethods == null) {
                classMethods = new HashMap();
                this.cache.put(className, classMethods);
                Method[] methodArray = Class.forName(className).getMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    m = methodArray[n2];
                    ArrayList<Method> overloaded = classMethods.get(((Method)m).getName());
                    if (overloaded == null) {
                        overloaded = new ArrayList();
                        classMethods.put(((Method)m).getName(), overloaded);
                    }
                    overloaded.add((Method)m);
                    ++n2;
                }
            }
            if ((m = classMethods.get(methodName)) == null) {
                throw new RuntimeException("Method: " + methodName + " not found in: " + className);
            }
            return m;
        }
    }

    public static class MyPhantomReference
    extends PhantomReference<RemoteObject> {
        public final int slot;

        public MyPhantomReference(RemoteObject referent, ReferenceQueue<? super RemoteObject> q) {
            super(referent, q);
            this.slot = referent.slot;
        }
    }

    static class SlotAndValue {
        public int slot;
        public RemoteObject value;

        SlotAndValue() {
        }
    }
}

