/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.objects;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.util.Duration;

@BA.ShortName(value="MediaPlayer")
public class MediaPlayerWrapper
extends AbsObjectWrapper<MediaPlayer> {
    public void Initialize(final BA ba, String EventName, String MediaUri) throws URISyntaxException, UnsupportedEncodingException {
        Media m = new Media(MediaUri);
        final MediaPlayer mp = new MediaPlayer(m);
        this.setObject(mp);
        final String eventName = EventName.toLowerCase(BA.cul);
        if (ba.subExists(String.valueOf(eventName) + "_complete")) {
            ((MediaPlayer)this.getObject()).setOnEndOfMedia(new Runnable(){

                @Override
                public void run() {
                    ba.raiseEvent((Object)mp, String.valueOf(eventName) + "_complete", new Object[0]);
                }
            });
        }
        ((MediaPlayer)this.getObject()).setOnError(new Runnable(){

            @Override
            public void run() {
                ((MediaPlayer)MediaPlayerWrapper.this.getObject()).getError().printStackTrace();
            }
        });
    }

    public void Play() {
        ((MediaPlayer)this.getObject()).play();
    }

    public void Pause() {
        ((MediaPlayer)this.getObject()).pause();
    }

    public void Stop() {
        ((MediaPlayer)this.getObject()).stop();
    }

    public double getVolume() {
        return ((MediaPlayer)this.getObject()).getVolume();
    }

    public void setVolume(double d) {
        ((MediaPlayer)this.getObject()).setVolume(d);
    }

    public double getDuration() {
        return ((MediaPlayer)this.getObject()).getTotalDuration().toMillis();
    }

    public double getPosition() {
        return ((MediaPlayer)this.getObject()).getCurrentTime().toMillis();
    }

    public void setPosition(double d) {
        ((MediaPlayer)this.getObject()).seek(Duration.millis((double)d));
    }

    public int getCycleCount() {
        return ((MediaPlayer)this.getObject()).getCycleCount();
    }

    public void setCycleCount(int i) {
        ((MediaPlayer)this.getObject()).setCycleCount(i);
    }
}

