/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.objects;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.ObjectWrapper;
import anywheresoftware.b4a.objects.collections.List;
import anywheresoftware.b4j.objects.ImageViewWrapper;
import anywheresoftware.b4j.objects.JFX;
import anywheresoftware.b4j.objects.LabeledWrapper;
import anywheresoftware.b4j.objects.MenuItemWrapper;
import anywheresoftware.b4j.objects.PaneWrapper;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Labeled;
import javafx.scene.control.Menu;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.web.WebView;
import javafx.util.Duration;

@BA.Hide
public class NodeWrapper<T extends Node>
extends AbsObjectWrapper<T>
implements BA.B4aDebuggable {
    static final int LEFT = 0;
    static final int RIGHT = 1;
    static final int BOTH = 2;
    static final int TOP = 0;
    static final int BOTTOM = 1;
    protected BA ba;
    private static HashMap<String, String> gradientOrientation;
    private static HashMap<String, String> bitmapDrawableOrientations;

    public void Initialize(BA ba, String EventName) {
        this.innerInitialize(ba, EventName.toLowerCase(BA.cul), false);
    }

    @BA.Hide
    public void innerInitialize(final BA ba, final String eventName, boolean keepOldObject) {
        this.ba = ba;
        if (ba == null) {
            throw new RuntimeException("Parent class was not initialized.");
        }
        final Object sender = this.getObject();
        if (ba.subExists(String.valueOf(eventName) + "_mouseclicked")) {
            ((Node)this.getObject()).setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent arg0) {
                    ba.raiseEvent(sender, String.valueOf(eventName) + "_mouseclicked", new Object[]{AbsObjectWrapper.ConvertToWrapper((ObjectWrapper)new MouseEventWrapper(), (Object)arg0)});
                }
            });
        }
        if (ba.subExists(String.valueOf(eventName) + "_mousepressed")) {
            ((Node)this.getObject()).setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent arg0) {
                    ba.raiseEvent(sender, String.valueOf(eventName) + "_mousepressed", new Object[]{AbsObjectWrapper.ConvertToWrapper((ObjectWrapper)new MouseEventWrapper(), (Object)arg0)});
                }
            });
        }
        if (ba.subExists(String.valueOf(eventName) + "_mousereleased")) {
            ((Node)this.getObject()).setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent arg0) {
                    ba.raiseEvent(sender, String.valueOf(eventName) + "_mousereleased", new Object[]{AbsObjectWrapper.ConvertToWrapper((ObjectWrapper)new MouseEventWrapper(), (Object)arg0)});
                }
            });
        }
        if (ba.subExists(String.valueOf(eventName) + "_mousemoved")) {
            ((Node)this.getObject()).setOnMouseMoved((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent arg0) {
                    ba.raiseEvent(sender, String.valueOf(eventName) + "_mousemoved", new Object[]{AbsObjectWrapper.ConvertToWrapper((ObjectWrapper)new MouseEventWrapper(), (Object)arg0)});
                }
            });
        }
        if (ba.subExists(String.valueOf(eventName) + "_mousedragged")) {
            ((Node)this.getObject()).setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent arg0) {
                    ba.raiseEvent(sender, String.valueOf(eventName) + "_mousedragged", new Object[]{AbsObjectWrapper.ConvertToWrapper((ObjectWrapper)new MouseEventWrapper(), (Object)arg0)});
                }
            });
        }
        if (ba.subExists(String.valueOf(eventName) + "_focuschanged")) {
            ((Node)this.getObject()).focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                    ba.raiseEvent(sender, String.valueOf(eventName) + "_focuschanged", new Object[]{(boolean)arg2});
                }
            });
        }
    }

    @BA.Hide
    public Object[] debug(int limit, boolean[] outShouldAddReflectionFields) {
        Object[] res = new Object[]{"ToString", this.toString()};
        outShouldAddReflectionFields[0] = true;
        return res;
    }

    public Cursor getMouseCursor() {
        return ((Node)this.getObject()).getCursor();
    }

    public void setMouseCursor(Cursor c) {
        ((Node)this.getObject()).setCursor(c);
    }

    public boolean getEnabled() {
        return !((Node)this.getObject()).isDisabled();
    }

    public void setEnabled(boolean b) {
        ((Node)this.getObject()).setDisable(!b);
    }

    public double getAlpha() {
        return ((Node)this.getObject()).getOpacity();
    }

    public void setAlpha(double d) {
        ((Node)this.getObject()).setOpacity(d);
    }

    public void SetAlphaAnimated(int Duration2, double Alpha) {
        KeyValue a = new KeyValue((WritableValue)((Node)this.getObject()).opacityProperty(), (Object)Alpha);
        KeyFrame frame = new KeyFrame(Duration.millis((double)Duration2), new KeyValue[]{a});
        Timeline timeline = new Timeline(new KeyFrame[]{frame});
        timeline.play();
    }

    public boolean getVisible() {
        return ((Node)this.getObject()).isVisible();
    }

    public void setVisible(boolean b) {
        ((Node)this.getObject()).setVisible(b);
    }

    public List getStyleClasses() {
        ObservableList ol = ((Node)this.getObject()).getStyleClass();
        List l1 = new List();
        l1.setObject((Object)ol);
        return l1;
    }

    public String getStyle() {
        return ((Node)this.getObject()).getStyle();
    }

    public void setStyle(String s) {
        ((Node)this.getObject()).setStyle(s);
    }

    public Object getTag() {
        Object o = ((Node)this.getObject()).getUserData();
        return o == null ? "" : o;
    }

    public void setTag(Object o) {
        ((Node)this.getObject()).setUserData(o);
    }

    public String getId() {
        return ((Node)this.getObject()).getId() == null ? "" : ((Node)this.getObject()).getId();
    }

    public void setId(String s) {
        ((Node)this.getObject()).setId(s);
    }

    public double getLeft() {
        return ((Node)this.getObject()).getLayoutX() + ((Node)this.getObject()).getLayoutBounds().getMinX();
    }

    public double getTop() {
        return ((Node)this.getObject()).getLayoutY() + ((Node)this.getObject()).getLayoutBounds().getMinY();
    }

    public void setLeft(double d) {
        ((Node)this.getObject()).setLayoutX(d - ((Node)this.getObject()).getLayoutBounds().getMinX());
    }

    public void setTop(double d) {
        ((Node)this.getObject()).setLayoutY(d - ((Node)this.getObject()).getLayoutBounds().getMinY());
    }

    public void RequestFocus() {
        ((Node)this.getObject()).requestFocus();
    }

    public void RemoveNodeFromParent() {
        Parent p = ((Node)this.getObject()).getParent();
        if (p instanceof Pane) {
            ((Pane)p).getChildren().remove(this.getObject());
        }
    }

    public ImageViewWrapper.ImageWrapper Snapshot() {
        return this.Snapshot2(JFX.Colors.White);
    }

    public ImageViewWrapper.ImageWrapper Snapshot2(Paint BackgroundColor) {
        ImageViewWrapper.ImageWrapper iw = new ImageViewWrapper.ImageWrapper();
        SnapshotParameters sp = new SnapshotParameters();
        sp.setFill(BackgroundColor);
        iw.setObject(((Node)this.getObject()).snapshot(sp, null));
        return iw;
    }

    public double getPrefWidth() {
        Node n = (Node)this.getObject();
        if (n instanceof Control) {
            return ((Control)n).getPrefWidth();
        }
        if (n instanceof Region) {
            return ((Region)n).getPrefWidth();
        }
        if (n instanceof ImageView) {
            return ((ImageView)n).getFitWidth();
        }
        if (n instanceof Canvas) {
            return ((Canvas)n).getWidth();
        }
        if (n instanceof WebView) {
            return ((WebView)n).getWidth();
        }
        return -1.0;
    }

    public double getPrefHeight() {
        Node n = (Node)this.getObject();
        if (n instanceof Control) {
            return ((Control)n).getPrefHeight();
        }
        if (n instanceof Region) {
            return ((Region)n).getPrefHeight();
        }
        if (n instanceof ImageView) {
            return ((ImageView)n).getFitHeight();
        }
        if (n instanceof Canvas) {
            return ((Canvas)n).getHeight();
        }
        if (n instanceof WebView) {
            return ((WebView)n).getHeight();
        }
        return -1.0;
    }

    public void setPrefWidth(double d) {
        NodeWrapper.SetSize((Node)this.getObject(), d, null);
    }

    public void setPrefHeight(double d) {
        NodeWrapper.SetSize((Node)this.getObject(), null, d);
    }

    public void SetSize(double Width, double Height) {
        NodeWrapper.SetSize((Node)this.getObject(), Width, Height);
    }

    @BA.Hide
    public static void SetLayout(Node n, double[] layout) {
        n.setLayoutX(layout[0] - n.getLayoutBounds().getMinX());
        n.setLayoutY(layout[1] - n.getLayoutBounds().getMinY());
        NodeWrapper.SetSize(n, layout[2], layout[3]);
    }

    @BA.Hide
    public static void SetSize(Node n, Double Width, Double Height) {
        Node Node2 = n;
        if (Node2 instanceof Control) {
            if (Width != null) {
                ((Control)Node2).setPrefWidth(Width > 0.0 ? Width : -1.0);
            }
            if (Height != null) {
                ((Control)Node2).setPrefHeight(Height > 0.0 ? Height : -1.0);
            }
        } else if (Node2 instanceof Region) {
            if (Width != null) {
                ((Region)Node2).setPrefWidth(Width > 0.0 ? Width : -1.0);
            }
            if (Height != null) {
                ((Region)Node2).setPrefHeight(Height > 0.0 ? Height : -1.0);
            }
        } else if (Node2 instanceof ImageView) {
            if (Width != null) {
                ((ImageView)Node2).setFitWidth(Width.doubleValue());
            }
            if (Height != null) {
                ((ImageView)Node2).setFitHeight(Height.doubleValue());
            }
        } else if (Node2 instanceof Canvas) {
            if (Width != null) {
                ((Canvas)Node2).setWidth(Width.doubleValue());
            }
            if (Height != null) {
                ((Canvas)Node2).setHeight(Height.doubleValue());
            }
        } else if (Node2 instanceof WebView) {
            if (Width != null) {
                ((WebView)Node2).setPrefWidth(Width.doubleValue());
            }
            if (Height != null) {
                ((WebView)Node2).setPrefHeight(Height.doubleValue());
            }
        }
    }

    @BA.Hide
    public static Node build(Object prev, Map<String, Object> props, boolean designer) throws Exception {
        Node v = (Node)prev;
        ConcreteNodeWrapper cnw = new ConcreteNodeWrapper();
        cnw.setObject(v);
        boolean isMain = "Main".equals(props.get("name"));
        if (!isMain) {
            NodeWrapper.buildResize(v, props, 0.0f);
        }
        cnw.setEnabled((Boolean)props.get("enabled"));
        if (!designer) {
            cnw.setVisible((Boolean)props.get("visible"));
            v.setUserData(props.get("tag"));
        }
        StringBuilder sb = new StringBuilder();
        NodeWrapper.buildFont(v, (Map)props.get("font"), sb, designer);
        NodeWrapper.buildDrawable(v, (Map)props.get("drawable"), sb, designer);
        v.setOpacity((double)((Float)props.get("alpha")).floatValue());
        NodeWrapper.appendColorProp(sb, "-fx-border-color", props.get("borderColor"));
        Number radius = (Number)props.get("cornerRadius");
        if (radius != null && radius.floatValue() != 0.0f) {
            NodeWrapper.appendProp(sb, "-fx-border-radius", radius);
            NodeWrapper.appendProp(sb, "-fx-background-radius", radius);
        }
        NodeWrapper.appendProp(sb, "-fx-border-width", props.get("borderWidth"));
        sb.append((String)props.get("extraCss"));
        v.setStyle(sb.toString());
        return v;
    }

    @BA.Hide
    public static void buildResize(Node prev, Map<String, Object> props, float autoscale) {
        int bottom;
        int right;
        int Width = (Integer)props.get("width");
        int Height = (Integer)props.get("height");
        int Left = (Integer)props.get("left");
        int Top = (Integer)props.get("top");
        int pw = (Integer)props.get("pw");
        int ph = (Integer)props.get("ph");
        int duration = (Integer)props.get("duration");
        int hanchor = (Integer)props.get("hanchor");
        int vanchor = (Integer)props.get("vanchor");
        if (hanchor == 1) {
            right = Left;
            Left = pw - right - Width;
        } else if (hanchor == 2) {
            right = Width;
            Width = pw - right - Left;
        }
        if (vanchor == 1) {
            bottom = Top;
            Top = ph - bottom - Height;
        } else if (vanchor == 2) {
            bottom = Height;
            Height = ph - bottom - Top;
        }
        if (prev instanceof Control) {
            ControlWrapper.ConcreteControlWrapper ccw = new ControlWrapper.ConcreteControlWrapper();
            ccw.setObject((Control)prev);
            ccw.SetLayoutAnimated(duration, Left, Top, Width, Height);
        } else if (prev instanceof Pane) {
            PaneWrapper.ConcretePaneWrapper cpw = new PaneWrapper.ConcretePaneWrapper();
            cpw.setObject((Pane)prev);
            cpw.SetLayoutAnimated(duration, Left, Top, Width, Height);
        } else {
            NodeWrapper.SetSize(prev, Double.valueOf(Width), Double.valueOf(Height));
            ConcreteNodeWrapper cnw = new ConcreteNodeWrapper();
            cnw.setObject(prev);
            cnw.setLeft(Left);
            cnw.setTop(Top);
        }
    }

    @BA.Hide
    public static void appendProp(StringBuilder sb, String Key, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Float) {
            value = String.format("%.2f", value);
        }
        sb.append(Key).append(":").append(String.valueOf(value)).append(";");
    }

    @BA.Hide
    public static void appendColorProp(StringBuilder sb, String Key, Object value) {
        if (NodeWrapper.isDefaultColor(value)) {
            return;
        }
        sb.append(Key).append(":");
        NodeWrapper.appendHexString(sb, value);
        sb.append(";\n");
    }

    @BA.Hide
    public static boolean isDefaultColor(Object value) {
        if (value == null) {
            return true;
        }
        byte[] b = (byte[])value;
        return b[0] == -1 && b[1] == -16 && b[2] == -8 && b[3] == -1;
    }

    @BA.Hide
    public static Color ColorFromBytes(Object value) {
        if (NodeWrapper.isDefaultColor(value)) {
            return null;
        }
        byte[] bb = (byte[])value;
        return JFX.Colors.ARGB(bb[0] & 0xFF, bb[1] & 0xFF, bb[2] & 0xFF, bb[3] & 0xFF);
    }

    @BA.Hide
    public static void appendHexString(StringBuilder sb, Object bytes) {
        byte[] bb = (byte[])bytes;
        int alpha = bb[0] & 0xFF;
        if (alpha == 255) {
            sb.append("#");
            int i = 1;
            while (i < bb.length) {
                sb.append(String.format("%02X", bb[i]));
                ++i;
            }
        } else {
            sb.append("rgba(");
            int i = 1;
            while (i < bb.length) {
                sb.append(bb[i] & 0xFF).append(",");
                ++i;
            }
            sb.append(String.format("%.2f", Float.valueOf((float)alpha / 255.0f)));
            sb.append(")");
        }
    }

    @BA.Hide
    public static StringBuilder getStyleAsStringBuilder(Node n) {
        String s = n.getStyle();
        StringBuilder sb = new StringBuilder(s == null ? "" : s);
        return sb;
    }

    @BA.Hide
    private static void buildFont(Node n, Map<String, Object> props, StringBuilder sb, boolean designer) {
        if (props == null) {
            return;
        }
        String font = (String)props.get("fontName");
        if (font.equals("DEFAULT")) {
            font = null;
        }
        float fontSize = ((Float)props.get("fontSize")).floatValue();
        boolean italic = (Boolean)props.get("italic");
        boolean bold = (Boolean)props.get("bold");
        if (n instanceof Labeled) {
            Labeled lbl = (Labeled)n;
            lbl.setFont(Font.font((String)font, (FontWeight)(bold ? FontWeight.BOLD : FontWeight.NORMAL), (FontPosture)(italic ? FontPosture.ITALIC : FontPosture.REGULAR), (double)fontSize));
        } else {
            if (font != null) {
                NodeWrapper.appendProp(sb, "-fx-font-family", font);
            }
            NodeWrapper.appendProp(sb, "-fx-font-size", Float.valueOf(fontSize));
            if (italic) {
                NodeWrapper.appendProp(sb, "-fx-font-style", "italic");
            }
            if (bold) {
                NodeWrapper.appendProp(sb, "-fx-font-weight", "bold");
            }
        }
    }

    private static void buildDrawable(Node n, Map<String, Object> props, StringBuilder sb, boolean designer) {
        if (props == null) {
            return;
        }
        String type = (String)props.get("type");
        if (type.equals("ColorDrawable")) {
            String key = (String)props.get("colorKey");
            NodeWrapper.appendColorProp(sb, key, props.get("color"));
        } else if (type.equals("BitmapDrawable")) {
            String uri = NodeWrapper.getImageUri((String)props.get("file"), designer);
            if (uri == null) {
                return;
            }
            if (n instanceof ImageView) {
                ((ImageView)n).setImage(new Image(uri));
            } else {
                String value = "url(" + uri + ")";
                String gravity = (String)props.get("gravity");
                String size = null;
                String position = "center";
                String repeat = "no-repeat";
                if (gravity.equals("Fill")) {
                    size = "stretch";
                } else {
                    size = "auto";
                    if (gravity.equals("Tile")) {
                        repeat = "repeat";
                        position = "top left";
                    } else {
                        position = gravity.toLowerCase(BA.cul).replace("-", " ");
                    }
                }
                NodeWrapper.appendProp(sb, "-fx-background-size", size);
                NodeWrapper.appendProp(sb, "-fx-background-position", position);
                NodeWrapper.appendProp(sb, "-fx-background-repeat", repeat);
                NodeWrapper.appendProp(sb, "-fx-background-image", value);
            }
        } else if (type.equals("GradientDrawable")) {
            String orientation = (String)props.get("orientation");
            if (gradientOrientation == null) {
                gradientOrientation = new HashMap();
                gradientOrientation.put("TOP_BOTTOM", "from 50% 0% to 50% 100%");
                gradientOrientation.put("TR_BL", "from 100% 0% to 0% 100%");
                gradientOrientation.put("RIGHT_LEFT", "from 100% 50% to 0% 50%");
                gradientOrientation.put("BR_TL", "from 100% 100% to 0% 0%");
                gradientOrientation.put("BOTTOM_TOP", "from 50% 100% to 50% 0%");
                gradientOrientation.put("BL_TR", "from 0% 100% to 100% 0%");
                gradientOrientation.put("LEFT_RIGHT", "from 0% 50% to 100% 50%");
                gradientOrientation.put("TL_BR", "from 0% 0% to 100% 100%");
            }
            StringBuilder lg = new StringBuilder();
            lg.append("linear-gradient(").append(gradientOrientation.get(orientation));
            lg.append(", ");
            NodeWrapper.appendHexString(lg, props.get("firstColor"));
            lg.append(" 0%, ");
            NodeWrapper.appendHexString(lg, props.get("secondColor"));
            lg.append(" 100%)");
            NodeWrapper.appendProp(sb, "-fx-background-color", lg.toString());
        }
    }

    @BA.Hide
    public static String getImageUri(String file, boolean designer) {
        String uri;
        if (file == null || file.length() == 0) {
            return null;
        }
        if (designer) {
            String assetsFolder = System.getProperty("b4j_assets");
            uri = new File(anywheresoftware.b4a.objects.streams.File.Combine((String)assetsFolder, (String)file)).toURI().toString();
        } else {
            uri = anywheresoftware.b4a.objects.streams.File.GetUri((String)anywheresoftware.b4a.objects.streams.File.getDirAssets(), (String)file);
        }
        return uri;
    }

    @BA.Hide
    public static <T> T buildNativeView(Class<T> cls, HashMap<String, Object> props, boolean designer) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Class<Object> c;
        String overideClass = (String)props.get("nativeClass");
        if (overideClass != null && overideClass.startsWith(".")) {
            overideClass = String.valueOf(BA.packageName) + overideClass;
        }
        try {
            c = designer || overideClass == null || overideClass.length() == 0 ? cls : Class.forName(overideClass);
        }
        catch (ClassNotFoundException e) {
            int i = overideClass.lastIndexOf(".");
            c = Class.forName(String.valueOf(overideClass.substring(0, i)) + "$" + overideClass.substring(i + 1));
        }
        return c.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    @BA.Hide
    public static Object getDefault(Node v, String key, Object defaultValue) {
        HashMap map = (HashMap)v.getUserData();
        if (map.containsKey(key)) {
            return map.get(key);
        }
        map.put(key, defaultValue);
        return defaultValue;
    }

    @BA.Hide
    public static class ButtonBaseWrapper<T extends ButtonBase>
    extends LabeledWrapper<T> {
        @Override
        @BA.Hide
        public void innerInitialize(final BA ba, final String eventName, boolean keepOldObject) {
            super.innerInitialize(ba, eventName, keepOldObject);
            if (ba.subExists(String.valueOf(eventName) + "_action")) {
                ((ButtonBase)this.getObject()).setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent arg0) {
                        ba.raiseEventFromUI(ButtonBaseWrapper.this.getObject(), String.valueOf(eventName) + "_action", new Object[0]);
                        arg0.consume();
                    }
                });
            }
        }
    }

    @BA.ShortName(value="Event")
    public static class ConcreteEventWrapper
    extends EventWrapper<Event> {
    }

    @BA.ShortName(value="Node")
    public static class ConcreteNodeWrapper
    extends NodeWrapper<Node> {
    }

    @BA.Hide
    public static class ControlWrapper<T extends Control>
    extends ParentWrapper<T> {
        @Override
        @BA.Hide
        public void innerInitialize(final BA ba, final String eventName, boolean keepOldObject) {
            super.innerInitialize(ba, eventName, keepOldObject);
            final Control control = (Control)this.getObject();
            if (ba.subExists(String.valueOf(eventName) + "_resize")) {
                new PaneWrapper.ResizeEventManager(null, control, new Runnable(){

                    @Override
                    public void run() {
                        ba.raiseEvent(ControlWrapper.this.getObject(), String.valueOf(eventName) + "_resize", new Object[]{control.getWidth(), control.getHeight()});
                    }
                });
            }
        }

        @Override
        public double getPrefHeight() {
            return ((Control)this.getObject()).getPrefHeight();
        }

        @Override
        public void setPrefHeight(double d) {
            ((Control)this.getObject()).setPrefHeight(d);
        }

        @Override
        public double getPrefWidth() {
            return ((Control)this.getObject()).getPrefWidth();
        }

        @Override
        public void setPrefWidth(double d) {
            ((Control)this.getObject()).setPrefWidth(d);
        }

        public double getHeight() {
            return ((Control)this.getObject()).getHeight();
        }

        public double getWidth() {
            return ((Control)this.getObject()).getWidth();
        }

        public void setTooltipText(String s) {
            ((Control)this.getObject()).setTooltip(new Tooltip(s));
        }

        public String getTooltipText() {
            Tooltip tt = ((Control)this.getObject()).getTooltip();
            return tt == null ? "" : tt.getText();
        }

        public void setContextMenu(MenuItemWrapper.ContextMenuWrapper c) {
            ((Control)this.getObject()).setContextMenu((ContextMenu)c.getObject());
        }

        public MenuItemWrapper.ContextMenuWrapper getContextMenu() {
            return (MenuItemWrapper.ContextMenuWrapper)AbsObjectWrapper.ConvertToWrapper((ObjectWrapper)new MenuItemWrapper.ContextMenuWrapper(), (Object)((Control)this.getObject()).getContextMenu());
        }

        public void SetLayoutAnimated(int Duration2, double Left, double Top, double PrefWidth, double PrefHeight) {
            KeyFrame frame;
            if (Duration2 == 0) {
                this.setTop(Top);
                this.setLeft(Left);
                this.setPrefWidth(PrefWidth);
                this.setPrefHeight(PrefHeight);
                return;
            }
            KeyValue left = new KeyValue((WritableValue)((Control)this.getObject()).layoutXProperty(), (Object)(Left - ((Control)this.getObject()).getLayoutBounds().getMinX()));
            KeyValue top = new KeyValue((WritableValue)((Control)this.getObject()).layoutYProperty(), (Object)(Top - ((Control)this.getObject()).getLayoutBounds().getMinY()));
            KeyValue width = new KeyValue((WritableValue)((Control)this.getObject()).prefWidthProperty(), (Object)PrefWidth);
            KeyValue height = new KeyValue((WritableValue)((Control)this.getObject()).prefHeightProperty(), (Object)PrefHeight);
            if (this.getObject() instanceof ProgressBar) {
                frame = new KeyFrame(Duration.millis((double)Duration2), new KeyValue[]{left, top});
                this.setPrefWidth(PrefWidth);
                this.setPrefHeight(PrefHeight);
            } else {
                frame = new KeyFrame(Duration.millis((double)Duration2), new KeyValue[]{left, top, width, height});
            }
            Timeline timeline = new Timeline(new KeyFrame[]{frame});
            timeline.play();
        }

        @BA.Hide
        public static Node build(Object prev, HashMap<String, Object> props, boolean designer) throws Exception {
            ArrayList<Menu> l1;
            Control vg = (Control)prev;
            String tt = (String)props.get("toolTip");
            if (tt.length() > 0) {
                vg.setTooltip(new Tooltip(tt));
            }
            if ((l1 = MenuItemWrapper.MenuBarWrapper.parseMenusJson((BA)props.get("ba"), (String)props.get("contextMenu"), (String)props.get("eventName"))).size() > 0) {
                ContextMenu cm = new ContextMenu();
                cm.getItems().addAll(l1);
                vg.setContextMenu(cm);
            } else {
                vg.setContextMenu(null);
            }
            NodeWrapper.build(vg, props, designer);
            return vg;
        }

        @BA.ShortName(value="Control")
        public static class ConcreteControlWrapper
        extends ControlWrapper<Control> {
        }
    }

    @BA.Hide
    public static class EventWrapper<T extends Event>
    extends AbsObjectWrapper<T> {
        public void Consume() {
            ((Event)this.getObject()).consume();
        }
    }

    @BA.ShortName(value="MouseEvent")
    public static class MouseEventWrapper
    extends EventWrapper<MouseEvent> {
        public int getClickCount() {
            return ((MouseEvent)this.getObject()).getClickCount();
        }

        public double getX() {
            return ((MouseEvent)this.getObject()).getX();
        }

        public double getY() {
            return ((MouseEvent)this.getObject()).getY();
        }

        public boolean getPrimaryButtonDown() {
            return ((MouseEvent)this.getObject()).isPrimaryButtonDown();
        }

        public boolean getMiddleButtonDown() {
            return ((MouseEvent)this.getObject()).isMiddleButtonDown();
        }

        public boolean getSecondaryButtonDown() {
            return ((MouseEvent)this.getObject()).isSecondaryButtonDown();
        }

        public boolean getPrimaryButtonPressed() {
            return ((MouseEvent)this.getObject()).getButton() == MouseButton.PRIMARY;
        }

        public boolean getSecondaryButtonPressed() {
            return ((MouseEvent)this.getObject()).getButton() == MouseButton.SECONDARY;
        }

        public boolean getMiddleButtonPressed() {
            return ((MouseEvent)this.getObject()).getButton() == MouseButton.MIDDLE;
        }
    }

    @BA.Hide
    public static class ParentWrapper<T extends Parent>
    extends NodeWrapper<T> {
    }
}

