/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.objects;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4j.objects.NodeWrapper;
import anywheresoftware.b4j.objects.PaneWrapper;
import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.scene.Node;
import javafx.scene.web.WebView;

@BA.ShortName(value="WebView")
public class WebViewWrapper
extends NodeWrapper<WebView> {
    static {
        PaneWrapper.nativeToWrapper.addFirst(new PaneWrapper.NativeAndWrapper(WebView.class, WebViewWrapper.class));
    }

    @Override
    @BA.Hide
    public void innerInitialize(final BA ba, final String eventName, boolean keepOldObject) {
        if (!keepOldObject) {
            this.setObject(new WebView());
        }
        super.innerInitialize(ba, eventName, true);
        if (ba.subExists(String.valueOf(eventName) + "_locationchanged")) {
            ((WebView)this.getObject()).getEngine().locationProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> arg0, String arg1, String arg2) {
                    ba.raiseEventFromUI(WebViewWrapper.this.getObject(), String.valueOf(eventName) + "_locationchanged", new Object[]{arg2});
                }
            });
        }
        if (ba.subExists(String.valueOf(eventName) + "_pagefinished")) {
            ((WebView)this.getObject()).getEngine().getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

                public void changed(ObservableValue<? extends Worker.State> arg0, Worker.State arg1, Worker.State arg2) {
                    if (arg2 == Worker.State.SUCCEEDED) {
                        ba.raiseEventFromUI(WebViewWrapper.this.getObject(), String.valueOf(eventName) + "_pagefinished", new Object[]{((WebView)WebViewWrapper.this.getObject()).getEngine().getLocation()});
                    }
                }
            });
        }
    }

    public void LoadUrl(String Url) {
        ((WebView)this.getObject()).getEngine().load(Url);
    }

    public void LoadHtml(String HtmlString) {
        ((WebView)this.getObject()).getEngine().loadContent(HtmlString);
    }

    @Override
    public double getPrefHeight() {
        return ((WebView)this.getObject()).getPrefHeight();
    }

    @Override
    public void setPrefHeight(double d) {
        ((WebView)this.getObject()).setPrefHeight(d);
    }

    @Override
    public double getPrefWidth() {
        return ((WebView)this.getObject()).getPrefWidth();
    }

    @Override
    public void setPrefWidth(double d) {
        ((WebView)this.getObject()).setPrefWidth(d);
    }

    public static Node build(Object prev, HashMap<String, Object> props, boolean designer, Object tag) throws Exception {
        WebView vg = (WebView)prev;
        if (vg == null) {
            vg = NodeWrapper.buildNativeView(WebView.class, props, designer);
            if (designer) {
                vg.getEngine().load("http://www.b4x.com");
            }
        }
        return NodeWrapper.build(vg, props, designer);
    }
}

