/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a.net;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.ObjectWrapper;
import anywheresoftware.b4a.objects.streams.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileFilters;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.io.CopyStreamEvent;
import org.apache.commons.net.io.CopyStreamListener;

@BA.ShortName(value="FTP")
@BA.Version(value=1.1f)
public class FTPWrapper
implements BA.CheckForReinitialize {
    FTPClient client;
    private String host;
    private String user;
    private String password;
    private int port;
    private int taskId;
    private volatile int numberOfTasks;
    private ReentrantLock lock = new ReentrantLock(true);
    private boolean passive;
    private String eventName;
    private MyCopyListener downloadProgress;
    private MyCopyListener uploadProgress;
    private boolean useSSL;
    private boolean useExplicitSSL = false;
    private TrustManager[] trustManager;

    public static void LIBRARY_DOC() {
    }

    public void Initialize(BA ba, String EventName, String Host, int Port, String User, String Password) {
        this.client = new FTPClient();
        this.host = Host;
        this.port = Port;
        this.user = User;
        this.password = Password;
        this.eventName = EventName.toLowerCase(BA.cul);
        if (ba.subExists(String.valueOf(this.eventName) + "_downloadprogress")) {
            this.downloadProgress = new MyCopyListener(ba, "_downloadprogress");
        }
        if (ba.subExists(String.valueOf(this.eventName) + "_uploadprogress")) {
            this.uploadProgress = new MyCopyListener(ba, "_uploadprogress");
        }
        this.useSSL = false;
        this.useExplicitSSL = false;
        this.numberOfTasks = 0;
        this.passive = false;
    }

    public void SetCustomSSLTrustManager(Object TrustManager2) {
        this.trustManager = (TrustManager[])TrustManager2;
    }

    public boolean IsInitialized() {
        return this.client != null;
    }

    public void setUseSSLExplicit(boolean b) {
        this.useExplicitSSL = b;
    }

    public boolean getUseSSLExplicit() {
        return this.useExplicitSSL;
    }

    public void setUseSSL(boolean b) {
        this.useSSL = b;
    }

    public boolean getUseSSL() {
        return this.useSSL;
    }

    public void setPassiveMode(boolean b) {
        this.passive = b;
    }

    public boolean getPassiveMode() {
        return this.passive;
    }

    public void DownloadFile(final BA ba, final String ServerFilePath, final boolean AsciiFile, final String DeviceFolder, final String DeviceFile) {
        final int myTask = this.taskId++;
        ++this.numberOfTasks;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FTPWrapper.this.lock.lock();
                try {
                    boolean success = true;
                    try {
                        FTPWrapper.this.connectIfNeeded();
                        FTPWrapper.this.client.setFileType(AsciiFile ? 0 : 2);
                        if (FTPWrapper.this.downloadProgress != null) {
                            ((FTPWrapper)FTPWrapper.this).downloadProgress.serverPath = ServerFilePath;
                            FTPWrapper.this.client.setCopyStreamListener(FTPWrapper.this.downloadProgress);
                        } else {
                            FTPWrapper.this.client.setCopyStreamListener(null);
                        }
                        try (OutputStream out = (OutputStream)File.OpenOutput((String)DeviceFolder, (String)DeviceFile, (boolean)false).getObject();){
                            if (!FTPWrapper.this.client.retrieveFile(ServerFilePath, out)) {
                                throw new RuntimeException("Error retrieving file.\n" + FTPWrapper.this.client.getReplyString());
                            }
                        }
                    }
                    catch (Exception e) {
                        success = false;
                        ba.setLastException(e);
                    }
                    if (FTPWrapper.this.client != null) {
                        ba.raiseEventFromDifferentThread(null, (Object)FTPWrapper.this, myTask, String.valueOf(FTPWrapper.this.eventName) + "_downloadcompleted", false, new Object[]{ServerFilePath, success});
                    }
                }
                finally {
                    FTPWrapper.this.endOfTask();
                }
            }
        };
        BA.submitRunnable((Runnable)runnable, (Object)this, (int)myTask);
    }

    public void UploadFile(final BA ba, final String DeviceFolder, final String DeviceFile, final boolean AsciiFile, final String ServerFilePath) {
        final int myTask = this.taskId++;
        ++this.numberOfTasks;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FTPWrapper.this.lock.lock();
                try {
                    boolean success = true;
                    try {
                        FTPWrapper.this.connectIfNeeded();
                        FTPWrapper.this.client.setFileType(AsciiFile ? 0 : 2);
                        if (FTPWrapper.this.uploadProgress != null) {
                            ((FTPWrapper)FTPWrapper.this).uploadProgress.serverPath = ServerFilePath;
                            FTPWrapper.this.client.setCopyStreamListener(FTPWrapper.this.uploadProgress);
                        } else {
                            FTPWrapper.this.client.setCopyStreamListener(null);
                        }
                        try (InputStream in = (InputStream)File.OpenInput((String)DeviceFolder, (String)DeviceFile).getObject();){
                            if (!FTPWrapper.this.client.storeFile(ServerFilePath, in)) {
                                throw new RuntimeException("Error uploading file.\n" + FTPWrapper.this.client.getReplyString());
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        success = false;
                        ba.setLastException(e);
                    }
                    if (FTPWrapper.this.client != null) {
                        ba.raiseEventFromDifferentThread(null, (Object)FTPWrapper.this, myTask, String.valueOf(FTPWrapper.this.eventName) + "_uploadcompleted", false, new Object[]{ServerFilePath, success});
                    }
                }
                finally {
                    FTPWrapper.this.endOfTask();
                }
            }
        };
        BA.submitRunnable((Runnable)runnable, (Object)this, (int)myTask);
    }

    public void List(final BA ba, final String ServerPath) {
        final int myTask = this.taskId++;
        ++this.numberOfTasks;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FTPWrapper.this.lock.lock();
                try {
                    FTPFileWrapper[] files;
                    FTPFileWrapper[] dirs;
                    boolean success = true;
                    try {
                        FTPWrapper.this.connectIfNeeded();
                        FTPFile[] all = FTPWrapper.this.client.listFiles(ServerPath, FTPFileFilters.NON_NULL);
                        int countFolders = 0;
                        FTPFile[] fTPFileArray = all;
                        int n = all.length;
                        int n2 = 0;
                        while (n2 < n) {
                            FTPFile ff = fTPFileArray[n2];
                            if (ff.isDirectory()) {
                                ++countFolders;
                            }
                            ++n2;
                        }
                        dirs = new FTPFileWrapper[countFolders];
                        files = new FTPFileWrapper[all.length - countFolders];
                        int d1 = 0;
                        int f1 = 0;
                        int i = 0;
                        while (i < all.length) {
                            FTPFileWrapper w = (FTPFileWrapper)AbsObjectWrapper.ConvertToWrapper((ObjectWrapper)new FTPFileWrapper(), (Object)all[i]);
                            if (all[i].isDirectory()) {
                                dirs[d1++] = w;
                            } else {
                                files[f1++] = w;
                            }
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        success = false;
                        ba.setLastException(e);
                        dirs = new FTPFileWrapper[]{};
                        files = new FTPFileWrapper[]{};
                    }
                    if (FTPWrapper.this.client != null) {
                        ba.raiseEventFromDifferentThread(null, (Object)FTPWrapper.this, myTask, String.valueOf(FTPWrapper.this.eventName) + "_listcompleted", false, new Object[]{ServerPath, success, dirs, files});
                    }
                }
                finally {
                    FTPWrapper.this.endOfTask();
                }
            }
        };
        BA.submitRunnable((Runnable)runnable, (Object)this, (int)myTask);
    }

    public void SendCommand(final BA ba, final String Command, final String Parameters) {
        final int myTask = this.taskId++;
        ++this.numberOfTasks;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FTPWrapper.this.lock.lock();
                try {
                    boolean success = true;
                    String replyString = "";
                    int replyInt = 0;
                    try {
                        FTPWrapper.this.connectIfNeeded();
                        success = FTPWrapper.this.client.doCommand(Command, Parameters.length() == 0 ? null : Parameters);
                        replyString = FTPWrapper.this.client.getReplyString();
                        replyInt = FTPWrapper.this.client.getReplyCode();
                        if (!success) {
                            ba.setLastException(null);
                        }
                    }
                    catch (Exception e) {
                        success = false;
                        ba.setLastException(e);
                    }
                    if (FTPWrapper.this.client != null) {
                        ba.raiseEventFromDifferentThread(null, (Object)FTPWrapper.this, myTask, String.valueOf(FTPWrapper.this.eventName) + "_commandcompleted", false, new Object[]{Command, success, replyInt, replyString});
                    }
                }
                finally {
                    FTPWrapper.this.endOfTask();
                }
            }
        };
        BA.submitRunnable((Runnable)runnable, (Object)this, (int)myTask);
    }

    public void DeleteFile(final BA ba, final String ServerPath) {
        final int myTask = this.taskId++;
        ++this.numberOfTasks;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FTPWrapper.this.lock.lock();
                try {
                    boolean success = true;
                    try {
                        FTPWrapper.this.connectIfNeeded();
                        if (!FTPWrapper.this.client.deleteFile(ServerPath)) {
                            throw new RuntimeException("Error deleting file.\n" + FTPWrapper.this.client.getReplyString());
                        }
                    }
                    catch (Exception e) {
                        success = false;
                        ba.setLastException(e);
                    }
                    if (FTPWrapper.this.client != null) {
                        ba.raiseEventFromDifferentThread(null, (Object)FTPWrapper.this, myTask, String.valueOf(FTPWrapper.this.eventName) + "_deletecompleted", false, new Object[]{ServerPath, success});
                    }
                }
                finally {
                    FTPWrapper.this.endOfTask();
                }
            }
        };
        BA.submitRunnable((Runnable)runnable, (Object)this, (int)myTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endOfTask() {
        this.lock.unlock();
        --this.numberOfTasks;
        if (this.client != null && this.numberOfTasks == 0) {
            FTPClient fTPClient = this.client;
            synchronized (fTPClient) {
                this.client.notifyAll();
            }
        }
    }

    public void Close() {
        int myTask = this.taskId++;
        if (this.client == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                FTPClient fTPClient = FTPWrapper.this.client;
                synchronized (fTPClient) {
                    while (true) {
                        if (FTPWrapper.this.numberOfTasks <= 0) {
                            try {
                                FTPWrapper.this.CloseNow();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            break;
                        }
                        try {
                            FTPWrapper.this.client.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    return;
                }
            }
        };
        BA.submitRunnable((Runnable)runnable, (Object)this, (int)myTask);
    }

    public void CloseNow() throws IOException {
        if (this.client == null) {
            return;
        }
        if (this.client.isConnected()) {
            this.client.disconnect();
        }
        this.client = null;
    }

    private void connectIfNeeded() throws SocketException, IOException {
        if (this.client == null) {
            throw new RuntimeException("FTP should first be initialized.");
        }
        if (!this.client.isConnected()) {
            if (this.useSSL && !this.useExplicitSSL) {
                this.client.setSSL();
            }
            this.client.connect(this.host, this.port);
            if (this.passive) {
                this.client.enterLocalPassiveMode();
            } else {
                this.client.enterLocalActiveMode();
            }
            if (this.useExplicitSSL) {
                if (!FTPReply.isPositiveCompletion(this.client.sendCommand("AUTH TLS"))) {
                    throw new RuntimeException("AUTH refused.\n" + this.client.getReplyString());
                }
                this.client.mySslNegotiation(this.trustManager);
                if (!this.client.login(this.user, this.password)) {
                    throw new RuntimeException(this.client.getReplyString());
                }
                if (!FTPReply.isPositiveCompletion(this.client.sendCommand("PBSZ 0"))) {
                    throw new RuntimeException(this.client.getReplyString());
                }
                if (!FTPReply.isPositiveCompletion(this.client.sendCommand("PROT P"))) {
                    throw new RuntimeException(this.client.getReplyString());
                }
            } else {
                if (!FTPReply.isPositiveCompletion(this.client.getReplyCode())) {
                    throw new RuntimeException("Connection refused.\n" + this.client.getReplyString());
                }
                if (!this.client.login(this.user, this.password)) {
                    throw new RuntimeException(this.client.getReplyString());
                }
            }
        }
    }

    @BA.ShortName(value="CustomTrustManager")
    public static class CustomTrustManager
    extends AbsObjectWrapper<TrustManager[]> {
        public void Initialize(String Dir, String FileName) throws Exception {
            Certificate ca;
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            try (InputStream caInput = (InputStream)File.OpenInput((String)Dir, (String)FileName).getObject();){
                ca = cf.generateCertificate(caInput);
                BA.Log((String)("certificate: ca=" + ((X509Certificate)ca).getSubjectDN()));
            }
            String keyStoreType = KeyStore.getDefaultType();
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            keyStore.load(null, null);
            keyStore.setCertificateEntry("ca", ca);
            String tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmfAlgorithm);
            tmf.init(keyStore);
            this.setObject(tmf.getTrustManagers());
        }

        public void InitializeAcceptAll() {
            this.setObject(new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] cert, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] cert, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }});
        }
    }

    @BA.ShortName(value="FTPEntry")
    public static class FTPFileWrapper
    extends AbsObjectWrapper<FTPFile> {
        public String getName() {
            return ((FTPFile)this.getObject()).getName();
        }

        public long getTimestamp() {
            return ((FTPFile)this.getObject()).getTimestamp().getTimeInMillis();
        }

        public long getSize() {
            return ((FTPFile)this.getObject()).getSize();
        }
    }

    private class MyCopyListener
    implements CopyStreamListener {
        String serverPath;
        private final BA ba;
        private final String eventType;

        public MyCopyListener(BA ba, String eventType) {
            this.ba = ba;
            this.eventType = eventType;
        }

        @Override
        public void bytesTransferred(CopyStreamEvent event) {
        }

        @Override
        public void bytesTransferred(long totalBytesTransferred, int bytesTransferred, long streamSize) {
            if (FTPWrapper.this.client == null) {
                throw new RuntimeException("Client is null.");
            }
            this.ba.raiseEventFromDifferentThread((Object)FTPWrapper.this, null, 0, String.valueOf(FTPWrapper.this.eventName) + this.eventType, false, new Object[]{this.serverPath, totalBytesTransferred, streamSize});
        }
    }
}

