/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a.net;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.objects.collections.List;
import anywheresoftware.b4a.objects.streams.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.commons.net.smtp.AuthenticatingSMTPClient;
import org.apache.commons.net.smtp.SMTPReply;
import org.apache.commons.net.smtp.SimpleSMTPHeader;
import org.apache.commons.net.util.Base64;
import org.apache.james.mime4j.codec.EncoderUtil;

@BA.ShortName(value="SMTP")
public class SMTPWrapper {
    private String user;
    private String password;
    private String server;
    private int port;
    private List to;
    private List cc;
    private List bcc;
    private ArrayList<String[]> attachments;
    private String body;
    private String subject;
    private static int taskId;
    private String eventName;
    private boolean html;
    private boolean useSSL;
    private boolean startTLSMode;
    public static final AuthenticatingSMTPClient.AUTH_METHOD AUTH_PLAIN;
    public static final AuthenticatingSMTPClient.AUTH_METHOD AUTH_LOGIN;
    public static final AuthenticatingSMTPClient.AUTH_METHOD AUTH_CRAM_MD5;
    private AuthenticatingSMTPClient.AUTH_METHOD autoMethod = AUTH_PLAIN;
    public String Sender;

    static {
        AUTH_PLAIN = AuthenticatingSMTPClient.AUTH_METHOD.PLAIN;
        AUTH_LOGIN = AuthenticatingSMTPClient.AUTH_METHOD.LOGIN;
        AUTH_CRAM_MD5 = AuthenticatingSMTPClient.AUTH_METHOD.CRAM_MD5;
    }

    public void Initialize(String Server, int Port, String Username, String Password, String EventName) {
        this.user = Username;
        this.password = Password;
        this.server = Server;
        this.port = Port;
        this.eventName = EventName.toLowerCase(BA.cul);
        this.prepareForNewMessage();
        this.html = false;
        this.useSSL = false;
        this.Sender = Username;
    }

    private void prepareForNewMessage() {
        this.to = new List();
        this.to.Initialize();
        this.cc = new List();
        this.cc.Initialize();
        this.bcc = new List();
        this.bcc.Initialize();
        this.attachments = new ArrayList();
        this.body = "";
        this.subject = "";
    }

    public void setTo(List To) {
        this.to = To;
    }

    public List getTo() {
        return this.to;
    }

    public void setCC(List CC) {
        this.cc = CC;
    }

    public List getCC() {
        return this.cc;
    }

    public void setBCC(List BCC) {
        this.bcc = BCC;
    }

    public List getBCC() {
        return this.bcc;
    }

    public void setBody(String text) {
        this.body = text;
    }

    public String getBody() {
        return this.body;
    }

    public void setSubject(String text) {
        this.subject = text;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setHtmlBody(boolean b) {
        this.html = b;
    }

    public boolean getHtmlBody() {
        return this.html;
    }

    public void setUseSSL(boolean b) {
        this.useSSL = b;
    }

    public boolean getUseSSL() {
        return this.useSSL;
    }

    public void setStartTLSMode(boolean b) {
        this.startTLSMode = b;
    }

    public boolean getStartTLSMode() {
        return this.startTLSMode;
    }

    public void setAuthMethod(AuthenticatingSMTPClient.AUTH_METHOD m) {
        this.autoMethod = m;
    }

    public AuthenticatingSMTPClient.AUTH_METHOD getAuthMethod() {
        return this.autoMethod;
    }

    public void AddAttachment(String Dir, String FileName) {
        this.attachments.add(new String[]{Dir, FileName});
    }

    public void Send(final BA ba) {
        if (this.to.getSize() == 0) {
            throw new RuntimeException("To must include at least one recipient.");
        }
        final List myTo = this.to;
        final List myCC = this.cc;
        final List myBCC = this.bcc;
        final ArrayList<String[]> myAttachments = this.attachments;
        final int task = taskId++;
        final String myBody = this.body;
        final String mySubject = this.subject;
        final boolean myHtml = this.html;
        this.prepareForNewMessage();
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SMTPWrapper sMTPWrapper = SMTPWrapper.this;
                synchronized (sMTPWrapper) {
                    AuthenticatingSMTPClient client = null;
                    try {
                        String r;
                        client = new AuthenticatingSMTPClient();
                        if (SMTPWrapper.this.useSSL && !SMTPWrapper.this.startTLSMode) {
                            client.setSSL();
                        }
                        client.setDefaultTimeout(60000);
                        client.connect(SMTPWrapper.this.server, SMTPWrapper.this.port);
                        client.setSoTimeout(60000);
                        int reply = client.getReplyCode();
                        if (!SMTPReply.isPositiveCompletion(reply)) {
                            client.disconnect();
                            throw new IOException("SMTP server refused connection.");
                        }
                        client.ehlo(client.getLocalAddress().getHostAddress());
                        if (SMTPWrapper.this.startTLSMode) {
                            client.execTLS();
                        }
                        client.auth(SMTPWrapper.this.autoMethod, SMTPWrapper.this.user, SMTPWrapper.this.password);
                        client.setSender(SMTPWrapper.this.user);
                        String sub = EncoderUtil.hasToBeEncoded(mySubject, 0) ? EncoderUtil.encodeEncodedWord(mySubject, EncoderUtil.Usage.TEXT_TOKEN, 0, Charset.forName("UTF8"), EncoderUtil.Encoding.Q) : mySubject;
                        String encodedSender = SMTPWrapper.this.Sender;
                        SimpleSMTPHeader header = new SimpleSMTPHeader(encodedSender, sub);
                        if (myAttachments.size() == 0) {
                            header.addHeaderField("Content-Type", "text/" + (myHtml ? "html" : "plain") + "; charset=\"utf-8\"");
                            header.addHeaderField("Content-Transfer-Encoding", "quoted-printable");
                        }
                        String bound = "asdasdwdwqd__HV_qwdqwdddwq";
                        if (myAttachments.size() > 0) {
                            header.addHeaderField("Content-Type", "multipart/mixed; boundary=\"" + bound + "\"");
                        }
                        int i = 0;
                        while (i < myTo.getSize()) {
                            r = myTo.Get(i).toString();
                            client.addRecipient(r);
                            header.addTo(r);
                            ++i;
                        }
                        i = 0;
                        while (i < myCC.getSize()) {
                            r = myCC.Get(i).toString();
                            client.addRecipient(r);
                            header.addCC(r);
                            ++i;
                        }
                        i = 0;
                        while (i < myBCC.getSize()) {
                            r = myBCC.Get(i).toString();
                            client.addRecipient(r);
                            header.addBCC(r);
                            ++i;
                        }
                        Writer w = client.sendMessageData();
                        if (w == null) {
                            throw new RuntimeException("Empty writer returned: " + client.getReplyString());
                        }
                        w.append(header.toString());
                        if (myAttachments.size() == 0) {
                            w.append(myBody);
                        } else {
                            w.append("--" + bound + "\r\n");
                            w.append("Content-Type: text/$TEXT$; charset=\"utf-8\"\r\n\r\n".replace("$TEXT$", myHtml ? "html" : "plain"));
                            header.addHeaderField("Content-Transfer-Encoding", "quoted-printable");
                            w.append(myBody);
                            for (String[] s : myAttachments) {
                                w.append("\r\n").append("--").append(bound).append("\r\n");
                                w.append("Content-Type: application/octet-stream\r\n");
                                w.append("Content-Transfer-Encoding: base64\r\n");
                                w.append("Content-Disposition: attachment; filename=\"" + s[1] + "\"\r\n\r\n");
                                File.InputStreamWrapper in = File.OpenInput((String)s[0], (String)s[1]);
                                File.OutputStreamWrapper out = new File.OutputStreamWrapper();
                                out.InitializeToBytesArray(100);
                                File.Copy2((InputStream)((InputStream)in.getObject()), (OutputStream)((OutputStream)out.getObject()));
                                w.append(Base64.encodeBase64String(out.ToBytesArray()));
                                w.append("\r\n");
                            }
                        }
                        w.close();
                        if (!client.completePendingCommand()) {
                            throw new RuntimeException("Error sending message: " + client.getReplyString());
                        }
                        client.quit();
                        client.disconnect();
                        ba.raiseEventFromDifferentThread(null, (Object)SMTPWrapper.this, task, String.valueOf(SMTPWrapper.this.eventName) + "_messagesent", false, new Object[]{true});
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ba.setLastException(e);
                        if (client != null && client.isConnected()) {
                            try {
                                client.disconnect();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        ba.raiseEventFromDifferentThread(null, (Object)SMTPWrapper.this, task, String.valueOf(SMTPWrapper.this.eventName) + "_messagesent", false, new Object[]{false});
                    }
                }
            }
        };
        BA.submitRunnable((Runnable)r, (Object)this, (int)task);
    }
}

