/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp;

import anywheresoftware.b4a.BA;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.util.Base64;

@BA.Hide
public class FTPHTTPClient
extends FTPClient {
    private final String proxyHost;
    private final int proxyPort;
    private final String proxyUsername;
    private final String proxyPassword;
    private String host;
    private int port;
    private final byte[] CRLF;
    private final Base64 base64 = new Base64();

    public FTPHTTPClient(String proxyHost, int proxyPort, String proxyUser, String proxyPass) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUsername = proxyUser;
        this.proxyPassword = proxyPass;
        try {
            this.CRLF = "\r\n".getBytes(this.getControlEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public FTPHTTPClient(String proxyHost, int proxyPort) {
        this(proxyHost, proxyPort, null, null);
    }

    @Override
    protected Socket _openDataConnection_(int command, String arg) throws IOException {
        Socket socket = new Socket(this.host, this.port);
        InputStream is = socket.getInputStream();
        OutputStream os = socket.getOutputStream();
        this.tunnelHandshake(this.host, this.port, is, os);
        return socket;
    }

    @Override
    public void connect(String host, int port) throws SocketException, IOException {
        this.host = host;
        this.port = port;
        this._socket_ = new Socket(this.proxyHost, this.proxyPort);
        this._input_ = this._socket_.getInputStream();
        this._output_ = this._socket_.getOutputStream();
        try {
            this.tunnelHandshake(host, port, this._input_, this._output_);
        }
        catch (Exception e) {
            IOException ioe = new IOException("Could not connect to " + host);
            ioe.initCause(e);
            throw ioe;
        }
    }

    private void tunnelHandshake(String host, int port, InputStream input, OutputStream output) throws IOException, UnsupportedEncodingException {
        String connectString = "CONNECT " + host + ":" + port + " HTTP/1.1";
        this._output_.write(connectString.getBytes(this.getControlEncoding()));
        this._output_.write(this.CRLF);
        if (this.proxyUsername != null && this.proxyPassword != null) {
            String header = "Proxy-Authorization: Basic " + this.base64.encode(String.valueOf(this.proxyUsername) + ":" + this.proxyPassword) + "\r\n";
            this._output_.write(header.getBytes("UTF-8"));
            this._output_.write(this.CRLF);
            ArrayList<String> response = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(new InputStreamReader(this._input_));
            String line = reader.readLine();
            while (line != null && line.length() > 0) {
                response.add(line);
                line = reader.readLine();
            }
            int size = response.size();
            if (size == 0) {
                throw new IOException("No response from proxy");
            }
            String code = null;
            String resp = (String)response.get(0);
            if (!resp.startsWith("HTTP/") || resp.length() < 12) {
                throw new IOException("Invalid response from proxy: " + resp);
            }
            code = resp.substring(9, 12);
            if (!"200".equals(code)) {
                StringBuilder msg = new StringBuilder();
                msg.append("HTTPTunnelConnector: connection failed\r\n");
                msg.append("Response received from the proxy:\r\n");
                for (String line2 : response) {
                    msg.append(line2);
                    msg.append("\r\n");
                }
                throw new IOException(msg.toString());
            }
        }
    }
}

