/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import org.eclipse.jetty.util.ArrayTrie;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Trie;

public enum HttpScheme {
    HTTP("http"),
    HTTPS("https"),
    WS("ws"),
    WSS("wss");

    public static final Trie<HttpScheme> CACHE;
    private final String _string;
    private final ByteBuffer _buffer;

    static {
        CACHE = new ArrayTrie<HttpScheme>();
        HttpScheme[] httpSchemeArray = HttpScheme.values();
        int n = httpSchemeArray.length;
        int n2 = 0;
        while (n2 < n) {
            HttpScheme version = httpSchemeArray[n2];
            CACHE.put(version.asString(), version);
            ++n2;
        }
    }

    private HttpScheme(String s) {
        this._string = s;
        this._buffer = BufferUtil.toBuffer(s);
    }

    public ByteBuffer asByteBuffer() {
        return this._buffer.asReadOnlyBuffer();
    }

    public boolean is(String s) {
        return this._string.equalsIgnoreCase(s);
    }

    public String asString() {
        return this._string;
    }

    public String toString() {
        return this._string;
    }
}

