/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.StringUtil;

public class HttpTester {
    private HttpTester() {
    }

    public static Request newRequest() {
        return new Request();
    }

    public static Request parseRequest(String request) {
        Request r = new Request();
        HttpParser parser = new HttpParser(r);
        parser.parseNext(BufferUtil.toBuffer(request));
        return r;
    }

    public static Request parseRequest(ByteBuffer request) {
        Request r = new Request();
        HttpParser parser = new HttpParser(r);
        parser.parseNext(request);
        return r;
    }

    public static Response parseResponse(String response) {
        Response r = new Response();
        HttpParser parser = new HttpParser(r);
        parser.parseNext(BufferUtil.toBuffer(response));
        return r;
    }

    public static Response parseResponse(ByteBuffer response) {
        Response r = new Response();
        HttpParser parser = new HttpParser(r);
        parser.parseNext(response);
        return r;
    }

    public static abstract class Message
    extends HttpFields
    implements HttpParser.HttpHandler<ByteBuffer> {
        ByteArrayOutputStream _content;
        HttpVersion _version = HttpVersion.HTTP_1_0;

        public HttpVersion getVersion() {
            return this._version;
        }

        public void setVersion(String version) {
            this.setVersion(HttpVersion.CACHE.get(version));
        }

        public void setVersion(HttpVersion version) {
            this._version = version;
        }

        public void setContent(byte[] bytes) {
            try {
                this._content = new ByteArrayOutputStream();
                this._content.write(bytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void setContent(String content) {
            try {
                this._content = new ByteArrayOutputStream();
                this._content.write(StringUtil.getBytes(content));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void setContent(ByteBuffer content) {
            try {
                this._content = new ByteArrayOutputStream();
                this._content.write(BufferUtil.toArray(content));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean parsedHeader(HttpField field) {
            this.put(field.getName(), field.getValue());
            return false;
        }

        @Override
        public boolean messageComplete() {
            return true;
        }

        @Override
        public boolean headerComplete() {
            this._content = new ByteArrayOutputStream();
            return false;
        }

        @Override
        public void earlyEOF() {
        }

        @Override
        public boolean content(ByteBuffer ref) {
            try {
                this._content.write(BufferUtil.toArray(ref));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return false;
        }

        @Override
        public void badMessage(int status, String reason) {
            throw new RuntimeException(reason);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ByteBuffer generate() {
            try {
                HttpGenerator generator = new HttpGenerator();
                HttpGenerator.Info info = this.getInfo();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ByteBuffer header = null;
                ByteBuffer chunk = null;
                ByteBuffer content = this._content == null ? null : ByteBuffer.wrap(this._content.toByteArray());
                while (!generator.isEnd()) {
                    HttpGenerator.Result result = info instanceof HttpGenerator.RequestInfo ? generator.generateRequest((HttpGenerator.RequestInfo)info, header, chunk, content, true) : generator.generateResponse((HttpGenerator.ResponseInfo)info, header, chunk, content, true);
                    switch (result) {
                        case NEED_HEADER: {
                            header = BufferUtil.allocate(8192);
                            break;
                        }
                        case NEED_CHUNK: {
                            chunk = BufferUtil.allocate(12);
                            break;
                        }
                        case NEED_INFO: {
                            throw new IllegalStateException();
                        }
                        case FLUSH: {
                            if (BufferUtil.hasContent(header)) {
                                out.write(BufferUtil.toArray(header));
                                BufferUtil.clear(header);
                            }
                            if (BufferUtil.hasContent(chunk)) {
                                out.write(BufferUtil.toArray(chunk));
                                BufferUtil.clear(chunk);
                            }
                            if (!BufferUtil.hasContent(content)) break;
                            out.write(BufferUtil.toArray(content));
                            BufferUtil.clear(content);
                            break;
                        }
                        case SHUTDOWN_OUT: {
                            return ByteBuffer.wrap(out.toByteArray());
                        }
                    }
                }
                return ByteBuffer.wrap(out.toByteArray());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public abstract HttpGenerator.Info getInfo();

        @Override
        public int getHeaderCacheSize() {
            return 0;
        }
    }

    public static class Request
    extends Message
    implements HttpParser.RequestHandler<ByteBuffer> {
        private String _method;
        private String _uri;

        @Override
        public boolean startRequest(HttpMethod method, String methodString, ByteBuffer uri, HttpVersion version) {
            this._method = methodString;
            this._uri = BufferUtil.toUTF8String(uri);
            this._version = version;
            return false;
        }

        public String getMethod() {
            return this._method;
        }

        public String getUri() {
            return this._uri;
        }

        public void setMethod(String method) {
            this._method = method;
        }

        public void setURI(String uri) {
            this._uri = uri;
        }

        @Override
        public HttpGenerator.RequestInfo getInfo() {
            return new HttpGenerator.RequestInfo(this._version, this, this._content == null ? 0 : this._content.size(), this._method, this._uri);
        }

        @Override
        public String toString() {
            return String.format("%s %s %s\n%s\n", new Object[]{this._method, this._uri, this._version, super.toString()});
        }

        public void setHeader(String name, String value) {
            this.put(name, value);
        }

        @Override
        public boolean parsedHostHeader(String host, int port) {
            return false;
        }
    }

    public static class Response
    extends Message
    implements HttpParser.ResponseHandler<ByteBuffer> {
        private int _status;
        private String _reason;

        @Override
        public boolean startResponse(HttpVersion version, int status, String reason) {
            this._version = version;
            this._status = status;
            this._reason = reason;
            return false;
        }

        public int getStatus() {
            return this._status;
        }

        public String getReason() {
            return this._reason;
        }

        public byte[] getContentBytes() {
            if (this._content == null) {
                return null;
            }
            return this._content.toByteArray();
        }

        public String getContent() {
            if (this._content == null) {
                return null;
            }
            byte[] bytes = this._content.toByteArray();
            String content_type = this.get(HttpHeader.CONTENT_TYPE);
            String encoding = MimeTypes.getCharsetFromContentType(content_type);
            Charset charset = encoding == null ? StandardCharsets.UTF_8 : Charset.forName(encoding);
            return new String(bytes, charset);
        }

        @Override
        public HttpGenerator.ResponseInfo getInfo() {
            return new HttpGenerator.ResponseInfo(this._version, this, this._content == null ? -1 : this._content.size(), this._status, this._reason, false);
        }

        @Override
        public String toString() {
            return String.format("%s %s %s\n%s\n", new Object[]{this._version, this._status, this._reason, super.toString()});
        }
    }
}

