/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.ArrayTrie;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.Trie;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class MimeTypes {
    private static final Logger LOG = Log.getLogger(MimeTypes.class);
    public static final Trie<Type> CACHE = new ArrayTrie<Type>(512);
    private static final Trie<ByteBuffer> TYPES = new ArrayTrie<ByteBuffer>(512);
    private static final Map<String, String> __dftMimeMap = new HashMap<String, String>();
    private static final Map<String, String> __encodings = new HashMap<String, String>();
    private final Map<String, String> _mimeMap = new HashMap<String, String>();

    static {
        Type[] typeArray = Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            CACHE.put(type.toString(), type);
            TYPES.put(type.toString(), type.asBuffer());
            int charset = type.toString().indexOf(";charset=");
            if (charset > 0) {
                CACHE.put(type.toString().replace(";charset=", "; charset="), type);
                TYPES.put(type.toString().replace(";charset=", "; charset="), type.asBuffer());
            }
            ++n2;
        }
        try {
            ResourceBundle mime = ResourceBundle.getBundle("org/eclipse/jetty/http/mime");
            Enumeration<String> i = mime.getKeys();
            while (i.hasMoreElements()) {
                String ext = i.nextElement();
                String m = mime.getString(ext);
                __dftMimeMap.put(StringUtil.asciiToLowerCase(ext), MimeTypes.normalizeMimeType(m));
            }
        }
        catch (MissingResourceException e) {
            LOG.warn(e.toString(), new Object[0]);
            LOG.debug(e);
        }
        try {
            ResourceBundle encoding = ResourceBundle.getBundle("org/eclipse/jetty/http/encoding");
            Enumeration<String> i = encoding.getKeys();
            while (i.hasMoreElements()) {
                String type = i.nextElement();
                __encodings.put(type, encoding.getString(type));
            }
        }
        catch (MissingResourceException e) {
            LOG.warn(e.toString(), new Object[0]);
            LOG.debug(e);
        }
    }

    public synchronized Map<String, String> getMimeMap() {
        return this._mimeMap;
    }

    public void setMimeMap(Map<String, String> mimeMap) {
        this._mimeMap.clear();
        if (mimeMap != null) {
            for (Map.Entry<String, String> ext : mimeMap.entrySet()) {
                this._mimeMap.put(StringUtil.asciiToLowerCase(ext.getKey()), MimeTypes.normalizeMimeType(ext.getValue()));
            }
        }
    }

    public String getMimeByExtension(String filename) {
        String type = null;
        if (filename != null) {
            int i = -1;
            while (type == null) {
                if ((i = filename.indexOf(".", i + 1)) < 0 || i >= filename.length()) break;
                String ext = StringUtil.asciiToLowerCase(filename.substring(i + 1));
                if (this._mimeMap != null) {
                    type = this._mimeMap.get(ext);
                }
                if (type != null) continue;
                type = __dftMimeMap.get(ext);
            }
        }
        if (type == null) {
            if (this._mimeMap != null) {
                type = this._mimeMap.get("*");
            }
            if (type == null) {
                type = __dftMimeMap.get("*");
            }
        }
        return type;
    }

    public void addMimeMapping(String extension, String type) {
        this._mimeMap.put(StringUtil.asciiToLowerCase(extension), MimeTypes.normalizeMimeType(type));
    }

    public static Set<String> getKnownMimeTypes() {
        return new HashSet<String>(__dftMimeMap.values());
    }

    private static String normalizeMimeType(String type) {
        Type t = CACHE.get(type);
        if (t != null) {
            return t.asString();
        }
        return StringUtil.asciiToLowerCase(type);
    }

    public static String getCharsetFromContentType(String value) {
        if (value == null) {
            return null;
        }
        int end = value.length();
        int state = 0;
        int start = 0;
        boolean quote = false;
        int i = 0;
        while (i < end) {
            char b = value.charAt(i);
            if (quote && state != 10) {
                if ('\"' == b) {
                    quote = false;
                }
            } else {
                switch (state) {
                    case 0: {
                        if ('\"' == b) {
                            quote = true;
                            break;
                        }
                        if (';' != b) break;
                        state = 1;
                        break;
                    }
                    case 1: {
                        if ('c' == b) {
                            state = 2;
                            break;
                        }
                        if (' ' == b) break;
                        state = 0;
                        break;
                    }
                    case 2: {
                        if ('h' == b) {
                            state = 3;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 3: {
                        if ('a' == b) {
                            state = 4;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 4: {
                        if ('r' == b) {
                            state = 5;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 5: {
                        if ('s' == b) {
                            state = 6;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 6: {
                        if ('e' == b) {
                            state = 7;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 7: {
                        if ('t' == b) {
                            state = 8;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 8: {
                        if ('=' == b) {
                            state = 9;
                            break;
                        }
                        if (' ' == b) break;
                        state = 0;
                        break;
                    }
                    case 9: {
                        if (' ' == b) break;
                        if ('\"' == b) {
                            quote = true;
                            start = i + 1;
                            state = 10;
                            break;
                        }
                        start = i;
                        state = 10;
                        break;
                    }
                    case 10: {
                        if ((quote || ';' != b && ' ' != b) && (!quote || '\"' != b)) break;
                        return StringUtil.normalizeCharset(value, start, i - start);
                    }
                }
            }
            ++i;
        }
        if (state == 10) {
            return StringUtil.normalizeCharset(value, start, i - start);
        }
        return null;
    }

    public static String inferCharsetFromContentType(String value) {
        return __encodings.get(value);
    }

    public static String getContentTypeWithoutCharset(String value) {
        int end = value.length();
        int state = 0;
        int start = 0;
        boolean quote = false;
        int i = 0;
        StringBuilder builder = null;
        while (i < end) {
            char b = value.charAt(i);
            if ('\"' == b) {
                quote = !quote;
                switch (state) {
                    case 11: {
                        builder.append(b);
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 9: {
                        builder = new StringBuilder();
                        builder.append(value, 0, start + 1);
                        state = 10;
                        break;
                    }
                    default: {
                        start = i;
                        state = 0;
                        break;
                    }
                }
            } else if (quote) {
                if (builder != null && state != 10) {
                    builder.append(b);
                }
            } else {
                switch (state) {
                    case 0: {
                        if (';' == b) {
                            state = 1;
                            break;
                        }
                        if (' ' == b) break;
                        start = i;
                        break;
                    }
                    case 1: {
                        if ('c' == b) {
                            state = 2;
                            break;
                        }
                        if (' ' == b) break;
                        state = 0;
                        break;
                    }
                    case 2: {
                        if ('h' == b) {
                            state = 3;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 3: {
                        if ('a' == b) {
                            state = 4;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 4: {
                        if ('r' == b) {
                            state = 5;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 5: {
                        if ('s' == b) {
                            state = 6;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 6: {
                        if ('e' == b) {
                            state = 7;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 7: {
                        if ('t' == b) {
                            state = 8;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 8: {
                        if ('=' == b) {
                            state = 9;
                            break;
                        }
                        if (' ' == b) break;
                        state = 0;
                        break;
                    }
                    case 9: {
                        if (' ' == b) break;
                        builder = new StringBuilder();
                        builder.append(value, 0, start + 1);
                        state = 10;
                        break;
                    }
                    case 10: {
                        if (';' != b) break;
                        builder.append(b);
                        state = 11;
                        break;
                    }
                    case 11: {
                        if (' ' == b) break;
                        builder.append(b);
                    }
                }
            }
            ++i;
        }
        if (builder == null) {
            return value;
        }
        return builder.toString();
    }

    public static enum Type {
        FORM_ENCODED("application/x-www-form-urlencoded"),
        MESSAGE_HTTP("message/http"),
        MULTIPART_BYTERANGES("multipart/byteranges"),
        TEXT_HTML("text/html"),
        TEXT_PLAIN("text/plain"),
        TEXT_XML("text/xml"),
        TEXT_JSON("text/json", StandardCharsets.UTF_8),
        APPLICATION_JSON("application/json", StandardCharsets.UTF_8),
        TEXT_HTML_8859_1("text/html; charset=ISO-8859-1", TEXT_HTML),
        TEXT_HTML_UTF_8("text/html; charset=UTF-8", TEXT_HTML),
        TEXT_PLAIN_8859_1("text/plain; charset=ISO-8859-1", TEXT_PLAIN),
        TEXT_PLAIN_UTF_8("text/plain; charset=UTF-8", TEXT_PLAIN),
        TEXT_XML_8859_1("text/xml; charset=ISO-8859-1", TEXT_XML),
        TEXT_XML_UTF_8("text/xml; charset=UTF-8", TEXT_XML),
        TEXT_JSON_8859_1("text/json; charset=ISO-8859-1", TEXT_JSON),
        TEXT_JSON_UTF_8("text/json; charset=UTF-8", TEXT_JSON),
        APPLICATION_JSON_8859_1("text/json; charset=ISO-8859-1", APPLICATION_JSON),
        APPLICATION_JSON_UTF_8("text/json; charset=UTF-8", APPLICATION_JSON);

        private final String _string;
        private final Type _base;
        private final ByteBuffer _buffer;
        private final Charset _charset;
        private final boolean _assumedCharset;
        private final HttpField _field;

        private Type(String s) {
            this._string = s;
            this._buffer = BufferUtil.toBuffer(s);
            this._base = this;
            this._charset = null;
            this._assumedCharset = false;
            this._field = new HttpGenerator.CachedHttpField(HttpHeader.CONTENT_TYPE, this._string);
        }

        private Type(String s, Type base) {
            this._string = s;
            this._buffer = BufferUtil.toBuffer(s);
            this._base = base;
            int i = s.indexOf("; charset=");
            this._charset = Charset.forName(s.substring(i + 10));
            this._assumedCharset = false;
            this._field = new HttpGenerator.CachedHttpField(HttpHeader.CONTENT_TYPE, this._string);
        }

        private Type(String s, Charset cs) {
            this._string = s;
            this._base = this;
            this._buffer = BufferUtil.toBuffer(s);
            this._charset = cs;
            this._assumedCharset = true;
            this._field = new HttpGenerator.CachedHttpField(HttpHeader.CONTENT_TYPE, this._string);
        }

        public ByteBuffer asBuffer() {
            return this._buffer.asReadOnlyBuffer();
        }

        public Charset getCharset() {
            return this._charset;
        }

        public boolean is(String s) {
            return this._string.equalsIgnoreCase(s);
        }

        public String asString() {
            return this._string;
        }

        public String toString() {
            return this._string;
        }

        public boolean isCharsetAssumed() {
            return this._assumedCharset;
        }

        public HttpField getContentTypeField() {
            return this._field;
        }

        public Type getBaseType() {
            return this._base;
        }
    }
}

