/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.Closeable;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.ConcurrentArrayQueue;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.NonBlockingThread;
import org.eclipse.jetty.util.thread.Scheduler;

public abstract class SelectorManager
extends AbstractLifeCycle
implements Dumpable {
    public static final String SUBMIT_KEY_UPDATES = "org.eclipse.jetty.io.SelectorManager.submitKeyUpdates";
    public static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    protected static final Logger LOG = Log.getLogger(SelectorManager.class);
    private static final boolean __submitKeyUpdates = Boolean.valueOf(System.getProperty("org.eclipse.jetty.io.SelectorManager.submitKeyUpdates", "false"));
    private final Executor executor;
    private final Scheduler scheduler;
    private final ManagedSelector[] _selectors;
    private long _connectTimeout = 15000L;
    private long _selectorIndex;

    protected SelectorManager(Executor executor, Scheduler scheduler) {
        this(executor, scheduler, (Runtime.getRuntime().availableProcessors() + 1) / 2);
    }

    protected SelectorManager(Executor executor, Scheduler scheduler, int selectors) {
        if (selectors <= 0) {
            throw new IllegalArgumentException("No selectors");
        }
        this.executor = executor;
        this.scheduler = scheduler;
        this._selectors = new ManagedSelector[selectors];
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public long getConnectTimeout() {
        return this._connectTimeout;
    }

    public void setConnectTimeout(long milliseconds) {
        this._connectTimeout = milliseconds;
    }

    protected void execute(Runnable task) {
        this.executor.execute(task);
    }

    public int getSelectorCount() {
        return this._selectors.length;
    }

    private ManagedSelector chooseSelector() {
        long s = this._selectorIndex++;
        int index = (int)(s % (long)this.getSelectorCount());
        return this._selectors[index];
    }

    public void connect(SocketChannel channel, Object attachment) {
        ManagedSelector set;
        ManagedSelector managedSelector = set = this.chooseSelector();
        managedSelector.getClass();
        set.submit(managedSelector.new ManagedSelector.Connect(channel, attachment));
    }

    public void accept(SocketChannel channel) {
        ManagedSelector selector;
        ManagedSelector managedSelector = selector = this.chooseSelector();
        managedSelector.getClass();
        selector.submit(managedSelector.new ManagedSelector.Accept(channel));
    }

    public void acceptor(ServerSocketChannel server) {
        ManagedSelector selector;
        ManagedSelector managedSelector = selector = this.chooseSelector();
        managedSelector.getClass();
        selector.submit(managedSelector.new ManagedSelector.Acceptor(server));
    }

    protected void accepted(SocketChannel channel) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        int i = 0;
        while (i < this._selectors.length) {
            ManagedSelector selector;
            this._selectors[i] = selector = this.newSelector(i);
            selector.start();
            this.execute(new NonBlockingThread(selector));
            ++i;
        }
    }

    protected ManagedSelector newSelector(int id) {
        return new ManagedSelector(id);
    }

    @Override
    protected void doStop() throws Exception {
        ManagedSelector[] managedSelectorArray = this._selectors;
        int n = this._selectors.length;
        int n2 = 0;
        while (n2 < n) {
            ManagedSelector selector = managedSelectorArray[n2];
            selector.stop();
            ++n2;
        }
        super.doStop();
    }

    protected void endPointOpened(EndPoint endpoint) {
        endpoint.onOpen();
    }

    protected void endPointClosed(EndPoint endpoint) {
        endpoint.onClose();
    }

    public void connectionOpened(Connection connection) {
        try {
            connection.onOpen();
        }
        catch (Throwable x) {
            if (this.isRunning()) {
                LOG.warn("Exception while notifying connection " + connection, x);
            }
            LOG.debug("Exception while notifying connection {}", connection, x);
        }
    }

    public void connectionClosed(Connection connection) {
        try {
            connection.onClose();
        }
        catch (Throwable x) {
            LOG.debug("Exception while notifying connection " + connection, x);
        }
    }

    protected boolean finishConnect(SocketChannel channel) throws IOException {
        return channel.finishConnect();
    }

    protected void connectionFailed(SocketChannel channel, Throwable ex, Object attachment) {
        LOG.warn(String.format("%s - %s", channel, attachment), ex);
    }

    protected abstract EndPoint newEndPoint(SocketChannel var1, ManagedSelector var2, SelectionKey var3) throws IOException;

    public abstract Connection newConnection(SocketChannel var1, EndPoint var2, Object var3) throws IOException;

    @Override
    public String dump() {
        return ContainerLifeCycle.dump(this);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        ContainerLifeCycle.dumpObject(out, this);
        ContainerLifeCycle.dump(out, indent, TypeUtil.asList(this._selectors));
    }

    public class ManagedSelector
    extends AbstractLifeCycle
    implements Runnable,
    Dumpable {
        private final AtomicReference<State> _state = new AtomicReference<State>(State.PROCESS);
        private final Queue<Runnable> _changes = new ConcurrentArrayQueue<Runnable>();
        private final int _id;
        private Selector _selector;
        private volatile Thread _thread;

        public ManagedSelector(int id) {
            this._id = id;
            this.setStopTimeout(5000L);
        }

        @Override
        protected void doStart() throws Exception {
            super.doStart();
            this._selector = Selector.open();
            this._state.set(State.PROCESS);
        }

        @Override
        protected void doStop() throws Exception {
            LOG.debug("Stopping {}", this);
            Stop stop = new Stop();
            this.submit(stop);
            stop.await(this.getStopTimeout());
            LOG.debug("Stopped {}", this);
        }

        public void updateKey(Runnable update) {
            if (__submitKeyUpdates) {
                this.submit(update);
            } else {
                this.runChange(update);
                if (this._state.compareAndSet(State.SELECT, State.WAKEUP)) {
                    this.wakeup();
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void submit(Runnable change) {
            this._changes.offer(change);
            LOG.debug("Queued change {}", change);
            block7: while (true) {
                switch (this._state.get()) {
                    case SELECT: {
                        if (!this._state.compareAndSet(State.SELECT, State.WAKEUP)) continue block7;
                        this.wakeup();
                        return;
                    }
                    case CHANGES: {
                        if (this._state.compareAndSet(State.CHANGES, State.MORE_CHANGES)) return;
                        continue block7;
                    }
                    case WAKEUP: {
                        return;
                    }
                    case MORE_CHANGES: {
                        return;
                    }
                    case PROCESS: {
                        return;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                break;
            }
        }

        private void runChanges() {
            Runnable change;
            while ((change = this._changes.poll()) != null) {
                this.runChange(change);
            }
        }

        protected void runChange(Runnable change) {
            try {
                LOG.debug("Running change {}", change);
                change.run();
            }
            catch (Throwable x) {
                LOG.debug("Could not run change " + change, x);
            }
        }

        @Override
        public void run() {
            this._thread = Thread.currentThread();
            String name = this._thread.getName();
            try {
                this._thread.setName(String.valueOf(name) + "-selector-" + SelectorManager.this.getClass().getSimpleName() + "@" + Integer.toHexString(SelectorManager.this.hashCode()) + "/" + this._id);
                LOG.debug("Starting {} on {}", this._thread, this);
                while (this.isRunning()) {
                    this.select();
                }
                this.runChanges();
            }
            catch (Throwable throwable) {
                LOG.debug("Stopped {} on {}", this._thread, this);
                this._thread.setName(name);
                throw throwable;
            }
            LOG.debug("Stopped {} on {}", this._thread, this);
            this._thread.setName(name);
        }

        public void select() {
            boolean debug = LOG.isDebugEnabled();
            try {
                this._state.set(State.CHANGES);
                block6: while (true) {
                    switch (this._state.get()) {
                        case CHANGES: {
                            this.runChanges();
                            if (!this._state.compareAndSet(State.CHANGES, State.SELECT)) continue block6;
                            break block6;
                        }
                        case MORE_CHANGES: {
                            this.runChanges();
                            this._state.set(State.CHANGES);
                            continue block6;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    break;
                }
                assert (this._state.get() == State.SELECT || this._state.get() == State.WAKEUP);
                if (debug) {
                    LOG.debug("Selector loop waiting on select", new Object[0]);
                }
                int selected = this._selector.select();
                if (debug) {
                    LOG.debug("Selector loop woken up from select, {}/{} selected", selected, this._selector.keys().size());
                }
                this._state.set(State.PROCESS);
                Set<SelectionKey> selectedKeys = this._selector.selectedKeys();
                for (SelectionKey key : selectedKeys) {
                    Object attachment;
                    if (key.isValid()) {
                        this.processKey(key);
                        continue;
                    }
                    if (debug) {
                        LOG.debug("Selector loop ignoring invalid key for channel {}", key.channel());
                    }
                    if (!((attachment = key.attachment()) instanceof EndPoint)) continue;
                    ((EndPoint)attachment).close();
                }
                selectedKeys.clear();
            }
            catch (Throwable x) {
                if (this.isRunning()) {
                    LOG.warn(x);
                }
                LOG.ignore(x);
            }
        }

        private void processKey(SelectionKey key) {
            block7: {
                Object attachment = key.attachment();
                try {
                    if (attachment instanceof SelectableEndPoint) {
                        ((SelectableEndPoint)attachment).onSelected();
                        break block7;
                    }
                    if (key.isConnectable()) {
                        this.processConnect(key, (Connect)attachment);
                        break block7;
                    }
                    if (key.isAcceptable()) {
                        this.processAccept(key);
                        break block7;
                    }
                    throw new IllegalStateException();
                }
                catch (CancelledKeyException x) {
                    LOG.debug("Ignoring cancelled key for channel {}", key.channel());
                    if (attachment instanceof EndPoint) {
                        this.closeNoExceptions((EndPoint)attachment);
                    }
                }
                catch (Throwable x) {
                    LOG.warn("Could not process key for channel " + key.channel(), x);
                    if (!(attachment instanceof EndPoint)) break block7;
                    this.closeNoExceptions((EndPoint)attachment);
                }
            }
        }

        private void processConnect(SelectionKey key, Connect connect) {
            SocketChannel channel = (SocketChannel)key.channel();
            try {
                key.attach(connect.attachment);
                boolean connected = SelectorManager.this.finishConnect(channel);
                if (!connected) {
                    throw new ConnectException();
                }
                connect.timeout.cancel();
                key.interestOps(0);
                EndPoint endpoint = this.createEndPoint(channel, key);
                key.attach(endpoint);
            }
            catch (Throwable x) {
                connect.failed(x);
            }
        }

        private void processAccept(SelectionKey key) {
            ServerSocketChannel server = (ServerSocketChannel)key.channel();
            SocketChannel channel = null;
            try {
                while ((channel = server.accept()) != null) {
                    SelectorManager.this.accepted(channel);
                }
            }
            catch (Throwable x) {
                this.closeNoExceptions(channel);
                LOG.warn("Accept failed for channel " + channel, x);
            }
        }

        private void closeNoExceptions(Closeable closeable) {
            try {
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable x) {
                LOG.ignore(x);
            }
        }

        public void wakeup() {
            this._selector.wakeup();
        }

        public boolean isSelectorThread() {
            return Thread.currentThread() == this._thread;
        }

        private EndPoint createEndPoint(SocketChannel channel, SelectionKey selectionKey) throws IOException {
            EndPoint endPoint = SelectorManager.this.newEndPoint(channel, this, selectionKey);
            SelectorManager.this.endPointOpened(endPoint);
            Connection connection = SelectorManager.this.newConnection(channel, endPoint, selectionKey.attachment());
            endPoint.setConnection(connection);
            SelectorManager.this.connectionOpened(connection);
            LOG.debug("Created {}", endPoint);
            return endPoint;
        }

        public void destroyEndPoint(EndPoint endPoint) {
            LOG.debug("Destroyed {}", endPoint);
            Connection connection = endPoint.getConnection();
            if (connection != null) {
                SelectorManager.this.connectionClosed(connection);
            }
            SelectorManager.this.endPointClosed(endPoint);
        }

        @Override
        public String dump() {
            return ContainerLifeCycle.dump(this);
        }

        @Override
        public void dump(Appendable out, String indent) throws IOException {
            Selector selector;
            StackTraceElement[] trace;
            out.append(String.valueOf(this)).append(" id=").append(String.valueOf(this._id)).append("\n");
            Thread selecting = this._thread;
            Object where = "not selecting";
            StackTraceElement[] stackTraceElementArray = trace = selecting == null ? null : selecting.getStackTrace();
            if (trace != null) {
                StackTraceElement[] stackTraceElementArray2 = trace;
                int n = trace.length;
                int n2 = 0;
                while (n2 < n) {
                    StackTraceElement t = stackTraceElementArray2[n2];
                    if (t.getClassName().startsWith("org.eclipse.jetty.")) {
                        where = t;
                        break;
                    }
                    ++n2;
                }
            }
            if ((selector = this._selector) != null && selector.isOpen()) {
                ArrayList<String> dump = new ArrayList<String>(selector.keys().size() * 2);
                dump.add((String)where);
                DumpKeys dumpKeys = new DumpKeys(dump);
                this.submit(dumpKeys);
                dumpKeys.await(5L, TimeUnit.SECONDS);
                ContainerLifeCycle.dump(out, indent, dump);
            }
        }

        public void dumpKeysState(List<Object> dumps) {
            Selector selector = this._selector;
            Set<SelectionKey> keys = selector.keys();
            dumps.add(selector + " keys=" + keys.size());
            for (SelectionKey key : keys) {
                if (key.isValid()) {
                    dumps.add(key.attachment() + " iOps=" + key.interestOps() + " rOps=" + key.readyOps());
                    continue;
                }
                dumps.add(key.attachment() + " iOps=-1 rOps=-1");
            }
        }

        public String toString() {
            Selector selector = this._selector;
            return String.format("%s keys=%d selected=%d", super.toString(), selector != null && selector.isOpen() ? selector.keys().size() : -1, selector != null && selector.isOpen() ? selector.selectedKeys().size() : -1);
        }

        private class Accept
        implements Runnable {
            private final SocketChannel _channel;

            public Accept(SocketChannel channel) {
                this._channel = channel;
            }

            @Override
            public void run() {
                try {
                    SelectionKey key = this._channel.register(ManagedSelector.this._selector, 0, null);
                    EndPoint endpoint = ManagedSelector.this.createEndPoint(this._channel, key);
                    key.attach(endpoint);
                }
                catch (Throwable x) {
                    ManagedSelector.this.closeNoExceptions(this._channel);
                    LOG.debug(x);
                }
            }
        }

        private class Acceptor
        implements Runnable {
            private final ServerSocketChannel _channel;

            public Acceptor(ServerSocketChannel channel) {
                this._channel = channel;
            }

            @Override
            public void run() {
                try {
                    SelectionKey key = this._channel.register(ManagedSelector.this._selector, 16, null);
                    LOG.debug("{} acceptor={}", this, key);
                }
                catch (Throwable x) {
                    ManagedSelector.this.closeNoExceptions(this._channel);
                    LOG.warn(x);
                }
            }
        }

        private class Connect
        implements Runnable {
            private final AtomicBoolean failed = new AtomicBoolean();
            private final SocketChannel channel;
            private final Object attachment;
            private final Scheduler.Task timeout;

            public Connect(SocketChannel channel, Object attachment) {
                this.channel = channel;
                this.attachment = attachment;
                this.timeout = SelectorManager.this.scheduler.schedule(new ConnectTimeout(this), SelectorManager.this.getConnectTimeout(), TimeUnit.MILLISECONDS);
            }

            @Override
            public void run() {
                try {
                    this.channel.register(ManagedSelector.this._selector, 8, this);
                }
                catch (Throwable x) {
                    this.failed(x);
                }
            }

            protected void failed(Throwable failure) {
                if (this.failed.compareAndSet(false, true)) {
                    this.timeout.cancel();
                    ManagedSelector.this.closeNoExceptions(this.channel);
                    SelectorManager.this.connectionFailed(this.channel, failure, this.attachment);
                }
            }
        }

        private class ConnectTimeout
        implements Runnable {
            private final Connect connect;

            private ConnectTimeout(Connect connect) {
                this.connect = connect;
            }

            @Override
            public void run() {
                SocketChannel channel = this.connect.channel;
                if (channel.isConnectionPending()) {
                    LOG.debug("Channel {} timed out while connecting, closing it", channel);
                    this.connect.failed(new SocketTimeoutException());
                }
            }
        }

        private class DumpKeys
        implements Runnable {
            private final CountDownLatch latch = new CountDownLatch(1);
            private final List<Object> _dumps;

            private DumpKeys(List<Object> dumps) {
                this._dumps = dumps;
            }

            @Override
            public void run() {
                ManagedSelector.this.dumpKeysState(this._dumps);
                this.latch.countDown();
            }

            public boolean await(long timeout, TimeUnit unit) {
                try {
                    return this.latch.await(timeout, unit);
                }
                catch (InterruptedException x) {
                    return false;
                }
            }
        }

        private class EndPointCloser
        implements Runnable {
            private final CountDownLatch latch = new CountDownLatch(1);
            private final EndPoint endPoint;

            private EndPointCloser(EndPoint endPoint) {
                this.endPoint = endPoint;
            }

            @Override
            public void run() {
                try {
                    ManagedSelector.this.closeNoExceptions(this.endPoint.getConnection());
                }
                finally {
                    this.latch.countDown();
                }
            }

            private boolean await(long timeout) {
                try {
                    return this.latch.await(timeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException x) {
                    return false;
                }
            }
        }

        private class Stop
        implements Runnable {
            private final CountDownLatch latch = new CountDownLatch(1);

            private Stop() {
            }

            @Override
            public void run() {
                try {
                    for (SelectionKey key : ManagedSelector.this._selector.keys()) {
                        Object attachment = key.attachment();
                        if (!(attachment instanceof EndPoint)) continue;
                        EndPointCloser closer = new EndPointCloser((EndPoint)attachment);
                        SelectorManager.this.execute(closer);
                        closer.await(ManagedSelector.this.getStopTimeout());
                    }
                    ManagedSelector.this.closeNoExceptions(ManagedSelector.this._selector);
                }
                finally {
                    this.latch.countDown();
                }
            }

            public boolean await(long timeout) {
                try {
                    return this.latch.await(timeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException x) {
                    return false;
                }
            }
        }
    }

    public static interface SelectableEndPoint
    extends EndPoint {
        public void onSelected();
    }

    private static enum State {
        CHANGES,
        MORE_CHANGES,
        SELECT,
        WAKEUP,
        PROCESS;

    }
}

