/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jaas.spi;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.eclipse.jetty.jaas.spi.AbstractLoginModule;
import org.eclipse.jetty.jaas.spi.UserInfo;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.security.Credential;

public abstract class AbstractDatabaseLoginModule
extends AbstractLoginModule {
    private static final Logger LOG = Log.getLogger(AbstractDatabaseLoginModule.class);
    private String userQuery;
    private String rolesQuery;
    private String dbUserTable;
    private String dbUserTableUserField;
    private String dbUserTableCredentialField;
    private String dbUserRoleTable;
    private String dbUserRoleTableUserField;
    private String dbUserRoleTableRoleField;

    public abstract Connection getConnection() throws Exception;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public UserInfo getUserInfo(String userName) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            Connection connection = this.getConnection();
            try {
                Throwable throwable2;
                String dbCredential = null;
                Throwable throwable3 = null;
                Throwable throwable4 = null;
                try (PreparedStatement statement = connection.prepareStatement(this.userQuery);){
                    statement.setString(1, userName);
                    Throwable throwable5 = null;
                    throwable2 = null;
                    try (ResultSet results = statement.executeQuery();){
                        if (results.next()) {
                            dbCredential = results.getString(1);
                        }
                    }
                    catch (Throwable throwable6) {
                        if (throwable5 == null) {
                            throwable5 = throwable6;
                            throw throwable5;
                        }
                        if (throwable5 == throwable6) throw throwable5;
                        throwable5.addSuppressed(throwable6);
                        throw throwable5;
                    }
                }
                catch (Throwable throwable7) {
                    if (throwable3 == null) {
                        throwable3 = throwable7;
                        throw throwable3;
                    }
                    if (throwable3 == throwable7) throw throwable3;
                    throwable3.addSuppressed(throwable7);
                    throw throwable3;
                }
                if (dbCredential == null) {
                    return null;
                }
                ArrayList<String> roles = new ArrayList<String>();
                throwable4 = null;
                Object var8_13 = null;
                try (PreparedStatement statement = connection.prepareStatement(this.rolesQuery);){
                    statement.setString(1, userName);
                    throwable2 = null;
                    Object var11_20 = null;
                    try (ResultSet results = statement.executeQuery();){
                        while (results.next()) {
                            String roleName = results.getString(1);
                            roles.add(roleName);
                        }
                    }
                    catch (Throwable throwable8) {
                        if (throwable2 == null) {
                            throwable2 = throwable8;
                            throw throwable2;
                        }
                        if (throwable2 == throwable8) throw throwable2;
                        throwable2.addSuppressed(throwable8);
                        throw throwable2;
                    }
                }
                catch (Throwable throwable9) {
                    if (throwable4 == null) {
                        throwable4 = throwable9;
                        throw throwable4;
                    }
                    if (throwable4 == throwable9) throw throwable4;
                    throwable4.addSuppressed(throwable9);
                    throw throwable4;
                }
                return new UserInfo(userName, Credential.getCredential(dbCredential), roles);
            }
            catch (Throwable throwable10) {
                throw throwable10;
            }
            finally {
                if (connection == null) return null;
                connection.close();
            }
        }
        catch (Throwable throwable11) {
            if (throwable == null) {
                throwable = throwable11;
                throw throwable;
            }
            if (throwable == throwable11) throw throwable;
            throwable.addSuppressed(throwable11);
            throw throwable;
        }
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.dbUserTable = (String)options.get("userTable");
        this.dbUserTableUserField = (String)options.get("userField");
        this.dbUserTableCredentialField = (String)options.get("credentialField");
        this.userQuery = "select " + this.dbUserTableCredentialField + " from " + this.dbUserTable + " where " + this.dbUserTableUserField + "=?";
        this.dbUserRoleTable = (String)options.get("userRoleTable");
        this.dbUserRoleTableUserField = (String)options.get("userRoleUserField");
        this.dbUserRoleTableRoleField = (String)options.get("userRoleRoleField");
        this.rolesQuery = "select " + this.dbUserRoleTableRoleField + " from " + this.dbUserRoleTable + " where " + this.dbUserRoleTableUserField + "=?";
        if (LOG.isDebugEnabled()) {
            LOG.debug("userQuery = " + this.userQuery, new Object[0]);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("rolesQuery = " + this.rolesQuery, new Object[0]);
        }
    }
}

