/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jmx;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBean;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ObjectMBean
implements DynamicMBean {
    private static final Logger LOG = Log.getLogger(ObjectMBean.class);
    private static Class<?>[] OBJ_ARG = new Class[]{Object.class};
    protected Object _managed;
    private MBeanInfo _info;
    private Map<String, Method> _getters = new HashMap<String, Method>();
    private Map<String, Method> _setters = new HashMap<String, Method>();
    private Map<String, Method> _methods = new HashMap<String, Method>();
    private Set<String> _attributes = new HashSet<String>();
    private Set<String> _convert = new HashSet<String>();
    private ClassLoader _loader;
    private MBeanContainer _mbeanContainer;
    private static String OBJECT_NAME_CLASS = ObjectName.class.getName();
    private static String OBJECT_NAME_ARRAY_CLASS = ObjectName[].class.getName();

    public static Object mbeanFor(Object o) {
        try {
            Class<Object> oClass = o.getClass();
            Object mbean = null;
            while (mbean == null && oClass != null) {
                String pName = oClass.getPackage().getName();
                String cName = oClass.getName().substring(pName.length() + 1);
                String mName = String.valueOf(pName) + ".jmx." + cName + "MBean";
                try {
                    block11: {
                        Class<Object> mClass = Object.class.equals(oClass) ? (oClass = ObjectMBean.class) : Loader.loadClass(oClass, mName);
                        LOG.debug("ObjectMbean: mbeanFor {} mClass={}", o, mClass);
                        try {
                            Constructor constructor = mClass.getConstructor(OBJ_ARG);
                            mbean = constructor.newInstance(o);
                        }
                        catch (Exception e) {
                            LOG.ignore(e);
                            if (!ModelMBean.class.isAssignableFrom(mClass)) break block11;
                            mbean = mClass.newInstance();
                            ((ModelMBean)mbean).setManagedResource(o, "objectReference");
                        }
                    }
                    LOG.debug("mbeanFor {} is {}", o, mbean);
                    return mbean;
                }
                catch (ClassNotFoundException e) {
                    if (e.getMessage().contains(mName)) {
                        LOG.ignore(e);
                    } else {
                        LOG.warn(e);
                    }
                }
                catch (Error e) {
                    LOG.warn(e);
                    mbean = null;
                }
                catch (Exception e) {
                    LOG.warn(e);
                    mbean = null;
                }
                oClass = oClass.getSuperclass();
            }
        }
        catch (Exception e) {
            LOG.ignore(e);
        }
        return null;
    }

    public ObjectMBean(Object managedObject) {
        this._managed = managedObject;
        this._loader = Thread.currentThread().getContextClassLoader();
    }

    public Object getManagedObject() {
        return this._managed;
    }

    public ObjectName getObjectName() {
        return null;
    }

    public String getObjectContextBasis() {
        return null;
    }

    public String getObjectNameBasis() {
        return null;
    }

    protected void setMBeanContainer(MBeanContainer container) {
        this._mbeanContainer = container;
    }

    public MBeanContainer getMBeanContainer() {
        return this._mbeanContainer;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        try {
            if (this._info == null) {
                String desc = null;
                ArrayList<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>();
                ArrayList constructors = new ArrayList();
                ArrayList<MBeanOperationInfo> operations = new ArrayList<MBeanOperationInfo>();
                ArrayList notifications = new ArrayList();
                Class<?> o_class = this._managed.getClass();
                List<Class<?>> influences = ObjectMBean.findInfluences(new ArrayList(), this._managed.getClass());
                LOG.debug("Influence Count: {}", influences.size());
                ManagedObject primary = o_class.getAnnotation(ManagedObject.class);
                if (primary != null) {
                    desc = primary.value();
                } else {
                    LOG.debug("No @ManagedObject declared on {}", this._managed.getClass());
                }
                int i = 0;
                while (i < influences.size()) {
                    Class<?> oClass = influences.get(i);
                    ManagedObject typeAnnotation = oClass.getAnnotation(ManagedObject.class);
                    LOG.debug("Influenced by: " + oClass.getCanonicalName(), new Object[0]);
                    if (typeAnnotation == null) {
                        LOG.debug("Annotations not found for: {}", oClass.getCanonicalName());
                    } else {
                        Method[] methodArray = oClass.getDeclaredMethods();
                        int n = methodArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ManagedOperation methodOperationAnnotation;
                            Method method = methodArray[n2];
                            ManagedAttribute methodAttributeAnnotation = method.getAnnotation(ManagedAttribute.class);
                            if (methodAttributeAnnotation != null) {
                                LOG.debug("Attribute Annotation found for: {}", method.getName());
                                MBeanAttributeInfo mai = this.defineAttribute(method, methodAttributeAnnotation);
                                if (mai != null) {
                                    attributes.add(mai);
                                }
                            }
                            if ((methodOperationAnnotation = method.getAnnotation(ManagedOperation.class)) != null) {
                                LOG.debug("Method Annotation found for: {}", method.getName());
                                MBeanOperationInfo oi = this.defineOperation(method, methodOperationAnnotation);
                                if (oi != null) {
                                    operations.add(oi);
                                }
                            }
                            ++n2;
                        }
                    }
                    ++i;
                }
                this._info = new MBeanInfo(o_class.getName(), desc, attributes.toArray(new MBeanAttributeInfo[attributes.size()]), constructors.toArray(new MBeanConstructorInfo[constructors.size()]), operations.toArray(new MBeanOperationInfo[operations.size()]), notifications.toArray(new MBeanNotificationInfo[notifications.size()]));
            }
        }
        catch (RuntimeException e) {
            LOG.warn(e);
            throw e;
        }
        return this._info;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Method getter = this._getters.get(name);
        if (getter == null) {
            throw new AttributeNotFoundException(name);
        }
        try {
            ObjectName[] r;
            Object o = this._managed;
            if (getter.getDeclaringClass().isInstance(this)) {
                o = this;
            }
            if ((r = getter.invoke(o, null)) != null) {
                if (r.getClass().isArray()) {
                    if (r.getClass().getComponentType().isAnnotationPresent(ManagedObject.class)) {
                        ObjectName[] on = new ObjectName[Array.getLength(r)];
                        int i = 0;
                        while (i < on.length) {
                            on[i] = this._mbeanContainer.findMBean(Array.get(r, i));
                            ++i;
                        }
                        r = on;
                    }
                } else if (r instanceof Collection) {
                    Collection c = (Collection)r;
                    if (!c.isEmpty() && c.iterator().next().getClass().isAnnotationPresent(ManagedObject.class)) {
                        ObjectName[] on = new ObjectName[c.size()];
                        int i = 0;
                        for (Object obj : c) {
                            on[i++] = this._mbeanContainer.findMBean(obj);
                        }
                        r = on;
                    }
                } else {
                    Class<?> clazz = r.getClass();
                    while (clazz != null) {
                        if (clazz.isAnnotationPresent(ManagedObject.class)) {
                            ObjectName mbean = this._mbeanContainer.findMBean(r);
                            if (mbean != null) {
                                return mbean;
                            }
                            return null;
                        }
                        clazz = clazz.getSuperclass();
                    }
                }
            }
            return r;
        }
        catch (IllegalAccessException e) {
            LOG.warn("EXCEPTION ", e);
            throw new AttributeNotFoundException(e.toString());
        }
        catch (InvocationTargetException e) {
            LOG.warn("EXCEPTION ", e);
            throw new ReflectionException(new Exception(e.getCause()));
        }
    }

    @Override
    public AttributeList getAttributes(String[] names) {
        AttributeList results = new AttributeList(names.length);
        int i = 0;
        while (i < names.length) {
            try {
                results.add(new Attribute(names[i], this.getAttribute(names[i])));
            }
            catch (Exception e) {
                LOG.warn("EXCEPTION ", e);
            }
            ++i;
        }
        return results;
    }

    @Override
    public void setAttribute(Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Method setter;
        if (attr == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("setAttribute " + this._managed + ":" + attr.getName() + "=" + attr.getValue(), new Object[0]);
        }
        if ((setter = this._setters.get(attr.getName())) == null) {
            throw new AttributeNotFoundException(attr.getName());
        }
        try {
            Object value;
            Object o = this._managed;
            if (setter.getDeclaringClass().isInstance(this)) {
                o = this;
            }
            if ((value = attr.getValue()) != null && this._convert.contains(attr.getName())) {
                if (value.getClass().isArray()) {
                    Class<?> t = setter.getParameterTypes()[0].getComponentType();
                    Object na = Array.newInstance(t, Array.getLength(value));
                    int i = Array.getLength(value);
                    while (i-- > 0) {
                        Array.set(na, i, this._mbeanContainer.findBean((ObjectName)Array.get(value, i)));
                    }
                    value = na;
                } else {
                    value = this._mbeanContainer.findBean((ObjectName)value);
                }
            }
            setter.invoke(o, value);
        }
        catch (IllegalAccessException e) {
            LOG.warn("EXCEPTION ", e);
            throw new AttributeNotFoundException(e.toString());
        }
        catch (InvocationTargetException e) {
            LOG.warn("EXCEPTION ", e);
            throw new ReflectionException(new Exception(e.getCause()));
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList attrs) {
        LOG.debug("setAttributes", new Object[0]);
        AttributeList results = new AttributeList(attrs.size());
        Iterator iter = attrs.iterator();
        while (iter.hasNext()) {
            try {
                Attribute attr = (Attribute)iter.next();
                this.setAttribute(attr);
                results.add(new Attribute(attr.getName(), this.getAttribute(attr.getName())));
            }
            catch (Exception e) {
                LOG.warn("EXCEPTION ", e);
            }
        }
        return results;
    }

    @Override
    public Object invoke(String name, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        LOG.debug("ObjectMBean:invoke " + name, new Object[0]);
        String methodKey = String.valueOf(name) + "(";
        if (signature != null) {
            int i = 0;
            while (i < signature.length) {
                methodKey = String.valueOf(methodKey) + (i > 0 ? "," : "") + signature[i];
                ++i;
            }
        }
        methodKey = String.valueOf(methodKey) + ")";
        ClassLoader old_loader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this._loader);
            Method method = this._methods.get(methodKey);
            if (method == null) {
                throw new NoSuchMethodException(methodKey);
            }
            Object o = this._managed;
            if (method.getDeclaringClass().isInstance(this)) {
                o = this;
            }
            Object object = method.invoke(o, params);
            return object;
        }
        catch (NoSuchMethodException e) {
            LOG.warn("EXCEPTION ", e);
            throw new ReflectionException(e);
        }
        catch (IllegalAccessException e) {
            LOG.warn("EXCEPTION ", e);
            throw new MBeanException(e);
        }
        catch (InvocationTargetException e) {
            LOG.warn("EXCEPTION ", e);
            throw new ReflectionException(new Exception(e.getCause()));
        }
        finally {
            Thread.currentThread().setContextClassLoader(old_loader);
        }
    }

    private static List<Class<?>> findInfluences(List<Class<?>> influences, Class<?> aClass) {
        if (aClass != null) {
            influences.add(aClass);
            String pName = aClass.getPackage().getName();
            String cName = aClass.getName().substring(pName.length() + 1);
            String mName = String.valueOf(pName) + ".jmx." + cName + "MBean";
            try {
                Class<?> mbeanClazz = Class.forName(mName);
                LOG.debug("MBean Influence found for " + aClass.getSimpleName(), new Object[0]);
                influences.add(mbeanClazz);
            }
            catch (ClassNotFoundException cnfe) {
                LOG.debug("No MBean Influence for " + aClass.getSimpleName(), new Object[0]);
            }
            influences = ObjectMBean.findInfluences(influences, aClass.getSuperclass());
            Class<?>[] ifs = aClass.getInterfaces();
            int i = 0;
            while (ifs != null && i < ifs.length) {
                influences = ObjectMBean.findInfluences(influences, ifs[i]);
                ++i;
            }
        }
        return influences;
    }

    /*
     * Unable to fully structure code
     */
    public MBeanAttributeInfo defineAttribute(Method method, ManagedAttribute attributeAnnotation) {
        block19: {
            name = attributeAnnotation.name();
            if ("".equals(name)) {
                name = this.toVariableName(method.getName());
            }
            if (this._attributes.contains(name)) {
                return null;
            }
            description = attributeAnnotation.value();
            readonly = attributeAnnotation.readonly();
            onMBean = attributeAnnotation.proxied();
            convert = false;
            component_type = return_type = method.getReturnType();
            while (component_type.isArray()) {
                component_type = component_type.getComponentType();
            }
            convert = this.isAnnotationPresent(component_type, ManagedObject.class);
            uName = String.valueOf(name.substring(0, 1).toUpperCase(Locale.ENGLISH)) + name.substring(1);
            oClass = onMBean != false ? this.getClass() : this._managed.getClass();
            ObjectMBean.LOG.debug("defineAttribute {} {}:{}:{}:{}", new Object[]{name, onMBean, readonly, oClass, description});
            setter = null;
            if (readonly) break block19;
            declaredSetter = attributeAnnotation.setter();
            ObjectMBean.LOG.debug("DeclaredSetter: {}", new Object[]{declaredSetter});
            methods = oClass.getMethods();
            m = 0;
            while (m < methods.length) {
                block20: {
                    if ((methods[m].getModifiers() & 1) == 0) break block20;
                    if ("".equals(declaredSetter) || !methods[m].getName().equals(declaredSetter) || methods[m].getParameterTypes().length != 1) ** GOTO lbl35
                    if (setter != null) {
                        ObjectMBean.LOG.warn("Multiple setters for mbean attr {} in {}", new Object[]{name, oClass});
                    } else {
                        setter = methods[m];
                        if (!component_type.equals(methods[m].getParameterTypes()[0])) {
                            ObjectMBean.LOG.warn("Type conflict for mbean attr {} in {}", new Object[]{name, oClass});
                        } else {
                            ObjectMBean.LOG.debug("Declared Setter: " + declaredSetter, new Object[0]);
lbl35:
                            // 2 sources

                            if (methods[m].getName().equals("set" + uName) && methods[m].getParameterTypes().length == 1) {
                                if (setter != null) {
                                    ObjectMBean.LOG.warn("Multiple setters for mbean attr {} in {}", new Object[]{name, oClass});
                                } else {
                                    setter = methods[m];
                                    if (!return_type.equals(methods[m].getParameterTypes()[0])) {
                                        ObjectMBean.LOG.warn("Type conflict for mbean attr {} in {}", new Object[]{name, oClass});
                                    }
                                }
                            }
                        }
                    }
                }
                ++m;
            }
        }
        if (convert) {
            if (component_type == null) {
                ObjectMBean.LOG.warn("No mbean type for {} on {}", new Object[]{name, this._managed.getClass()});
                return null;
            }
            if (component_type.isPrimitive() && !component_type.isArray()) {
                ObjectMBean.LOG.warn("Cannot convert mbean primative {}", new Object[]{name});
                return null;
            }
            ObjectMBean.LOG.debug("passed convert checks {} for type {}", new Object[]{name, component_type});
        }
        try {
            this._getters.put(name, method);
            this._setters.put(name, setter);
            info = null;
            if (convert) {
                this._convert.add(name);
                info = component_type.isArray() ? new MBeanAttributeInfo(name, ObjectMBean.OBJECT_NAME_ARRAY_CLASS, description, true, setter != null, method.getName().startsWith("is")) : new MBeanAttributeInfo(name, ObjectMBean.OBJECT_NAME_CLASS, description, true, setter != null, method.getName().startsWith("is"));
            } else {
                info = new MBeanAttributeInfo(name, description, method, setter);
            }
            this._attributes.add(name);
            return info;
        }
        catch (Exception e) {
            ObjectMBean.LOG.warn(e);
            throw new IllegalArgumentException(e.toString());
        }
    }

    private MBeanOperationInfo defineOperation(Method method, ManagedOperation methodAnnotation) {
        Class<?> returnClass;
        MBeanParameterInfo[] pInfo;
        int impact;
        String signature;
        boolean convert;
        String description;
        block19: {
            description = methodAnnotation.value();
            boolean onMBean = methodAnnotation.proxied();
            convert = false;
            Class<?> returnType = method.getReturnType();
            if (returnType.isArray()) {
                LOG.debug("returnType is array, get component type", new Object[0]);
                returnType = returnType.getComponentType();
            }
            if (returnType.isAnnotationPresent(ManagedObject.class)) {
                convert = true;
            }
            String impactName = methodAnnotation.impact();
            LOG.debug("defineOperation {} {}:{}:{}", method.getName(), onMBean, impactName, description);
            signature = method.getName();
            try {
                impact = 3;
                if (impactName == null || impactName.equals("UNKNOWN")) {
                    impact = 3;
                } else if (impactName.equals("ACTION")) {
                    impact = 1;
                } else if (impactName.equals("INFO")) {
                    impact = 0;
                } else if (impactName.equals("ACTION_INFO")) {
                    impact = 2;
                } else {
                    LOG.warn("Unknown impact '" + impactName + "' for " + signature, new Object[0]);
                }
                Annotation[][] allParameterAnnotations = method.getParameterAnnotations();
                Class<?>[] methodTypes = method.getParameterTypes();
                pInfo = new MBeanParameterInfo[allParameterAnnotations.length];
                int i = 0;
                while (i < allParameterAnnotations.length) {
                    Annotation[] parameterAnnotations;
                    Annotation[] annotationArray = parameterAnnotations = allParameterAnnotations[i];
                    int n = parameterAnnotations.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Annotation anno = annotationArray[n2];
                        if (anno instanceof Name) {
                            Name nameAnnotation = (Name)anno;
                            pInfo[i] = new MBeanParameterInfo(nameAnnotation.value(), methodTypes[i].getName(), nameAnnotation.description());
                        }
                        ++n2;
                    }
                    ++i;
                }
                signature = String.valueOf(signature) + "(";
                i = 0;
                while (i < methodTypes.length) {
                    signature = String.valueOf(signature) + methodTypes[i].getName();
                    if (i != methodTypes.length - 1) {
                        signature = String.valueOf(signature) + ",";
                    }
                    ++i;
                }
                signature = String.valueOf(signature) + ")";
                returnClass = method.getReturnType();
                LOG.debug("Method Cache: " + signature, new Object[0]);
                if (!this._methods.containsKey(signature)) break block19;
                return null;
            }
            catch (Exception e) {
                LOG.warn("Operation '" + signature + "'", e);
                throw new IllegalArgumentException(e.toString());
            }
        }
        this._methods.put(signature, method);
        if (convert) {
            this._convert.add(signature);
        }
        return new MBeanOperationInfo(method.getName(), description, pInfo, returnClass.isPrimitive() ? TypeUtil.toName(returnClass) : returnClass.getName(), impact);
    }

    protected String toVariableName(String methodName) {
        String variableName = methodName;
        if (methodName.startsWith("get") || methodName.startsWith("set")) {
            variableName = variableName.substring(3);
        } else if (methodName.startsWith("is")) {
            variableName = variableName.substring(2);
        }
        variableName = String.valueOf(variableName.substring(0, 1).toLowerCase(Locale.ENGLISH)) + variableName.substring(1);
        return variableName;
    }

    protected boolean isAnnotationPresent(Class<?> clazz, Class<? extends Annotation> annotation) {
        Class<?> test = clazz;
        while (test != null) {
            if (test.isAnnotationPresent(annotation)) {
                return true;
            }
            test = test.getSuperclass();
        }
        return false;
    }
}

