/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jndi;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Statement;
import javax.sql.DataSource;
import org.eclipse.jetty.util.component.Destroyable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class DataSourceCloser
implements Destroyable {
    private static final Logger LOG = Log.getLogger(DataSourceCloser.class);
    final DataSource _datasource;
    final String _shutdown;

    public DataSourceCloser(DataSource datasource) {
        if (datasource == null) {
            throw new IllegalArgumentException();
        }
        this._datasource = datasource;
        this._shutdown = null;
    }

    public DataSourceCloser(DataSource datasource, String shutdownSQL) {
        if (datasource == null) {
            throw new IllegalArgumentException();
        }
        this._datasource = datasource;
        this._shutdown = shutdownSQL;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void destroy() {
        block16: {
            try {
                if (this._shutdown == null) break block16;
                LOG.info("Shutdown datasource {}", this._datasource);
                Throwable throwable = null;
                Object var2_5 = null;
                try {
                    Connection connection = this._datasource.getConnection();
                    try {
                        try (Statement stmt = connection.createStatement();){
                            stmt.executeUpdate(this._shutdown);
                        }
                        if (connection == null) break block16;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (connection == null) throw throwable;
                        connection.close();
                        throw throwable;
                    }
                    connection.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (Exception e) {
                LOG.warn(e);
            }
        }
        try {
            Method close = this._datasource.getClass().getMethod("close", new Class[0]);
            LOG.info("Close datasource {}", this._datasource);
            close.invoke((Object)this._datasource, new Object[0]);
            return;
        }
        catch (Exception e) {
            LOG.warn(e);
        }
    }
}

