/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.monitor;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServerConnection;
import org.eclipse.jetty.monitor.jmx.MonitorAction;
import org.eclipse.jetty.monitor.jmx.MonitorTask;
import org.eclipse.jetty.monitor.jmx.ServiceConnection;
import org.eclipse.jetty.xml.XmlConfiguration;

public class JMXMonitor {
    private static JMXMonitor __monitor = new JMXMonitor();
    private String _serverUrl;
    private ServiceConnection _serviceConnection;
    private Set<MonitorAction> _actions = new HashSet<MonitorAction>();

    public boolean addActions(MonitorAction ... actions) {
        return JMXMonitor.getInstance().add(actions);
    }

    public boolean removeActions(MonitorAction ... actions) {
        return JMXMonitor.getInstance().remove(actions);
    }

    public void setUrl(String url) {
        JMXMonitor.getInstance().set(url);
    }

    public MBeanServerConnection getConnection() throws IOException {
        return JMXMonitor.getInstance().get();
    }

    public static JMXMonitor getInstance() {
        return __monitor;
    }

    public static boolean addMonitorActions(MonitorAction ... actions) {
        return JMXMonitor.getInstance().add(actions);
    }

    public static boolean removeMonitorActions(MonitorAction ... actions) {
        return JMXMonitor.getInstance().remove(actions);
    }

    public static void setServiceUrl(String url) {
        JMXMonitor.getInstance().set(url);
    }

    public static MBeanServerConnection getServiceConnection() throws IOException {
        return JMXMonitor.getInstance().getConnection();
    }

    public static void main(String[] args) throws Exception {
        XmlConfiguration.main(args);
    }

    private synchronized boolean add(MonitorAction ... actions) {
        boolean result = true;
        MonitorAction[] monitorActionArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            MonitorAction action = monitorActionArray[n2];
            if (!this._actions.add(action)) {
                result = false;
            } else {
                MonitorTask.schedule(action);
            }
            ++n2;
        }
        return result;
    }

    private synchronized boolean remove(MonitorAction ... actions) {
        boolean result = true;
        MonitorAction[] monitorActionArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            MonitorAction action = monitorActionArray[n2];
            if (!this._actions.remove(action)) {
                result = false;
            }
            MonitorTask.cancel(action);
            ++n2;
        }
        return result;
    }

    private synchronized void set(String url) {
        this._serverUrl = url;
        if (this._serviceConnection != null) {
            this._serviceConnection.disconnect();
            this._serviceConnection = null;
        }
    }

    private synchronized MBeanServerConnection get() throws IOException {
        if (this._serviceConnection == null) {
            this._serviceConnection = new ServiceConnection(this._serverUrl);
            this._serviceConnection.connect();
        }
        return this._serviceConnection.getConnection();
    }
}

