/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.monitor.integration;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;

@ManagedObject(value="Java Monitoring Tools")
public class JavaMonitorTools {
    private static final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private static Method findDeadlockMethod = null;
    private static final int MAX_STACK = 10;
    private long lastSampled = 0L;
    private final Map<Thread.State, Integer> states = new HashMap<Thread.State, Integer>();
    private static final String POLICY = "sun.net.InetAddressCachePolicy";
    private static final String DEFAULT = "default";
    private static final String SECURITY = "security";
    private static final String SYSTEM = "system";
    private static final String BOTH = "both";
    private static final String SECURITY_TTL = "networkaddress.cache.ttl";
    private static final String SYSTEM_TTL = "sun.net.inetaddr.ttl";
    private static final String SECURITY_NEGATIVE_TTL = "networkaddress.cache.negative.ttl";
    private static final String SYSTEM_NEGATIVE_TTL = "sun.net.inetaddr.negative.ttl";

    static {
        try {
            findDeadlockMethod = ThreadMXBean.class.getMethod("findDeadlockedThreads", new Class[0]);
        }
        catch (Exception ignored) {
            try {
                findDeadlockMethod = ThreadMXBean.class.getMethod("findMonitorDeadlockedThreads", new Class[0]);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
    }

    private ThreadInfo[] findDeadlock() throws IllegalAccessException, InvocationTargetException {
        long[] threadIds = (long[])findDeadlockMethod.invoke((Object)threadMXBean, null);
        if (threadIds == null || threadIds.length < 1) {
            return null;
        }
        ThreadInfo[] threads = threadMXBean.getThreadInfo(threadIds, Integer.MAX_VALUE);
        return threads;
    }

    @ManagedOperation(value="Detailed report on the deadlocked threads.", impact="ACTION_INFO")
    public String getDeadlockStacktraces() {
        ThreadInfo[] threads;
        block3: {
            try {
                threads = this.findDeadlock();
                if (threads != null) break block3;
                return null;
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        return this.stacktraces(threads, 0);
    }

    private String stacktraces(ThreadInfo[] threads, int i) {
        if (i >= threads.length) {
            return "";
        }
        ThreadInfo thread = threads[i];
        StringBuilder trace = new StringBuilder();
        int stack_i = 0;
        while (stack_i < Math.min(thread.getStackTrace().length, 10)) {
            if (stack_i == 9) {
                trace.append("    ...");
            } else {
                trace.append("    at ").append(thread.getStackTrace()[stack_i]).append("\n");
            }
            ++stack_i;
        }
        return "\"" + thread.getThreadName() + "\", id " + thread.getThreadId() + " is " + (Object)((Object)thread.getThreadState()) + " on " + thread.getLockName() + ", owned by " + thread.getLockOwnerName() + ", id " + thread.getLockOwnerId() + "\n" + trace + "\n\n" + this.stacktraces(threads, i + 1);
    }

    @ManagedOperation(value="Number of Blocked Threads")
    public int getThreadsBlocked() {
        this.sampleThreads();
        return this.states.get((Object)Thread.State.BLOCKED);
    }

    @ManagedOperation(value="Number of New Threads", impact="ACTION_INFO")
    public int getThreadsNew() {
        this.sampleThreads();
        return this.states.get((Object)Thread.State.NEW);
    }

    @ManagedOperation(value="Number of Terminated Threads", impact="ACTION_INFO")
    public int getThreadsTerminated() {
        this.sampleThreads();
        return this.states.get((Object)Thread.State.TERMINATED);
    }

    @ManagedOperation(value="Number of Sleeping and Waiting threads")
    public int getThreadsTimedWaiting() {
        this.sampleThreads();
        return this.states.get((Object)Thread.State.TIMED_WAITING);
    }

    @ManagedOperation(value="Number of Waiting Threads", impact="ACTION_INFO")
    public int getThreadsWaiting() {
        this.sampleThreads();
        return this.states.get((Object)Thread.State.WAITING);
    }

    @ManagedOperation(value="Number of Runnable Threads", impact="ACTION_INFO")
    public int getThreadsRunnable() {
        this.sampleThreads();
        return this.states.get((Object)Thread.State.RUNNABLE);
    }

    private synchronized void sampleThreads() {
        if (this.lastSampled + 50L < System.currentTimeMillis()) {
            this.lastSampled = System.currentTimeMillis();
            Object[] objectArray = Thread.State.values();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Thread.State state = objectArray[n2];
                this.states.put(state, 0);
                ++n2;
            }
            objectArray = threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds());
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Thread.State thread = objectArray[n2];
                if (thread != null) {
                    Thread.State state = ((ThreadInfo)((Object)thread)).getThreadState();
                    this.states.put(state, this.states.get((Object)state) + 1);
                } else {
                    this.states.put(Thread.State.TERMINATED, this.states.get((Object)Thread.State.TERMINATED) + 1);
                }
                ++n2;
            }
        }
    }

    @ManagedOperation(value="Amount of time successful DNS queries are cached for.")
    public int getCacheSeconds() throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> policy = Class.forName(POLICY);
        Object returnValue = policy.getMethod("get", null).invoke(null, null);
        Integer seconds = (Integer)returnValue;
        return seconds;
    }

    @ManagedOperation(value="Amount of time failed DNS queries are cached for")
    public int getCacheNegativeSeconds() throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> policy = Class.forName(POLICY);
        Object returnValue = policy.getMethod("getNegative", null).invoke(null, null);
        Integer seconds = (Integer)returnValue;
        return seconds;
    }

    @ManagedOperation(value="Cache policy for successful DNS lookups was changed from the hard-coded default")
    public String getCacheTweakedFrom() {
        if (Security.getProperty(SECURITY_TTL) != null) {
            if (System.getProperty(SYSTEM_TTL) != null) {
                return BOTH;
            }
            return SECURITY;
        }
        if (System.getProperty(SYSTEM_TTL) != null) {
            return SYSTEM;
        }
        return DEFAULT;
    }

    @ManagedOperation(value="Cache policy for failed DNS lookups was changed from the hard-coded default")
    public String getCacheNegativeTweakedFrom() {
        if (Security.getProperty(SECURITY_NEGATIVE_TTL) != null) {
            if (System.getProperty(SYSTEM_NEGATIVE_TTL) != null) {
                return BOTH;
            }
            return SECURITY;
        }
        if (System.getProperty(SYSTEM_NEGATIVE_TTL) != null) {
            return SYSTEM;
        }
        return DEFAULT;
    }
}

