/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.rewrite.handler.Rule;

public abstract class RegexRule
extends Rule {
    protected Pattern _regex;

    public void setRegex(String regex) {
        this._regex = Pattern.compile(regex);
    }

    public String getRegex() {
        return this._regex == null ? null : this._regex.pattern();
    }

    @Override
    public String matchAndApply(String target, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Matcher matcher = this._regex.matcher(target);
        boolean matches = matcher.matches();
        if (matches) {
            return this.apply(target, request, response, matcher);
        }
        return null;
    }

    protected abstract String apply(String var1, HttpServletRequest var2, HttpServletResponse var3, Matcher var4) throws IOException;

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "[" + this._regex + "]";
    }
}

