/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.rewrite.handler.PatternRule;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.URIUtil;

public class RewritePatternRule
extends PatternRule
implements Rule.ApplyURI {
    private String _replacement;
    private String _query;

    public RewritePatternRule() {
        this._handling = false;
        this._terminating = false;
    }

    public void setReplacement(String replacement) {
        String[] split = replacement.split("\\?", 2);
        this._replacement = split[0];
        this._query = split.length == 2 ? split[1] : null;
    }

    @Override
    public String apply(String target, HttpServletRequest request, HttpServletResponse response) throws IOException {
        target = URIUtil.addPaths(this._replacement, PathMap.pathInfo(this._pattern, target));
        return target;
    }

    @Override
    public void applyURI(Request request, String oldURI, String newURI) throws IOException {
        if (this._query == null) {
            request.setRequestURI(newURI);
        } else {
            String queryString = request.getQueryString();
            queryString = queryString != null ? String.valueOf(queryString) + "&" + this._query : this._query;
            HttpURI uri = new HttpURI(String.valueOf(newURI) + "?" + queryString);
            request.setUri(uri);
            request.setRequestURI(newURI);
            request.setQueryString(queryString);
        }
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "[" + this._replacement + "]";
    }
}

