/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.security.CrossContextPsuedoSession;

public class HashCrossContextPsuedoSession<T>
implements CrossContextPsuedoSession<T> {
    private final String _cookieName;
    private final String _cookiePath;
    private final Random _random = new SecureRandom();
    private final Map<String, T> _data = new HashMap<String, T>();

    public HashCrossContextPsuedoSession(String cookieName, String cookiePath) {
        this._cookieName = cookieName;
        this._cookiePath = cookiePath == null ? "/" : cookiePath;
    }

    @Override
    public T fetch(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        Cookie[] cookieArray = cookies;
        int n = cookies.length;
        int n2 = 0;
        while (n2 < n) {
            Cookie cookie = cookieArray[n2];
            if (this._cookieName.equals(cookie.getName())) {
                String key = cookie.getValue();
                return this._data.get(key);
            }
            ++n2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(T datum, HttpServletResponse response) {
        String key;
        Map<String, T> map = this._data;
        synchronized (map) {
            while (this._data.containsKey(key = Long.toString(Math.abs(this._random.nextLong()), 30 + (int)(System.currentTimeMillis() % 7L)))) {
            }
            this._data.put(key, datum);
        }
        Cookie cookie = new Cookie(this._cookieName, key);
        cookie.setPath(this._cookiePath);
        response.addCookie(cookie);
    }

    @Override
    public void clear(HttpServletRequest request) {
        Cookie[] cookieArray = request.getCookies();
        int n = cookieArray.length;
        int n2 = 0;
        while (n2 < n) {
            Cookie cookie = cookieArray[n2];
            if (this._cookieName.equals(cookie.getName())) {
                String key = cookie.getValue();
                this._data.remove(key);
                break;
            }
            ++n2;
        }
    }
}

