/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.Cookie;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class CookieCutter {
    private static final Logger LOG = Log.getLogger(CookieCutter.class);
    private Cookie[] _cookies;
    private Cookie[] _lastCookies;
    private final List<String> _fieldList = new ArrayList<String>();
    int _fields;

    public Cookie[] getCookies() {
        if (this._cookies != null) {
            return this._cookies;
        }
        if (this._lastCookies != null && this._fields == this._fieldList.size()) {
            this._cookies = this._lastCookies;
        } else {
            this.parseFields();
        }
        this._lastCookies = this._cookies;
        return this._cookies;
    }

    public void setCookies(Cookie[] cookies) {
        this._cookies = cookies;
        this._lastCookies = null;
        this._fieldList.clear();
        this._fields = 0;
    }

    public void reset() {
        this._cookies = null;
        this._fields = 0;
    }

    /*
     * Unable to fully structure code
     */
    public void addCookieField(String f) {
        block3: {
            if (f == null) {
                return;
            }
            if ((f = f.trim()).length() == 0) {
                return;
            }
            if (this._fieldList.size() <= this._fields) break block3;
            if (!f.equals(this._fieldList.get(this._fields))) ** GOTO lbl11
            ++this._fields;
            return;
lbl-1000:
            // 1 sources

            {
                this._fieldList.remove(this._fields);
lbl11:
                // 2 sources

                ** while (this._fieldList.size() > this._fields)
            }
        }
        this._cookies = null;
        this._lastCookies = null;
        this._fieldList.add(this._fields++, f);
    }

    protected void parseFields() {
        this._lastCookies = null;
        this._cookies = null;
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        int version = 0;
        while (this._fieldList.size() > this._fields) {
            this._fieldList.remove(this._fields);
        }
        for (String hdr : this._fieldList) {
            String name = null;
            String value = null;
            Cookie cookie = null;
            boolean invalue = false;
            boolean quoted = false;
            boolean escaped = false;
            int tokenstart = -1;
            int tokenend = -1;
            int i = 0;
            int length = hdr.length();
            int last = length - 1;
            while (i < length) {
                block48: {
                    block49: {
                        char c;
                        block50: {
                            block46: {
                                block47: {
                                    c = hdr.charAt(i);
                                    if (!quoted) break block46;
                                    if (!escaped) break block47;
                                    escaped = false;
                                    break block48;
                                }
                                switch (c) {
                                    case '\"': {
                                        tokenend = i;
                                        quoted = false;
                                        if (i == last) {
                                            if (invalue) {
                                                value = hdr.substring(tokenstart, tokenend + 1);
                                            } else {
                                                name = hdr.substring(tokenstart, tokenend + 1);
                                                value = "";
                                            }
                                        }
                                        break block49;
                                    }
                                    case '\\': {
                                        escaped = true;
                                        break;
                                    }
                                }
                                break block48;
                            }
                            if (!invalue) break block50;
                            switch (c) {
                                case '\t': 
                                case ' ': {
                                    break block48;
                                }
                                case '\"': {
                                    if (tokenstart < 0) {
                                        quoted = true;
                                        tokenstart = i;
                                    }
                                    tokenend = i;
                                    if (i == last) {
                                        value = hdr.substring(tokenstart, tokenend + 1);
                                        break;
                                    }
                                    break block48;
                                }
                                case ';': {
                                    value = tokenstart >= 0 ? hdr.substring(tokenstart, tokenend + 1) : "";
                                    tokenstart = -1;
                                    invalue = false;
                                    break;
                                }
                                default: {
                                    if (tokenstart < 0) {
                                        tokenstart = i;
                                    }
                                    tokenend = i;
                                    if (i == last) {
                                        value = hdr.substring(tokenstart, tokenend + 1);
                                        break;
                                    }
                                    break block48;
                                }
                            }
                            break block49;
                        }
                        switch (c) {
                            case '\t': 
                            case ' ': {
                                break block48;
                            }
                            case '\"': {
                                if (tokenstart < 0) {
                                    quoted = true;
                                    tokenstart = i;
                                }
                                tokenend = i;
                                if (i == last) {
                                    name = hdr.substring(tokenstart, tokenend + 1);
                                    value = "";
                                    break;
                                }
                                break block48;
                            }
                            case ';': {
                                if (tokenstart >= 0) {
                                    name = hdr.substring(tokenstart, tokenend + 1);
                                    value = "";
                                }
                                tokenstart = -1;
                                break;
                            }
                            case '=': {
                                if (tokenstart >= 0) {
                                    name = hdr.substring(tokenstart, tokenend + 1);
                                }
                                tokenstart = -1;
                                invalue = true;
                                break block48;
                            }
                            default: {
                                if (tokenstart < 0) {
                                    tokenstart = i;
                                }
                                tokenend = i;
                                if (i != last) break block48;
                                name = hdr.substring(tokenstart, tokenend + 1);
                                value = "";
                            }
                        }
                    }
                    if (value != null && name != null) {
                        name = QuotedStringTokenizer.unquoteOnly(name);
                        value = QuotedStringTokenizer.unquoteOnly(value);
                        try {
                            if (name.startsWith("$")) {
                                String lowercaseName = name.toLowerCase(Locale.ENGLISH);
                                if ("$path".equals(lowercaseName)) {
                                    if (cookie != null) {
                                        cookie.setPath(value);
                                    }
                                } else if ("$domain".equals(lowercaseName)) {
                                    if (cookie != null) {
                                        cookie.setDomain(value);
                                    }
                                } else if ("$port".equals(lowercaseName)) {
                                    if (cookie != null) {
                                        cookie.setComment("$port=" + value);
                                    }
                                } else if ("$version".equals(lowercaseName)) {
                                    version = Integer.parseInt(value);
                                }
                            } else {
                                cookie = new Cookie(name, value);
                                if (version > 0) {
                                    cookie.setVersion(version);
                                }
                                cookies.add(cookie);
                            }
                        }
                        catch (Exception e) {
                            LOG.debug(e);
                        }
                        name = null;
                        value = null;
                    }
                }
                ++i;
            }
        }
        this._cookies = cookies.toArray(new Cookie[cookies.size()]);
        this._lastCookies = this._cookies;
    }
}

