/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.ChannelEndPoint;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.SharedBlockingCallback;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class HttpChannel<T>
implements HttpParser.RequestHandler<T>,
Runnable {
    private static final Logger LOG = Log.getLogger(HttpChannel.class);
    private static final ThreadLocal<HttpChannel<?>> __currentChannel = new ThreadLocal();
    private final AtomicBoolean _committed = new AtomicBoolean();
    private final AtomicInteger _requests = new AtomicInteger();
    private final Connector _connector;
    private final HttpConfiguration _configuration;
    private final EndPoint _endPoint;
    private final HttpTransport _transport;
    private final HttpURI _uri;
    private final HttpChannelState _state;
    private final Request _request;
    private final Response _response;
    private HttpVersion _version = HttpVersion.HTTP_1_1;
    private boolean _expect = false;
    private boolean _expect100Continue = false;
    private boolean _expect102Processing = false;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$jetty$server$HttpChannelState$Action;

    public static HttpChannel<?> getCurrentHttpChannel() {
        return __currentChannel.get();
    }

    protected static HttpChannel<?> setCurrentHttpChannel(HttpChannel<?> channel) {
        HttpChannel<?> last = __currentChannel.get();
        if (channel == null) {
            __currentChannel.remove();
        } else {
            __currentChannel.set(channel);
        }
        return last;
    }

    public HttpChannel(Connector connector, HttpConfiguration configuration, EndPoint endPoint, HttpTransport transport, HttpInput<T> input) {
        this._connector = connector;
        this._configuration = configuration;
        this._endPoint = endPoint;
        this._transport = transport;
        this._uri = new HttpURI(URIUtil.__CHARSET);
        this._state = new HttpChannelState(this);
        input.init(this._state);
        this._request = new Request(this, input);
        this._response = new Response(this, new HttpOutput(this));
    }

    public HttpChannelState getState() {
        return this._state;
    }

    public HttpVersion getHttpVersion() {
        return this._version;
    }

    public int getRequests() {
        return this._requests.get();
    }

    public Connector getConnector() {
        return this._connector;
    }

    public HttpTransport getHttpTransport() {
        return this._transport;
    }

    public ByteBufferPool getByteBufferPool() {
        return this._connector.getByteBufferPool();
    }

    public HttpConfiguration getHttpConfiguration() {
        return this._configuration;
    }

    public Server getServer() {
        return this._connector.getServer();
    }

    public Request getRequest() {
        return this._request;
    }

    public Response getResponse() {
        return this._response;
    }

    public EndPoint getEndPoint() {
        return this._endPoint;
    }

    public InetSocketAddress getLocalAddress() {
        return this._endPoint.getLocalAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return this._endPoint.getRemoteAddress();
    }

    @Override
    public int getHeaderCacheSize() {
        return this._configuration.getHeaderCacheSize();
    }

    public void continue100(int available) throws IOException {
        if (this.isExpecting100Continue()) {
            this._expect100Continue = false;
            if (available == 0) {
                if (this._response.isCommitted()) {
                    throw new IOException("Committed before 100 Continues");
                }
                boolean committed = this.sendResponse(HttpGenerator.CONTINUE_100_INFO, null, false);
                if (!committed) {
                    throw new IOException("Concurrent commit while trying to send 100-Continue");
                }
            }
        }
    }

    public void reset() {
        this._committed.set(false);
        this._expect = false;
        this._expect100Continue = false;
        this._expect102Processing = false;
        this._request.recycle();
        this._response.recycle();
        this._uri.clear();
    }

    @Override
    public void run() {
        this.handle();
    }

    /*
     * Exception decompiling
     */
    public boolean handle() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [24[DOLOOP]], but top level block is 39[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void handleException(Throwable x) {
        try {
            this._request.setAttribute("javax.servlet.error.exception", x);
            this._request.setAttribute("javax.servlet.error.exception_type", x.getClass());
            if (this._state.isSuspended()) {
                HttpFields fields = new HttpFields();
                fields.add(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE);
                HttpGenerator.ResponseInfo info = new HttpGenerator.ResponseInfo(this._request.getHttpVersion(), fields, 0L, 500, null, this._request.isHead());
                boolean committed = this.sendResponse(info, null, true);
                if (!committed) {
                    LOG.warn("Could not send response error 500: " + x, new Object[0]);
                }
                this._request.getAsyncContext().complete();
            } else if (this.isCommitted()) {
                this._transport.abort();
                if (!(x instanceof EofException)) {
                    LOG.warn("Could not send response error 500: " + x, new Object[0]);
                }
            } else {
                this._response.setHeader(HttpHeader.CONNECTION.asString(), HttpHeaderValue.CLOSE.asString());
                this._response.sendError(500, x.getMessage());
            }
        }
        catch (IOException e) {
            LOG.debug("Could not commit response error 500", e);
        }
    }

    public boolean isExpecting100Continue() {
        return this._expect100Continue;
    }

    public boolean isExpecting102Processing() {
        return this._expect102Processing;
    }

    public String toString() {
        return String.format("%s@%x{r=%s,a=%s,uri=%s}", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._requests, this._state.getState(), this._state.getState() == HttpChannelState.State.IDLE ? "-" : this._request.getRequestURI()});
    }

    @Override
    public boolean startRequest(HttpMethod httpMethod, String method, ByteBuffer uri, HttpVersion version) {
        String path;
        this._expect = false;
        this._expect100Continue = false;
        this._expect102Processing = false;
        this._request.setTimeStamp(System.currentTimeMillis());
        this._request.setMethod(httpMethod, method);
        if (httpMethod == HttpMethod.CONNECT) {
            this._uri.parseConnect(uri.array(), uri.arrayOffset() + uri.position(), uri.remaining());
        } else {
            this._uri.parse(uri.array(), uri.arrayOffset() + uri.position(), uri.remaining());
        }
        this._request.setUri(this._uri);
        try {
            path = this._uri.getDecodedPath();
        }
        catch (Exception e) {
            LOG.warn("Failed UTF-8 decode for request path, trying ISO-8859-1", new Object[0]);
            LOG.ignore(e);
            path = this._uri.getDecodedPath(StandardCharsets.ISO_8859_1);
        }
        String info = URIUtil.canonicalPath(path);
        if (info == null) {
            if (path == null && this._uri.getScheme() != null && this._uri.getHost() != null) {
                info = "/";
                this._request.setRequestURI("");
            } else {
                this.badMessage(400, null);
                return true;
            }
        }
        this._request.setPathInfo(info);
        this._version = version == null ? HttpVersion.HTTP_0_9 : version;
        this._request.setHttpVersion(this._version);
        return false;
    }

    @Override
    public boolean parsedHeader(HttpField field) {
        HttpHeader header = field.getHeader();
        String value = field.getValue();
        if (value == null) {
            value = "";
        }
        if (header != null) {
            block0 : switch (header) {
                case EXPECT: {
                    if (this._version.getVersion() < HttpVersion.HTTP_1_1.getVersion()) break;
                    HttpHeaderValue expect = HttpHeaderValue.CACHE.get(value);
                    switch (expect == null ? HttpHeaderValue.UNKNOWN : expect) {
                        case CONTINUE: {
                            this._expect100Continue = true;
                            break block0;
                        }
                        case PROCESSING: {
                            this._expect102Processing = true;
                            break block0;
                        }
                    }
                    String[] values = value.split(",");
                    int i = 0;
                    while (values != null && i < values.length) {
                        expect = HttpHeaderValue.CACHE.get(values[i].trim());
                        if (expect == null) {
                            this._expect = true;
                        } else {
                            switch (expect) {
                                case CONTINUE: {
                                    this._expect100Continue = true;
                                    break;
                                }
                                case PROCESSING: {
                                    this._expect102Processing = true;
                                    break;
                                }
                                default: {
                                    this._expect = true;
                                }
                            }
                        }
                        ++i;
                    }
                    break;
                }
                case CONTENT_TYPE: {
                    String charset;
                    MimeTypes.Type mime = MimeTypes.CACHE.get(value);
                    String string = charset = mime == null || mime.getCharset() == null ? MimeTypes.getCharsetFromContentType(value) : mime.getCharset().toString();
                    if (charset == null) break;
                    this._request.setCharacterEncodingUnchecked(charset);
                }
            }
        }
        if (field.getName() != null) {
            this._request.getHttpFields().add(field);
        }
        return false;
    }

    @Override
    public boolean parsedHostHeader(String host, int port) {
        if (this._uri.getHost() == null) {
            this._request.setServerName(host);
            this._request.setServerPort(port);
        }
        return false;
    }

    @Override
    public boolean headerComplete() {
        this._requests.incrementAndGet();
        switch (this._version) {
            case HTTP_0_9: {
                break;
            }
            case HTTP_1_0: {
                if (!this._configuration.getSendDateHeader()) break;
                this._response.getHttpFields().put(this._connector.getServer().getDateField());
                break;
            }
            case HTTP_1_1: {
                if (this._configuration.getSendDateHeader()) {
                    this._response.getHttpFields().put(this._connector.getServer().getDateField());
                }
                if (!this._expect) break;
                this.badMessage(417, null);
                return true;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return true;
    }

    @Override
    public boolean content(T item) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} content {}", this, item);
        }
        HttpInput<?> input = this._request.getHttpInput();
        input.content(item);
        return false;
    }

    @Override
    public boolean messageComplete() {
        LOG.debug("{} messageComplete", this);
        this._request.getHttpInput().messageComplete();
        return true;
    }

    @Override
    public void earlyEOF() {
        this._request.getHttpInput().earlyEOF();
    }

    @Override
    public void badMessage(int status, String reason) {
        block10: {
            if (status < 400 || status > 599) {
                status = 400;
            }
            try {
                try {
                    if (this._state.handling() == HttpChannelState.Action.REQUEST_DISPATCH) {
                        ByteBuffer content = null;
                        HttpFields fields = new HttpFields();
                        ErrorHandler handler = this.getServer().getBean(ErrorHandler.class);
                        if (handler != null) {
                            content = handler.badMessageError(status, reason, fields);
                        }
                        this.sendResponse(new HttpGenerator.ResponseInfo(HttpVersion.HTTP_1_1, fields, 0L, status, reason, false), content, true);
                    }
                }
                catch (IOException e) {
                    LOG.debug(e);
                    if (this._state.unhandle() == HttpChannelState.Action.COMPLETE) {
                        this._state.completed();
                        break block10;
                    }
                    throw new IllegalStateException();
                }
            }
            finally {
                if (this._state.unhandle() != HttpChannelState.Action.COMPLETE) {
                    throw new IllegalStateException();
                }
                this._state.completed();
            }
        }
    }

    protected boolean sendResponse(HttpGenerator.ResponseInfo info, ByteBuffer content, boolean complete, Callback callback) {
        boolean committing = this._committed.compareAndSet(false, true);
        if (committing) {
            int status;
            if (info == null) {
                info = this._response.newResponseInfo();
            }
            CommitCallback committed = (status = info.getStatus()) < 200 && status >= 100 ? new Commit100Callback(callback) : new CommitCallback(callback, null, null);
            this._transport.send(info, content, complete, committed);
        } else if (info == null) {
            this._transport.send(content, complete, callback);
        } else {
            callback.failed(new IllegalStateException("committed"));
        }
        return committing;
    }

    protected boolean sendResponse(HttpGenerator.ResponseInfo info, ByteBuffer content, boolean complete) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (SharedBlockingCallback.Blocker blocker = this._response.getHttpOutput().acquireWriteBlockingCallback();){
            boolean committing = this.sendResponse(info, content, complete, blocker);
            blocker.block();
            return committing;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public boolean isCommitted() {
        return this._committed.get();
    }

    protected void write(ByteBuffer content, boolean complete, Callback callback) {
        this.sendResponse(null, content, complete, callback);
    }

    protected void execute(Runnable task) {
        this._connector.getExecutor().execute(task);
    }

    public Scheduler getScheduler() {
        return this._connector.getScheduler();
    }

    public boolean useDirectBuffers() {
        return this.getEndPoint() instanceof ChannelEndPoint;
    }

    public void failed() {
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$jetty$server$HttpChannelState$Action() {
        if ($SWITCH_TABLE$org$eclipse$jetty$server$HttpChannelState$Action != null) {
            return $SWITCH_TABLE$org$eclipse$jetty$server$HttpChannelState$Action;
        }
        int[] nArray = new int[HttpChannelState.Action.values().length];
        try {
            nArray[HttpChannelState.Action.ASYNC_DISPATCH.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HttpChannelState.Action.ASYNC_EXPIRED.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HttpChannelState.Action.COMPLETE.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HttpChannelState.Action.READ_CALLBACK.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HttpChannelState.Action.REQUEST_DISPATCH.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HttpChannelState.Action.WAIT.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HttpChannelState.Action.WRITE_CALLBACK.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$eclipse$jetty$server$HttpChannelState$Action = nArray;
        return nArray;
    }

    private class Commit100Callback
    extends CommitCallback {
        private Commit100Callback(Callback callback) {
            super(callback);
        }

        @Override
        public void succeeded() {
            HttpChannel.this._committed.set(false);
            super.succeeded();
        }
    }

    private class CommitCallback
    implements Callback {
        private final Callback _callback;

        private CommitCallback(Callback callback) {
            this._callback = callback;
        }

        @Override
        public void succeeded() {
            this._callback.succeeded();
        }

        @Override
        public void failed(final Throwable x) {
            if (x instanceof EofException || x instanceof ClosedChannelException) {
                LOG.debug(x);
                this._callback.failed(x);
                HttpChannel.this._response.getHttpOutput().closed();
            } else {
                LOG.warn("Commit failed", x);
                HttpChannel.this._transport.send(HttpGenerator.RESPONSE_500_INFO, null, true, new Callback(){

                    @Override
                    public void succeeded() {
                        CommitCallback.this._callback.failed(x);
                        HttpChannel.this._response.getHttpOutput().closed();
                    }

                    @Override
                    public void failed(Throwable th) {
                        LOG.ignore(th);
                        CommitCallback.this._callback.failed(x);
                        HttpChannel.this._response.getHttpOutput().closed();
                    }
                });
            }
        }

        /* synthetic */ CommitCallback(Callback callback, CommitCallback commitCallback, CommitCallback commitCallback2) {
            this(callback);
        }
    }
}

