/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.nio.ByteBuffer;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpInputOverHTTP;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpConnection
extends AbstractConnection
implements Runnable,
HttpTransport {
    public static final String UPGRADE_CONNECTION_ATTRIBUTE = "org.eclipse.jetty.server.HttpConnection.UPGRADE";
    private static final boolean REQUEST_BUFFER_DIRECT = false;
    private static final boolean HEADER_BUFFER_DIRECT = false;
    private static final boolean CHUNK_BUFFER_DIRECT = false;
    private static final Logger LOG = Log.getLogger(HttpConnection.class);
    private static final ThreadLocal<HttpConnection> __currentConnection = new ThreadLocal();
    private final HttpConfiguration _config;
    private final Connector _connector;
    private final ByteBufferPool _bufferPool;
    private final HttpGenerator _generator;
    private final HttpChannelOverHttp _channel;
    private final HttpParser _parser;
    private volatile ByteBuffer _requestBuffer = null;
    private volatile ByteBuffer _chunk = null;

    public static HttpConnection getCurrentConnection() {
        return __currentConnection.get();
    }

    protected static HttpConnection setCurrentConnection(HttpConnection connection) {
        HttpConnection last = __currentConnection.get();
        if (connection == null) {
            __currentConnection.remove();
        } else {
            __currentConnection.set(connection);
        }
        return last;
    }

    public HttpConfiguration getHttpConfiguration() {
        return this._config;
    }

    public HttpConnection(HttpConfiguration config, Connector connector, EndPoint endPoint) {
        super(endPoint, connector.getExecutor(), true);
        this._config = config;
        this._connector = connector;
        this._bufferPool = this._connector.getByteBufferPool();
        this._generator = this.newHttpGenerator();
        HttpInput<ByteBuffer> input = this.newHttpInput();
        this._channel = this.newHttpChannel(input);
        this._parser = this.newHttpParser();
        LOG.debug("New HTTP Connection {}", this);
    }

    protected HttpGenerator newHttpGenerator() {
        return new HttpGenerator(this._config.getSendServerVersion(), this._config.getSendXPoweredBy());
    }

    protected HttpInput<ByteBuffer> newHttpInput() {
        return new HttpInputOverHTTP(this);
    }

    protected HttpChannelOverHttp newHttpChannel(HttpInput<ByteBuffer> httpInput) {
        return new HttpChannelOverHttp(this._connector, this._config, this.getEndPoint(), this, httpInput);
    }

    protected HttpParser newHttpParser() {
        return new HttpParser(this.newRequestHandler(), this.getHttpConfiguration().getRequestHeaderSize());
    }

    protected HttpParser.RequestHandler<ByteBuffer> newRequestHandler() {
        return this._channel;
    }

    public Server getServer() {
        return this._connector.getServer();
    }

    public Connector getConnector() {
        return this._connector;
    }

    public HttpChannel<?> getHttpChannel() {
        return this._channel;
    }

    public HttpParser getParser() {
        return this._parser;
    }

    @Override
    public int getMessagesIn() {
        return this.getHttpChannel().getRequests();
    }

    @Override
    public int getMessagesOut() {
        return this.getHttpChannel().getRequests();
    }

    void releaseRequestBuffer() {
        if (this._requestBuffer != null && !this._requestBuffer.hasRemaining()) {
            ByteBuffer buffer = this._requestBuffer;
            this._requestBuffer = null;
            this._bufferPool.release(buffer);
        }
    }

    public ByteBuffer getRequestBuffer() {
        if (this._requestBuffer == null) {
            this._requestBuffer = this._bufferPool.acquire(this.getInputBufferSize(), false);
        }
        return this._requestBuffer;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void onFillable() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[DOLOOP]], but top level block is 19[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void onFillInterestedFailed(Throwable cause) {
        this._parser.close();
        super.onFillInterestedFailed(cause);
    }

    @Override
    public void onOpen() {
        super.onOpen();
        this.fillInterested();
    }

    @Override
    public void run() {
        this.onFillable();
    }

    @Override
    public void send(HttpGenerator.ResponseInfo info, ByteBuffer content, boolean lastContent, Callback callback) {
        if (info == null) {
            new ContentCallback(content, lastContent, callback).iterate();
        } else {
            if (this._channel.isExpecting100Continue()) {
                this._generator.setPersistent(false);
            }
            new CommitCallback(info, content, lastContent, callback).iterate();
        }
    }

    @Override
    public void send(ByteBuffer content, boolean lastContent, Callback callback) {
        new ContentCallback(content, lastContent, callback).iterate();
    }

    @Override
    public void completed() {
        Connection connection;
        if (this._channel.getResponse().getStatus() == 101 && (connection = (Connection)this._channel.getRequest().getAttribute(UPGRADE_CONNECTION_ATTRIBUTE)) != null) {
            LOG.debug("Upgrade from {} to {}", this, connection);
            this.onClose();
            this.getEndPoint().setConnection(connection);
            connection.onOpen();
            this._channel.reset();
            this._parser.reset();
            this._generator.reset();
            this.releaseRequestBuffer();
            return;
        }
        if (this._channel.isExpecting100Continue()) {
            this._parser.close();
        } else if (this._parser.inContentState() && this._generator.isPersistent()) {
            this._channel.getRequest().getHttpInput().consumeAll();
        }
        this._channel.reset();
        if (this._generator.isPersistent() && !this._parser.isClosed()) {
            this._parser.reset();
        } else {
            this._parser.close();
        }
        this.releaseRequestBuffer();
        if (this._chunk != null) {
            this._bufferPool.release(this._chunk);
        }
        this._chunk = null;
        this._generator.reset();
        if (HttpConnection.getCurrentConnection() != this) {
            if (this._parser.isStart()) {
                if (this._requestBuffer == null) {
                    this.fillInterested();
                } else if (this.getConnector().isRunning()) {
                    try {
                        this.getExecutor().execute(this);
                    }
                    catch (RejectedExecutionException e) {
                        if (this.getConnector().isRunning()) {
                            LOG.warn(e);
                        } else {
                            LOG.ignore(e);
                        }
                        this.getEndPoint().close();
                    }
                } else {
                    this.getEndPoint().close();
                }
            } else if (this.getEndPoint().isOpen()) {
                this.fillInterested();
            }
        }
    }

    @Override
    public void abort() {
        this.getEndPoint().close();
    }

    private class CommitCallback
    extends IteratingCallback {
        final ByteBuffer _content;
        final boolean _lastContent;
        final HttpGenerator.ResponseInfo _info;
        final Callback _callback;
        ByteBuffer _header;

        CommitCallback(HttpGenerator.ResponseInfo info, ByteBuffer content, boolean last, Callback callback) {
            this._info = info;
            this._content = content;
            this._lastContent = last;
            this._callback = callback;
        }

        @Override
        public IteratingCallback.Action process() throws Exception {
            HttpGenerator.Result result;
            ByteBuffer chunk = HttpConnection.this._chunk;
            block8: while (true) {
                result = HttpConnection.this._generator.generateResponse(this._info, this._header, chunk, this._content, this._lastContent);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} generate: {} ({},{},{})@{}", new Object[]{this, result, BufferUtil.toSummaryString(this._header), BufferUtil.toSummaryString(this._content), this._lastContent, HttpConnection.this._generator.getState()});
                }
                switch (result) {
                    case NEED_HEADER: {
                        this._header = HttpConnection.this._bufferPool.acquire(HttpConnection.this._config.getResponseHeaderSize(), false);
                        continue block8;
                    }
                    case NEED_CHUNK: {
                        HttpConnection.this._chunk = HttpConnection.this._bufferPool.acquire(12, false);
                        continue block8;
                    }
                    case FLUSH: {
                        if (HttpConnection.this._channel.getRequest().isHead()) {
                            BufferUtil.clear(chunk);
                            BufferUtil.clear(this._content);
                        }
                        if (BufferUtil.hasContent(this._header)) {
                            if (BufferUtil.hasContent(this._content)) {
                                if (BufferUtil.hasContent(chunk)) {
                                    HttpConnection.this.getEndPoint().write(this, this._header, chunk, this._content);
                                } else {
                                    HttpConnection.this.getEndPoint().write(this, this._header, this._content);
                                }
                            } else {
                                HttpConnection.this.getEndPoint().write(this, this._header);
                            }
                        } else if (BufferUtil.hasContent(chunk)) {
                            if (BufferUtil.hasContent(this._content)) {
                                HttpConnection.this.getEndPoint().write(this, chunk, this._content);
                            } else {
                                HttpConnection.this.getEndPoint().write(this, chunk);
                            }
                        } else {
                            if (!BufferUtil.hasContent(this._content)) continue block8;
                            HttpConnection.this.getEndPoint().write(this, this._content);
                        }
                        return IteratingCallback.Action.SCHEDULED;
                    }
                    case SHUTDOWN_OUT: {
                        HttpConnection.this.getEndPoint().shutdownOutput();
                        continue block8;
                    }
                    case DONE: {
                        if (!(this._header == null || this._lastContent && this._content != null && this._content.hasArray() && this._header.hasArray() && this._content.array() == this._header.array())) {
                            HttpConnection.this._bufferPool.release(this._header);
                        }
                        return IteratingCallback.Action.SUCCEEDED;
                    }
                    case CONTINUE: {
                        continue block8;
                    }
                }
                break;
            }
            throw new IllegalStateException("generateResponse=" + (Object)((Object)result));
        }

        @Override
        protected void completed() {
            this._callback.succeeded();
        }

        @Override
        public void failed(Throwable x) {
            super.failed(x);
            HttpConnection.this.failedCallback(this._callback, x);
        }
    }

    private class ContentCallback
    extends IteratingCallback {
        final ByteBuffer _content;
        final boolean _lastContent;
        final Callback _callback;

        ContentCallback(ByteBuffer content, boolean last, Callback callback) {
            this._content = content;
            this._lastContent = last;
            this._callback = callback;
        }

        @Override
        public IteratingCallback.Action process() throws Exception {
            HttpGenerator.Result result;
            ByteBuffer chunk = HttpConnection.this._chunk;
            block8: while (true) {
                result = HttpConnection.this._generator.generateResponse(null, null, chunk, this._content, this._lastContent);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} generate: {} ({},{})@{}", new Object[]{this, result, BufferUtil.toSummaryString(this._content), this._lastContent, HttpConnection.this._generator.getState()});
                }
                switch (result) {
                    case NEED_HEADER: {
                        throw new IllegalStateException();
                    }
                    case NEED_CHUNK: {
                        HttpConnection.this._chunk = HttpConnection.this._bufferPool.acquire(12, false);
                        continue block8;
                    }
                    case FLUSH: {
                        if (HttpConnection.this._channel.getRequest().isHead()) {
                            BufferUtil.clear(chunk);
                            BufferUtil.clear(this._content);
                            continue block8;
                        }
                        if (BufferUtil.hasContent(chunk)) {
                            if (BufferUtil.hasContent(this._content)) {
                                HttpConnection.this.getEndPoint().write(this, chunk, this._content);
                            } else {
                                HttpConnection.this.getEndPoint().write(this, chunk);
                            }
                        } else {
                            if (!BufferUtil.hasContent(this._content)) continue block8;
                            HttpConnection.this.getEndPoint().write(this, this._content);
                        }
                        return IteratingCallback.Action.SCHEDULED;
                    }
                    case SHUTDOWN_OUT: {
                        HttpConnection.this.getEndPoint().shutdownOutput();
                        continue block8;
                    }
                    case DONE: {
                        return IteratingCallback.Action.SUCCEEDED;
                    }
                    case CONTINUE: {
                        continue block8;
                    }
                }
                break;
            }
            throw new IllegalStateException("generateResponse=" + (Object)((Object)result));
        }

        @Override
        protected void completed() {
            this._callback.succeeded();
        }

        @Override
        public void failed(Throwable x) {
            super.failed(x);
            HttpConnection.this.failedCallback(this._callback, x);
        }
    }

    protected class HttpChannelOverHttp
    extends HttpChannel<ByteBuffer> {
        public HttpChannelOverHttp(Connector connector, HttpConfiguration config, EndPoint endPoint, HttpTransport transport, HttpInput<ByteBuffer> input) {
            super(connector, config, endPoint, transport, input);
        }

        @Override
        public void earlyEOF() {
            if (this.getRequest().getMethod() == null) {
                HttpConnection.this.close();
            } else {
                super.earlyEOF();
            }
        }

        @Override
        public boolean content(ByteBuffer item) {
            super.content(item);
            return true;
        }

        @Override
        public void badMessage(int status, String reason) {
            HttpConnection.this._generator.setPersistent(false);
            super.badMessage(status, reason);
        }

        @Override
        public boolean headerComplete() {
            boolean persistent;
            HttpVersion version = this.getHttpVersion();
            switch (version) {
                case HTTP_0_9: {
                    persistent = false;
                    break;
                }
                case HTTP_1_0: {
                    persistent = this.getRequest().getHttpFields().contains(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE.asString());
                    if (!persistent) {
                        persistent = HttpMethod.CONNECT.is(this.getRequest().getMethod());
                    }
                    if (!persistent) break;
                    this.getResponse().getHttpFields().add(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE);
                    break;
                }
                case HTTP_1_1: {
                    boolean bl = persistent = !this.getRequest().getHttpFields().contains(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.asString());
                    if (!persistent) {
                        persistent = HttpMethod.CONNECT.is(this.getRequest().getMethod());
                    }
                    if (persistent) break;
                    this.getResponse().getHttpFields().add(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (!persistent) {
                HttpConnection.this._generator.setPersistent(false);
            }
            return super.headerComplete();
        }

        @Override
        protected void handleException(Throwable x) {
            HttpConnection.this._generator.setPersistent(false);
            super.handleException(x);
        }

        @Override
        public void failed() {
            this.getEndPoint().shutdownOutput();
        }
    }
}

