/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.eclipse.jetty.util.thread.ShutdownThread;

public class ShutdownMonitor {
    private boolean DEBUG;
    private int port;
    private String key;
    private boolean exitVm;
    private ServerSocket serverSocket;
    private ShutdownMonitorThread thread;

    public static ShutdownMonitor getInstance() {
        return Holder.instance;
    }

    private ShutdownMonitor() {
        Properties props = System.getProperties();
        this.DEBUG = props.containsKey("DEBUG");
        this.port = Integer.parseInt(props.getProperty("STOP.PORT", "-1"));
        this.key = props.getProperty("STOP.KEY", null);
        this.exitVm = true;
    }

    private void close(ServerSocket server) {
        if (server == null) {
            return;
        }
        try {
            server.close();
        }
        catch (IOException ignore) {
            this.debug(ignore);
        }
    }

    private void close(Socket socket) {
        if (socket == null) {
            return;
        }
        try {
            socket.close();
        }
        catch (IOException ignore) {
            this.debug(ignore);
        }
    }

    private void shutdownInput(Socket socket) {
        if (socket == null) {
            return;
        }
        try {
            socket.shutdownInput();
        }
        catch (IOException ignore) {
            this.debug(ignore);
        }
    }

    private void debug(String format, Object ... args) {
        if (this.DEBUG) {
            System.err.printf("[ShutdownMonitor] " + format + "%n", args);
        }
    }

    private void debug(Throwable t) {
        if (this.DEBUG) {
            t.printStackTrace(System.err);
        }
    }

    public String getKey() {
        return this.key;
    }

    public int getPort() {
        return this.port;
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public boolean isExitVm() {
        return this.exitVm;
    }

    public void setDebug(boolean flag) {
        this.DEBUG = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExitVm(boolean exitVm) {
        ShutdownMonitor shutdownMonitor = this;
        synchronized (shutdownMonitor) {
            if (this.thread != null && this.thread.isAlive()) {
                throw new IllegalStateException("ShutdownMonitorThread already started");
            }
            this.exitVm = exitVm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKey(String key) {
        ShutdownMonitor shutdownMonitor = this;
        synchronized (shutdownMonitor) {
            if (this.thread != null && this.thread.isAlive()) {
                throw new IllegalStateException("ShutdownMonitorThread already started");
            }
            this.key = key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPort(int port) {
        ShutdownMonitor shutdownMonitor = this;
        synchronized (shutdownMonitor) {
            if (this.thread != null && this.thread.isAlive()) {
                throw new IllegalStateException("ShutdownMonitorThread already started");
            }
            this.port = port;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() throws Exception {
        ShutdownMonitorThread t = null;
        ShutdownMonitor shutdownMonitor = this;
        synchronized (shutdownMonitor) {
            if (this.thread != null && this.thread.isAlive()) {
                if (this.DEBUG) {
                    System.err.printf("ShutdownMonitorThread already started", new Object[0]);
                }
                return;
            }
            t = this.thread = new ShutdownMonitorThread();
        }
        if (t != null) {
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isAlive() {
        boolean result = false;
        ShutdownMonitor shutdownMonitor = this;
        synchronized (shutdownMonitor) {
            result = this.thread != null && this.thread.isAlive();
        }
        return result;
    }

    public String toString() {
        return String.format("%s[port=%d]", this.getClass().getName(), this.port);
    }

    /* synthetic */ ShutdownMonitor(ShutdownMonitor shutdownMonitor) {
        this();
    }

    static /* synthetic */ void access$2(ShutdownMonitor shutdownMonitor, Socket socket) {
        shutdownMonitor.close(socket);
    }

    static /* synthetic */ void access$5(ShutdownMonitor shutdownMonitor, ServerSocket serverSocket) {
        shutdownMonitor.close(serverSocket);
    }

    static /* synthetic */ void access$7(ShutdownMonitor shutdownMonitor, Socket socket) {
        shutdownMonitor.shutdownInput(socket);
    }

    static /* synthetic */ boolean access$8(ShutdownMonitor shutdownMonitor) {
        return shutdownMonitor.exitVm;
    }

    static class Holder {
        static ShutdownMonitor instance = new ShutdownMonitor(null);

        Holder() {
        }
    }

    public class ShutdownMonitorThread
    extends Thread {
        public ShutdownMonitorThread() {
            this.setDaemon(true);
            this.setName("ShutdownMonitor");
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            if (ShutdownMonitor.access$1(ShutdownMonitor.this) != null) ** GOTO lbl53
            return;
lbl-1000:
            // 1 sources

            {
                block9: {
                    block8: {
                        socket = null;
                        socket = ShutdownMonitor.access$1(ShutdownMonitor.this).accept();
                        lin = new LineNumberReader(new InputStreamReader(socket.getInputStream()));
                        receivedKey = lin.readLine();
                        if (ShutdownMonitor.access$3(ShutdownMonitor.this).equals(receivedKey)) break block8;
                        System.err.println("Ignoring command with incorrect key");
                        ShutdownMonitor.access$2(ShutdownMonitor.this, socket);
                        socket = null;
                        continue;
                    }
                    try {
                        try {
                            out = socket.getOutputStream();
                            cmd = lin.readLine();
                            ShutdownMonitor.access$4(ShutdownMonitor.this, "command=%s", new Object[]{cmd});
                            if ("stop".equals(cmd)) {
                                ShutdownMonitor.access$4(ShutdownMonitor.this, "Issuing graceful shutdown..", new Object[0]);
                                ShutdownThread.getInstance().run();
                                ShutdownMonitor.access$5(ShutdownMonitor.this, ShutdownMonitor.access$1(ShutdownMonitor.this));
                                ShutdownMonitor.access$6(ShutdownMonitor.this, null);
                                ShutdownMonitor.access$7(ShutdownMonitor.this, socket);
                                ShutdownMonitor.access$4(ShutdownMonitor.this, "Informing client that we are stopped.", new Object[0]);
                                out.write("Stopped\r\n".getBytes(StandardCharsets.UTF_8));
                                out.flush();
                                socket.shutdownOutput();
                                ShutdownMonitor.access$2(ShutdownMonitor.this, socket);
                                socket = null;
                                ShutdownMonitor.access$4(ShutdownMonitor.this, "Shutting down monitor", new Object[0]);
                                if (ShutdownMonitor.access$8(ShutdownMonitor.this)) {
                                    ShutdownMonitor.access$4(ShutdownMonitor.this, "Killing JVM", new Object[0]);
                                    System.exit(0);
                                }
                                break block9;
                            }
                            if (!"status".equals(cmd)) break block9;
                            out.write("OK\r\n".getBytes(StandardCharsets.UTF_8));
                            out.flush();
                        }
                        catch (Exception e) {
                            ShutdownMonitor.access$9(ShutdownMonitor.this, e);
                            System.err.println(e.toString());
                            ShutdownMonitor.access$2(ShutdownMonitor.this, socket);
                            socket = null;
                        }
                    }
                    catch (Throwable var6_7) {
                        ShutdownMonitor.access$2(ShutdownMonitor.this, socket);
                        socket = null;
                        throw var6_7;
                    }
                }
                ShutdownMonitor.access$2(ShutdownMonitor.this, socket);
                var1_1 = null;
lbl53:
                // 4 sources

                ** while (ShutdownMonitor.access$1((ShutdownMonitor)ShutdownMonitor.this) != null)
            }
lbl54:
            // 1 sources

        }

        @Override
        public void start() {
            if (this.isAlive()) {
                if (ShutdownMonitor.this.DEBUG) {
                    System.err.printf("ShutdownMonitorThread already started", new Object[0]);
                }
                return;
            }
            this.startListenSocket();
            if (ShutdownMonitor.this.serverSocket == null) {
                return;
            }
            if (ShutdownMonitor.this.DEBUG) {
                System.err.println("Starting ShutdownMonitorThread");
            }
            super.start();
        }

        private void startListenSocket() {
            block9: {
                if (ShutdownMonitor.this.port < 0) {
                    if (ShutdownMonitor.this.DEBUG) {
                        System.err.println("ShutdownMonitor not in use (port < 0): " + ShutdownMonitor.this.port);
                    }
                    return;
                }
                try {
                    try {
                        ShutdownMonitor.this.serverSocket = new ServerSocket(ShutdownMonitor.this.port, 1, InetAddress.getByName("127.0.0.1"));
                        if (ShutdownMonitor.this.port == 0) {
                            ShutdownMonitor.this.port = ShutdownMonitor.this.serverSocket.getLocalPort();
                            System.out.printf("STOP.PORT=%d%n", ShutdownMonitor.this.port);
                        }
                        if (ShutdownMonitor.this.key == null) {
                            ShutdownMonitor.this.key = Long.toString((long)(9.223372036854776E18 * Math.random() + (double)this.hashCode() + (double)System.currentTimeMillis()), 36);
                            System.out.printf("STOP.KEY=%s%n", ShutdownMonitor.this.key);
                        }
                    }
                    catch (Exception e) {
                        ShutdownMonitor.this.debug(e);
                        System.err.println("Error binding monitor port " + ShutdownMonitor.this.port + ": " + e.toString());
                        ShutdownMonitor.this.serverSocket = null;
                        ShutdownMonitor.this.debug("STOP.PORT=%d", new Object[]{ShutdownMonitor.this.port});
                        ShutdownMonitor.this.debug("STOP.KEY=%s", new Object[]{ShutdownMonitor.this.key});
                        ShutdownMonitor.this.debug("%s", new Object[]{ShutdownMonitor.this.serverSocket});
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    ShutdownMonitor.this.debug("STOP.PORT=%d", new Object[]{ShutdownMonitor.this.port});
                    ShutdownMonitor.this.debug("STOP.KEY=%s", new Object[]{ShutdownMonitor.this.key});
                    ShutdownMonitor.this.debug("%s", new Object[]{ShutdownMonitor.this.serverSocket});
                    throw throwable;
                }
                ShutdownMonitor.this.debug("STOP.PORT=%d", new Object[]{ShutdownMonitor.this.port});
                ShutdownMonitor.this.debug("STOP.KEY=%s", new Object[]{ShutdownMonitor.this.key});
                ShutdownMonitor.this.debug("%s", new Object[]{ShutdownMonitor.this.serverSocket});
            }
        }
    }
}

