/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;

public class AllowSymLinkAliasChecker
implements ContextHandler.AliasCheck {
    private static final Logger LOG = Log.getLogger(AllowSymLinkAliasChecker.class);

    @Override
    public boolean check(String path, Resource resource) {
        File file;
        block10: {
            block9: {
                file = resource.getFile();
                if (file != null) break block9;
                return false;
            }
            if (!file.exists()) break block10;
            URI real = file.toPath().toRealPath(new LinkOption[0]).toUri();
            if (real.equals(resource.getAlias())) {
                LOG.debug("Allow symlink {} --> {}", resource, real);
                return true;
            }
        }
        try {
            Path p = file.toPath().toAbsolutePath();
            File d = p.getRoot().toFile();
            for (Path e : p) {
                d = new File(d, e.toString());
                while (d.exists() && Files.isSymbolicLink(d.toPath())) {
                    Path link = Files.readSymbolicLink(d.toPath());
                    if (!link.isAbsolute()) {
                        link = link.resolve(d.toPath());
                    }
                    d = link.toFile().getAbsoluteFile().getCanonicalFile();
                }
            }
            if (resource.getAlias().equals(d.toURI())) {
                LOG.debug("Allow symlink {} --> {}", resource, d);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.ignore(e);
        }
        return false;
    }
}

