/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.ArrayTernaryTrie;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.Trie;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Context Handler Collection")
public class ContextHandlerCollection
extends HandlerCollection {
    private static final Logger LOG = Log.getLogger(ContextHandlerCollection.class);
    private volatile Trie<ContextHandler[]> _contexts;
    private Class<? extends ContextHandler> _contextClass = ContextHandler.class;

    public ContextHandlerCollection() {
        super(true);
    }

    @ManagedOperation(value="update the mapping of context path to context")
    public void mapContexts() {
        ArrayTernaryTrie<ContextHandler[]> trie;
        int capacity = 512;
        block0: while (true) {
            trie = new ArrayTernaryTrie<ContextHandler[]>(false, capacity);
            Handler[] branches = this.getHandlers();
            int b = 0;
            while (branches != null && b < branches.length) {
                block14: {
                    Handler[] handlers;
                    block13: {
                        block12: {
                            handlers = null;
                            if (!(branches[b] instanceof ContextHandler)) break block12;
                            handlers = new Handler[]{branches[b]};
                            break block13;
                        }
                        if (!(branches[b] instanceof HandlerContainer)) break block14;
                        handlers = ((HandlerContainer)((Object)branches[b])).getChildHandlersByClass(ContextHandler.class);
                    }
                    int i = 0;
                    while (handlers != null && i < handlers.length) {
                        ContextHandler[] contexts;
                        ContextHandler handler = (ContextHandler)handlers[i];
                        String contextPath = handler.getContextPath().substring(1);
                        if (!trie.put(contextPath, ArrayUtil.addToArray(contexts = (ContextHandler[])trie.get(contextPath), handler, ContextHandler.class))) {
                            capacity += 512;
                            continue block0;
                        }
                        ++i;
                    }
                }
                ++b;
            }
            break;
        }
        for (String ctx : trie.keySet()) {
            ContextHandler handler;
            ContextHandler[] contexts = (ContextHandler[])trie.get(ctx);
            ContextHandler[] sorted = new ContextHandler[contexts.length];
            int i = 0;
            ContextHandler[] contextHandlerArray = contexts;
            int n = contexts.length;
            int n2 = 0;
            while (n2 < n) {
                handler = contextHandlerArray[n2];
                if (handler.getVirtualHosts() != null && handler.getVirtualHosts().length > 0) {
                    sorted[i++] = handler;
                }
                ++n2;
            }
            contextHandlerArray = contexts;
            n = contexts.length;
            n2 = 0;
            while (n2 < n) {
                handler = contextHandlerArray[n2];
                if (handler.getVirtualHosts() == null || handler.getVirtualHosts().length == 0) {
                    sorted[i++] = handler;
                }
                ++n2;
            }
            trie.put(ctx, sorted);
        }
        this._contexts = trie;
    }

    @Override
    public void setHandlers(Handler[] handlers) {
        super.setHandlers(handlers);
        if (this.isStarted()) {
            this.mapContexts();
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.mapContexts();
        super.doStart();
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ContextHandler context;
        Handler[] handlers = this.getHandlers();
        if (handlers == null || handlers.length == 0) {
            return;
        }
        HttpChannelState async = baseRequest.getHttpChannelState();
        if (async.isAsync() && (context = async.getContextHandler()) != null) {
            context.handle(target, baseRequest, request, response);
            return;
        }
        if (target.startsWith("/")) {
            int limit = target.length() - 1;
            while (limit >= 0) {
                ContextHandler[] contexts = this._contexts.getBest(target, 1, limit);
                if (contexts != null) {
                    int l = contexts[0].getContextPath().length();
                    if (l == 1 || target.length() == l || target.charAt(l) == '/') {
                        ContextHandler[] contextHandlerArray = contexts;
                        int n = contexts.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ContextHandler handler = contextHandlerArray[n2];
                            handler.handle(target, baseRequest, request, response);
                            if (baseRequest.isHandled()) {
                                return;
                            }
                            ++n2;
                        }
                    }
                    limit = l - 2;
                    continue;
                }
                break;
            }
        } else {
            int i = 0;
            while (i < handlers.length) {
                handlers[i].handle(target, baseRequest, request, response);
                if (baseRequest.isHandled()) {
                    return;
                }
                ++i;
            }
        }
    }

    public ContextHandler addContext(String contextPath, String resourceBase) {
        try {
            ContextHandler context = this._contextClass.newInstance();
            context.setContextPath(contextPath);
            context.setResourceBase(resourceBase);
            this.addHandler(context);
            return context;
        }
        catch (Exception e) {
            LOG.debug(e);
            throw new Error(e);
        }
    }

    public Class<?> getContextClass() {
        return this._contextClass;
    }

    public void setContextClass(Class<? extends ContextHandler> contextClass) {
        if (contextClass == null || !ContextHandler.class.isAssignableFrom(contextClass)) {
            throw new IllegalArgumentException();
        }
        this._contextClass = contextClass;
    }
}

