/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandlerContainer;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject(value="Handler of multiple handlers")
public class HandlerCollection
extends AbstractHandlerContainer {
    private final boolean _mutableWhenRunning;
    private volatile Handler[] _handlers;

    public HandlerCollection() {
        this._mutableWhenRunning = false;
    }

    public HandlerCollection(boolean mutableWhenRunning) {
        this._mutableWhenRunning = mutableWhenRunning;
    }

    @Override
    @ManagedAttribute(value="Wrapped handlers", readonly=true)
    public Handler[] getHandlers() {
        return this._handlers;
    }

    public void setHandlers(Handler[] handlers) {
        if (!this._mutableWhenRunning && this.isStarted()) {
            throw new IllegalStateException("STARTED");
        }
        if (handlers != null) {
            Handler[] handlerArray = handlers;
            int n = handlers.length;
            int n2 = 0;
            while (n2 < n) {
                Handler handler = handlerArray[n2];
                if (handler.getServer() != this.getServer()) {
                    handler.setServer(this.getServer());
                }
                ++n2;
            }
        }
        this.updateBeans(this._handlers, handlers);
        this._handlers = handlers;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this._handlers != null && this.isStarted()) {
            MultiException mex = null;
            int i = 0;
            while (i < this._handlers.length) {
                try {
                    this._handlers[i].handle(target, baseRequest, request, response);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (mex == null) {
                        mex = new MultiException();
                    }
                    mex.add(e);
                }
                ++i;
            }
            if (mex != null) {
                if (mex.size() == 1) {
                    throw new ServletException(mex.getThrowable(0));
                }
                throw new ServletException((Throwable)mex);
            }
        }
    }

    @Override
    public void setServer(Server server) {
        super.setServer(server);
        Handler[] handlers = this.getHandlers();
        if (handlers != null) {
            Handler[] handlerArray = handlers;
            int n = handlers.length;
            int n2 = 0;
            while (n2 < n) {
                Handler h = handlerArray[n2];
                h.setServer(server);
                ++n2;
            }
        }
    }

    public void addHandler(Handler handler) {
        this.setHandlers(ArrayUtil.addToArray(this.getHandlers(), handler, Handler.class));
    }

    public void removeHandler(Handler handler) {
        Handler[] handlers = this.getHandlers();
        if (handlers != null && handlers.length > 0) {
            this.setHandlers(ArrayUtil.removeFromArray(handlers, handler));
        }
    }

    @Override
    protected void expandChildren(List<Handler> list, Class<?> byClass) {
        if (this.getHandlers() != null) {
            Handler[] handlerArray = this.getHandlers();
            int n = handlerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Handler h = handlerArray[n2];
                this.expandHandler(h, list, byClass);
                ++n2;
            }
        }
    }

    @Override
    public void destroy() {
        if (!this.isStopped()) {
            throw new IllegalStateException("!STOPPED");
        }
        Handler[] children = this.getChildHandlers();
        this.setHandlers(null);
        Handler[] handlerArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Handler child = handlerArray[n2];
            child.destroy();
            ++n2;
        }
        super.destroy();
    }
}

