/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;

public class IdleTimeoutHandler
extends HandlerWrapper {
    private long _idleTimeoutMs = 1000L;
    private boolean _applyToAsync = false;

    public boolean isApplyToAsync() {
        return this._applyToAsync;
    }

    public void setApplyToAsync(boolean applyToAsync) {
        this._applyToAsync = applyToAsync;
    }

    public long getIdleTimeoutMs() {
        return this._idleTimeoutMs;
    }

    public void setIdleTimeoutMs(long idleTimeoutMs) {
        this._idleTimeoutMs = idleTimeoutMs;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        long idle_timeout;
        EndPoint endp;
        HttpConnection connection = HttpConnection.getCurrentConnection();
        EndPoint endPoint = endp = connection == null ? null : connection.getEndPoint();
        if (endp == null) {
            idle_timeout = -1L;
        } else {
            idle_timeout = endp.getIdleTimeout();
            endp.setIdleTimeout(this._idleTimeoutMs);
        }
        try {
            super.handle(target, baseRequest, request, response);
        }
        catch (Throwable throwable) {
            if (endp != null) {
                if (this._applyToAsync && request.isAsyncStarted()) {
                    request.getAsyncContext().addListener(new AsyncListener(endp, idle_timeout){
                        private final /* synthetic */ EndPoint val$endp;
                        private final /* synthetic */ long val$idle_timeout;
                        {
                            this.val$endp = endPoint;
                            this.val$idle_timeout = l;
                        }

                        public void onTimeout(AsyncEvent event) throws IOException {
                        }

                        public void onStartAsync(AsyncEvent event) throws IOException {
                        }

                        public void onError(AsyncEvent event) throws IOException {
                            this.val$endp.setIdleTimeout(this.val$idle_timeout);
                        }

                        public void onComplete(AsyncEvent event) throws IOException {
                            this.val$endp.setIdleTimeout(this.val$idle_timeout);
                        }
                    });
                } else {
                    endp.setIdleTimeout(idle_timeout);
                }
            }
            throw throwable;
        }
        if (endp != null) {
            if (this._applyToAsync && request.isAsyncStarted()) {
                request.getAsyncContext().addListener(new /* invalid duplicate definition of identical inner class */);
            } else {
                endp.setIdleTimeout(idle_timeout);
            }
        }
    }
}

