/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.IOException;
import java.util.EnumSet;
import java.util.EventListener;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.SessionTrackingMode;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ScopedHandler;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class SessionHandler
extends ScopedHandler {
    static final Logger LOG = Log.getLogger("org.eclipse.jetty.server.session");
    public static final EnumSet<SessionTrackingMode> DEFAULT_TRACKING = EnumSet.of(SessionTrackingMode.COOKIE, SessionTrackingMode.URL);
    public static final Class[] SESSION_LISTENER_TYPES = new Class[]{HttpSessionAttributeListener.class, HttpSessionIdListener.class, HttpSessionListener.class};
    private SessionManager _sessionManager;

    public SessionHandler() {
        this(new HashSessionManager());
    }

    public SessionHandler(SessionManager manager) {
        this.setSessionManager(manager);
    }

    public SessionManager getSessionManager() {
        return this._sessionManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        if (sessionManager != null) {
            sessionManager.setSessionHandler(this);
        }
        this.updateBean(this._sessionManager, sessionManager);
        this._sessionManager = sessionManager;
    }

    @Override
    protected void doStart() throws Exception {
        if (this._sessionManager == null) {
            this.setSessionManager(new HashSessionManager());
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
    }

    @Override
    public void doScope(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSession session;
        SessionManager old_session_manager = null;
        HttpSession old_session = null;
        HttpSession access = null;
        try {
            old_session_manager = baseRequest.getSessionManager();
            old_session = baseRequest.getSession(false);
            if (old_session_manager != this._sessionManager) {
                baseRequest.setSessionManager(this._sessionManager);
                baseRequest.setSession(null);
                this.checkRequestedSessionId(baseRequest, request);
            }
            HttpSession session2 = null;
            if (this._sessionManager != null) {
                session2 = baseRequest.getSession(false);
                if (session2 != null) {
                    if (session2 != old_session) {
                        access = session2;
                        HttpCookie cookie = this._sessionManager.access(session2, request.isSecure());
                        if (cookie != null) {
                            baseRequest.getResponse().addCookie(cookie);
                        }
                    }
                } else {
                    session2 = baseRequest.recoverNewSession(this._sessionManager);
                    if (session2 != null) {
                        baseRequest.setSession(session2);
                    }
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("sessionManager=" + this._sessionManager, new Object[0]);
                LOG.debug("session=" + session2, new Object[0]);
            }
            if (this._nextScope != null) {
                this._nextScope.doScope(target, baseRequest, request, response);
            } else if (this._outerScope != null) {
                this._outerScope.doHandle(target, baseRequest, request, response);
            } else {
                this.doHandle(target, baseRequest, request, response);
            }
        }
        catch (Throwable throwable) {
            HttpSession session3;
            if (access != null) {
                this._sessionManager.complete(access);
            }
            if ((session3 = baseRequest.getSession(false)) != null && old_session == null && session3 != access) {
                this._sessionManager.complete(session3);
            }
            if (old_session_manager != null && old_session_manager != this._sessionManager) {
                baseRequest.setSessionManager(old_session_manager);
                baseRequest.setSession(old_session);
            }
            throw throwable;
        }
        if (access != null) {
            this._sessionManager.complete(access);
        }
        if ((session = baseRequest.getSession(false)) != null && old_session == null && session != access) {
            this._sessionManager.complete(session);
        }
        if (old_session_manager != null && old_session_manager != this._sessionManager) {
            baseRequest.setSessionManager(old_session_manager);
            baseRequest.setSession(old_session);
        }
    }

    @Override
    public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.never()) {
            this.nextHandle(target, baseRequest, request, response);
        } else if (this._nextScope != null && this._nextScope == this._handler) {
            this._nextScope.doHandle(target, baseRequest, request, response);
        } else if (this._handler != null) {
            this._handler.handle(target, baseRequest, request, response);
        }
    }

    protected void checkRequestedSessionId(Request baseRequest, HttpServletRequest request) {
        Cookie[] cookies;
        String requested_session_id = request.getRequestedSessionId();
        SessionManager sessionManager = this.getSessionManager();
        if (requested_session_id != null && sessionManager != null) {
            HttpSession session = sessionManager.getHttpSession(requested_session_id);
            if (session != null && sessionManager.isValid(session)) {
                baseRequest.setSession(session);
            }
            return;
        }
        if (!DispatcherType.REQUEST.equals((Object)baseRequest.getDispatcherType())) {
            return;
        }
        boolean requested_session_id_from_cookie = false;
        HttpSession session = null;
        if (this._sessionManager.isUsingCookies() && (cookies = request.getCookies()) != null && cookies.length > 0) {
            String sessionCookie = sessionManager.getSessionCookieConfig().getName();
            int i = 0;
            while (i < cookies.length) {
                if (sessionCookie.equalsIgnoreCase(cookies[i].getName())) {
                    requested_session_id = cookies[i].getValue();
                    requested_session_id_from_cookie = true;
                    LOG.debug("Got Session ID {} from cookie", requested_session_id);
                    if (requested_session_id != null) {
                        session = sessionManager.getHttpSession(requested_session_id);
                        if (session != null && sessionManager.isValid(session)) {
                            break;
                        }
                    } else {
                        LOG.warn("null session id from cookie", new Object[0]);
                    }
                }
                ++i;
            }
        }
        if (requested_session_id == null || session == null) {
            int s;
            String uri = request.getRequestURI();
            String prefix = sessionManager.getSessionIdPathParameterNamePrefix();
            if (prefix != null && (s = uri.indexOf(prefix)) >= 0) {
                int i = s += prefix.length();
                while (i < uri.length()) {
                    char c = uri.charAt(i);
                    if (c == ';' || c == '#' || c == '?' || c == '/') break;
                    ++i;
                }
                requested_session_id = uri.substring(s, i);
                requested_session_id_from_cookie = false;
                session = sessionManager.getHttpSession(requested_session_id);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Got Session ID {} from URL", requested_session_id);
                }
            }
        }
        baseRequest.setRequestedSessionId(requested_session_id);
        baseRequest.setRequestedSessionIdFromCookie(requested_session_id != null && requested_session_id_from_cookie);
        if (session != null && sessionManager.isValid(session)) {
            baseRequest.setSession(session);
        }
    }

    public void addEventListener(EventListener listener) {
        if (this._sessionManager != null) {
            this._sessionManager.addEventListener(listener);
        }
    }

    public void removeEventListener(EventListener listener) {
        if (this._sessionManager != null) {
            this._sessionManager.removeEventListener(listener);
        }
    }

    public void clearEventListeners() {
        if (this._sessionManager != null) {
            this._sessionManager.clearEventListeners();
        }
    }
}

