/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.zip.Deflater;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.servlets.GzipFilter;
import org.eclipse.jetty.servlets.UserAgentFilter;
import org.eclipse.jetty.servlets.gzip.GzipFactory;
import org.eclipse.jetty.servlets.gzip.GzipHttpOutput;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class AsyncGzipFilter
extends UserAgentFilter
implements GzipFactory {
    private static final Logger LOG = Log.getLogger(GzipFilter.class);
    public static final String GZIP = "gzip";
    public static final String DEFLATE = "deflate";
    public static final String ETAG = "o.e.j.s.GzipFilter.ETag";
    public static final int DEFAULT_MIN_GZIP_SIZE = 256;
    protected ServletContext _context;
    protected final Set<String> _mimeTypes = new HashSet<String>();
    protected boolean _excludeMimeTypes;
    protected int _bufferSize = 8192;
    protected int _minGzipSize = 256;
    protected int _deflateCompressionLevel = -1;
    protected boolean _deflateNoWrap = true;
    protected boolean _checkGzExists = true;
    protected final ThreadLocal<Deflater> _deflater = new ThreadLocal();
    protected static final ThreadLocal<byte[]> _buffer = new ThreadLocal();
    protected final Set<String> _methods = new HashSet<String>();
    protected Set<String> _excludedAgents;
    protected Set<Pattern> _excludedAgentPatterns;
    protected Set<String> _excludedPaths;
    protected Set<Pattern> _excludedPathPatterns;
    protected HttpField _vary = new HttpGenerator.CachedHttpField(HttpHeader.VARY, (Object)((Object)HttpHeader.ACCEPT_ENCODING) + ", " + (Object)((Object)HttpHeader.USER_AGENT));

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        StringTokenizer tok;
        super.init(filterConfig);
        this._context = filterConfig.getServletContext();
        String tmp = filterConfig.getInitParameter("bufferSize");
        if (tmp != null) {
            this._bufferSize = Integer.parseInt(tmp);
        }
        LOG.debug("{} bufferSize={}", this, this._bufferSize);
        tmp = filterConfig.getInitParameter("minGzipSize");
        if (tmp != null) {
            this._minGzipSize = Integer.parseInt(tmp);
        }
        LOG.debug("{} minGzipSize={}", this, this._minGzipSize);
        tmp = filterConfig.getInitParameter("deflateCompressionLevel");
        if (tmp != null) {
            this._deflateCompressionLevel = Integer.parseInt(tmp);
        }
        LOG.debug("{} deflateCompressionLevel={}", this, this._deflateCompressionLevel);
        tmp = filterConfig.getInitParameter("deflateNoWrap");
        if (tmp != null) {
            this._deflateNoWrap = Boolean.parseBoolean(tmp);
        }
        LOG.debug("{} deflateNoWrap={}", this, this._deflateNoWrap);
        tmp = filterConfig.getInitParameter("checkGzExists");
        if (tmp != null) {
            this._checkGzExists = Boolean.parseBoolean(tmp);
        }
        LOG.debug("{} checkGzExists={}", this, this._checkGzExists);
        tmp = filterConfig.getInitParameter("methods");
        if (tmp != null) {
            tok = new StringTokenizer(tmp, ",", false);
            while (tok.hasMoreTokens()) {
                this._methods.add(tok.nextToken().trim().toUpperCase(Locale.ENGLISH));
            }
        } else {
            this._methods.add(HttpMethod.GET.asString());
        }
        LOG.debug("{} methods={}", this, this._methods);
        tmp = filterConfig.getInitParameter("mimeTypes");
        if (tmp == null) {
            this._excludeMimeTypes = true;
            tmp = filterConfig.getInitParameter("excludedMimeTypes");
            if (tmp == null) {
                for (String type : MimeTypes.getKnownMimeTypes()) {
                    if (type.startsWith("image/") || type.startsWith("audio/") || type.startsWith("video/")) {
                        this._mimeTypes.add(type);
                    }
                    this._mimeTypes.add("application/compress");
                    this._mimeTypes.add("application/zip");
                    this._mimeTypes.add("application/gzip");
                }
            } else {
                tok = new StringTokenizer(tmp, ",", false);
                while (tok.hasMoreTokens()) {
                    this._mimeTypes.add(tok.nextToken().trim());
                }
            }
        } else {
            tok = new StringTokenizer(tmp, ",", false);
            while (tok.hasMoreTokens()) {
                this._mimeTypes.add(tok.nextToken().trim());
            }
        }
        LOG.debug("{} mimeTypes={}", this, this._mimeTypes);
        LOG.debug("{} excludeMimeTypes={}", this, this._excludeMimeTypes);
        tmp = filterConfig.getInitParameter("excludedAgents");
        if (tmp != null) {
            this._excludedAgents = new HashSet<String>();
            tok = new StringTokenizer(tmp, ",", false);
            while (tok.hasMoreTokens()) {
                this._excludedAgents.add(tok.nextToken().trim());
            }
        }
        LOG.debug("{} excludedAgents={}", this, this._excludedAgents);
        tmp = filterConfig.getInitParameter("excludeAgentPatterns");
        if (tmp != null) {
            this._excludedAgentPatterns = new HashSet<Pattern>();
            tok = new StringTokenizer(tmp, ",", false);
            while (tok.hasMoreTokens()) {
                this._excludedAgentPatterns.add(Pattern.compile(tok.nextToken().trim()));
            }
        }
        LOG.debug("{} excludedAgentPatterns={}", this, this._excludedAgentPatterns);
        tmp = filterConfig.getInitParameter("excludePaths");
        if (tmp != null) {
            this._excludedPaths = new HashSet<String>();
            tok = new StringTokenizer(tmp, ",", false);
            while (tok.hasMoreTokens()) {
                this._excludedPaths.add(tok.nextToken().trim());
            }
        }
        LOG.debug("{} excludedPaths={}", this, this._excludedPaths);
        tmp = filterConfig.getInitParameter("excludePathPatterns");
        if (tmp != null) {
            this._excludedPathPatterns = new HashSet<Pattern>();
            tok = new StringTokenizer(tmp, ",", false);
            while (tok.hasMoreTokens()) {
                this._excludedPathPatterns.add(Pattern.compile(tok.nextToken().trim()));
            }
        }
        LOG.debug("{} excludedPathPatterns={}", this, this._excludedPathPatterns);
        tmp = filterConfig.getInitParameter("vary");
        if (tmp != null) {
            this._vary = new HttpGenerator.CachedHttpField(HttpHeader.VARY, tmp);
        }
        LOG.debug("{} vary={}", this, this._vary);
    }

    @Override
    public void destroy() {
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpChannel<?> channel;
        HttpOutput out;
        int dd;
        File gz;
        String path;
        String mimeType;
        LOG.debug("{} doFilter {}", this, req);
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String requestURI = request.getRequestURI();
        if (!this._methods.contains(request.getMethod())) {
            LOG.debug("{} excluded by method {}", this, request);
            super.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            return;
        }
        if (this.isExcludedPath(requestURI)) {
            LOG.debug("{} excluded by path {}", this, request);
            super.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            return;
        }
        if (this._mimeTypes.size() > 0 && (mimeType = this._context.getMimeType(request.getRequestURI())) != null && this._mimeTypes.contains(mimeType) == this._excludeMimeTypes) {
            LOG.debug("{} excluded by path suffix {}", this, request);
            super.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            return;
        }
        if (this._checkGzExists && request.getServletContext() != null && (path = request.getServletContext().getRealPath(URIUtil.addPaths(request.getServletPath(), request.getPathInfo()))) != null && (gz = new File(String.valueOf(path) + ".gz")).exists()) {
            LOG.debug("{} gzip exists {}", this, request);
            super.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            return;
        }
        String etag = request.getHeader("If-None-Match");
        if (etag != null && (dd = etag.indexOf("--")) > 0) {
            request.setAttribute(ETAG, (Object)(String.valueOf(etag.substring(0, dd)) + (etag.endsWith("\"") ? "\"" : "")));
        }
        if (!((out = (channel = HttpChannel.getCurrentHttpChannel()).getResponse().getHttpOutput()) instanceof GzipHttpOutput)) {
            if (out.getClass() != HttpOutput.class) {
                throw new IllegalStateException();
            }
            out = new GzipHttpOutput(channel);
            channel.getResponse().setHttpOutput(out);
        }
        GzipHttpOutput cout = (GzipHttpOutput)out;
        try {
            cout.mightCompress(this);
            super.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        }
        catch (Throwable e) {
            LOG.debug("{} excepted {}", this, request, e);
            if (!response.isCommitted()) {
                cout.resetBuffer();
                cout.noCompressionIfPossible();
            }
            throw e;
        }
    }

    private boolean isExcludedAgent(String ua) {
        if (ua == null) {
            return false;
        }
        if (this._excludedAgents != null && this._excludedAgents.contains(ua)) {
            return true;
        }
        if (this._excludedAgentPatterns != null) {
            for (Pattern pattern : this._excludedAgentPatterns) {
                if (!pattern.matcher(ua).matches()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isExcludedPath(String requestURI) {
        if (requestURI == null) {
            return false;
        }
        if (this._excludedPaths != null) {
            for (String excludedPath : this._excludedPaths) {
                if (!requestURI.startsWith(excludedPath)) continue;
                return true;
            }
        }
        if (this._excludedPathPatterns != null) {
            for (Pattern pattern : this._excludedPathPatterns) {
                if (!pattern.matcher(requestURI).matches()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public HttpField getVaryField() {
        return this._vary;
    }

    @Override
    public Deflater getDeflater(Request request, long content_length) {
        String ua = this.getUserAgent((ServletRequest)request);
        if (ua != null && this.isExcludedAgent(ua)) {
            LOG.debug("{} excluded user agent {}", this, request);
            return null;
        }
        if (content_length >= 0L && content_length < (long)this._minGzipSize) {
            LOG.debug("{} excluded minGzipSize {}", this, request);
            return null;
        }
        String accept = request.getHttpFields().get(HttpHeader.ACCEPT_ENCODING);
        if (accept == null) {
            LOG.debug("{} excluded !accept {}", this, request);
            return null;
        }
        boolean gzip = false;
        if (GZIP.equals(accept) || accept.startsWith("gzip,")) {
            gzip = true;
        } else {
            List<String> list = HttpFields.qualityList(request.getHttpFields().getValues(HttpHeader.ACCEPT_ENCODING.asString(), ","));
            for (String a : list) {
                if (!GZIP.equalsIgnoreCase(HttpFields.valueParameters(a, null))) continue;
                gzip = true;
                break;
            }
        }
        if (!gzip) {
            LOG.debug("{} excluded not gzip accept {}", this, request);
            return null;
        }
        Deflater df = this._deflater.get();
        if (df == null) {
            df = new Deflater(this._deflateCompressionLevel, this._deflateNoWrap);
        } else {
            this._deflater.set(null);
        }
        return df;
    }

    @Override
    public void recycle(Deflater deflater) {
        deflater.reset();
        if (this._deflater.get() == null) {
            this._deflater.set(deflater);
        }
    }

    @Override
    public boolean isExcludedMimeType(String mimetype) {
        return this._mimeTypes.contains(mimetype) == this._excludeMimeTypes;
    }

    @Override
    public int getBufferSize() {
        return this._bufferSize;
    }
}

