/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets.gzip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import org.eclipse.jetty.servlets.gzip.DeflatedOutputStream;

public class GzipOutputStream
extends DeflatedOutputStream {
    private static final byte[] GZIP_HEADER;
    private final CRC32 _crc = new CRC32();

    static {
        byte[] byArray = new byte[10];
        byArray[0] = 31;
        byArray[1] = -117;
        byArray[2] = 8;
        GZIP_HEADER = byArray;
    }

    public GzipOutputStream(OutputStream out, Deflater deflater, byte[] buffer) throws IOException {
        super(out, deflater, buffer);
        out.write(GZIP_HEADER);
    }

    @Override
    public synchronized void write(byte[] buf, int off, int len) throws IOException {
        super.write(buf, off, len);
        this._crc.update(buf, off, len);
    }

    @Override
    public synchronized void finish() throws IOException {
        if (!this._def.finished()) {
            super.finish();
            byte[] trailer = new byte[8];
            this.writeInt((int)this._crc.getValue(), trailer, 0);
            this.writeInt(this._def.getTotalIn(), trailer, 4);
            this.out.write(trailer);
        }
    }

    private void writeInt(int i, byte[] buf, int offset) {
        int o = offset;
        buf[o++] = (byte)(i & 0xFF);
        buf[o++] = (byte)(i >>> 8 & 0xFF);
        buf[o++] = (byte)(i >>> 16 & 0xFF);
        buf[o++] = (byte)(i >>> 24 & 0xFF);
    }
}

