/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.start.FS;
import org.eclipse.jetty.start.NaturalSort;
import org.eclipse.jetty.start.StartArgs;
import org.eclipse.jetty.start.StartLog;

public class BaseHome {
    private File homeDir;
    private File baseDir;

    public BaseHome() {
        try {
            Matcher m;
            this.baseDir = new File(System.getProperty("jetty.base", System.getProperty("user.dir", ".")));
            URL jarfile = this.getClass().getClassLoader().getResource("org/eclipse/jetty/start/BaseHome.class");
            if (jarfile != null && (m = Pattern.compile("jar:(file:.*)!/org/eclipse/jetty/start/BaseHome.class").matcher(jarfile.toString())).matches()) {
                this.homeDir = new File(new URI(m.group(1))).getParentFile();
            }
            this.homeDir = new File(System.getProperty("jetty.home", (this.homeDir == null ? this.baseDir : this.homeDir).getAbsolutePath()));
            this.baseDir = this.baseDir.getAbsoluteFile().getCanonicalFile();
            this.homeDir = this.homeDir.getAbsoluteFile().getCanonicalFile();
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public BaseHome(File homeDir, File baseDir) {
        try {
            this.homeDir = homeDir.getCanonicalFile();
            this.baseDir = baseDir == null ? this.homeDir : baseDir.getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getBase() {
        if (this.baseDir == null) {
            return null;
        }
        return this.baseDir.getAbsolutePath();
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public File getBaseFile(String path) {
        return new File(this.baseDir, FS.separators(path));
    }

    public File getFile(String path) {
        File file;
        String rpath = FS.separators(path);
        if (this.isBaseDifferent() && (file = new File(this.baseDir, rpath)).exists()) {
            return file;
        }
        file = new File(this.homeDir, rpath);
        if (file.exists()) {
            return file;
        }
        return new File(rpath);
    }

    public String getHome() {
        return this.homeDir.getAbsolutePath();
    }

    public File getHomeDir() {
        return this.homeDir;
    }

    public void initialize(StartArgs args) {
        Pattern jetty_home = Pattern.compile("(-D)?jetty.home=(.*)");
        Pattern jetty_base = Pattern.compile("(-D)?jetty.base=(.*)");
        File homePath = null;
        File basePath = null;
        for (String arg : args.getCommandLine()) {
            Matcher base_match;
            Matcher home_match = jetty_home.matcher(arg);
            if (home_match.matches()) {
                homePath = new File(home_match.group(2));
            }
            if (!(base_match = jetty_base.matcher(arg)).matches()) continue;
            basePath = new File(base_match.group(2));
        }
        if (homePath != null) {
            this.homeDir = homePath.getAbsoluteFile();
            if (basePath == null) {
                this.baseDir = homePath.getAbsoluteFile();
                args.getProperties().setProperty("jetty.base", this.baseDir.toString(), "<internal-fallback>");
            } else {
                this.baseDir = basePath.getAbsoluteFile();
            }
        } else if (basePath != null) {
            this.baseDir = basePath.getAbsoluteFile();
        }
        args.addSystemProperty("jetty.home", this.homeDir.getAbsolutePath());
        args.addSystemProperty("jetty.base", this.baseDir.getAbsolutePath());
    }

    public boolean isBaseDifferent() {
        return this.homeDir.compareTo(this.baseDir) != 0;
    }

    public List<File> listFiles(String relPathToDirectory) {
        return this.listFiles(relPathToDirectory, FS.AllFilter.INSTANCE);
    }

    public List<File> listFiles(String relPathToDirectory, FileFilter filter) {
        Objects.requireNonNull(filter, "FileFilter cannot be null");
        File homePath = new File(this.homeDir, FS.separators(relPathToDirectory));
        ArrayList<File> homeFiles = new ArrayList<File>();
        if (FS.canReadDirectory(homePath)) {
            homeFiles.addAll(Arrays.asList(homePath.listFiles(filter)));
        }
        if (this.isBaseDifferent()) {
            File[] baseFiles;
            File basePath = new File(this.baseDir, FS.separators(relPathToDirectory));
            ArrayList<File> ret = new ArrayList<File>();
            if (FS.canReadDirectory(basePath) && (baseFiles = basePath.listFiles(filter)) != null) {
                File[] fileArray = baseFiles;
                int n = baseFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File base = fileArray[n2];
                    String relpath = this.toRelativePath(this.baseDir, base);
                    File home = new File(this.homeDir, FS.separators(relpath));
                    if (home.exists()) {
                        homeFiles.remove(home);
                    }
                    ret.add(base);
                    ++n2;
                }
            }
            ret.addAll(homeFiles);
            Collections.sort(ret, new NaturalSort.Files());
            return ret;
        }
        Collections.sort(homeFiles, new NaturalSort.Files());
        return homeFiles;
    }

    public List<File> listFilesRegex(String regex) {
        Objects.requireNonNull(regex, "Glob cannot be null");
        Pattern pattern = Pattern.compile(regex);
        ArrayList<File> homeFiles = new ArrayList<File>();
        if (FS.canReadDirectory(this.homeDir)) {
            StartLog.debug("Finding files in ${jetty.home} that match: %s", regex);
            this.recurseDir(homeFiles, this.homeDir, new FS.RelativeRegexFilter(this.homeDir, pattern));
            StartLog.debug("Found %,d files", homeFiles.size());
        }
        if (this.isBaseDifferent()) {
            ArrayList<File> ret = new ArrayList<File>();
            if (FS.canReadDirectory(this.baseDir)) {
                ArrayList<File> baseFiles = new ArrayList<File>();
                StartLog.debug("Finding files in ${jetty.base} that match: %s", regex);
                this.recurseDir(baseFiles, this.baseDir, new FS.RelativeRegexFilter(this.baseDir, pattern));
                StartLog.debug("Found %,d files", baseFiles.size());
                for (File base : baseFiles) {
                    String relpath = this.toRelativePath(this.baseDir, base);
                    File home = new File(this.homeDir, FS.separators(relpath));
                    if (home.exists()) {
                        homeFiles.remove(home);
                    }
                    ret.add(base);
                }
            }
            ret.addAll(homeFiles);
            StartLog.debug("Merged Files: %,d files%n", ret.size());
            Collections.sort(ret, new NaturalSort.Files());
            return ret;
        }
        Collections.sort(homeFiles, new NaturalSort.Files());
        return homeFiles;
    }

    private void recurseDir(List<File> files, File dir, FS.RelativeRegexFilter filter) {
        files.addAll(Arrays.asList(dir.listFiles(filter)));
        File[] fileArray = dir.listFiles(FS.DirFilter.INSTANCE);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File subdir = fileArray[n2];
            this.recurseDir(files, subdir, filter);
            ++n2;
        }
    }

    public List<File> rawListFiles(String relPathToDirectory, FileFilter filter) {
        Objects.requireNonNull(filter, "FileFilter cannot be null");
        ArrayList<File> ret = new ArrayList<File>();
        File homePath = new File(this.homeDir, FS.separators(relPathToDirectory));
        ret.addAll(Arrays.asList(homePath.listFiles(filter)));
        if (this.isBaseDifferent()) {
            File basePath = new File(this.baseDir, FS.separators(relPathToDirectory));
            ret.addAll(Arrays.asList(basePath.listFiles(filter)));
        }
        Collections.sort(ret, new NaturalSort.Files());
        return ret;
    }

    public void setBaseDir(File dir) {
        try {
            this.baseDir = dir.getCanonicalFile();
            System.setProperty("jetty.base", dir.getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    public void setHomeDir(File dir) {
        try {
            this.homeDir = dir.getCanonicalFile();
            System.setProperty("jetty.home", dir.getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    private String toRelativePath(File dir, File path) {
        return FS.toRelativePath(dir, path);
    }

    public String toShortForm(File path) {
        try {
            return this.toShortForm(path.getCanonicalPath());
        }
        catch (IOException iOException) {
            return this.toShortForm(path.getAbsolutePath());
        }
    }

    public String toShortForm(String path) {
        String value;
        if (path == null) {
            return path;
        }
        if (this.isBaseDifferent() && path.startsWith(value = this.baseDir.getAbsolutePath())) {
            return "${jetty.base}" + path.substring(value.length());
        }
        value = this.homeDir.getAbsolutePath();
        if (path.startsWith(value)) {
            return "${jetty.home}" + path.substring(value.length());
        }
        return path;
    }
}

