/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class CommandLineBuilder {
    private List<String> args = new ArrayList<String>();

    public static File findExecutable(File root, String path) {
        String npath = path.replace('/', File.separatorChar);
        File exe = new File(root, npath);
        if (!exe.exists()) {
            return null;
        }
        return exe;
    }

    public static String findJavaBin() {
        File javaHome = new File(System.getProperty("java.home"));
        if (!javaHome.exists()) {
            return null;
        }
        File javabin = CommandLineBuilder.findExecutable(javaHome, "bin/java");
        if (javabin != null) {
            return javabin.getAbsolutePath();
        }
        javabin = CommandLineBuilder.findExecutable(javaHome, "bin/java.exe");
        if (javabin != null) {
            return javabin.getAbsolutePath();
        }
        return "java";
    }

    public static String quote(String arg) {
        boolean needsQuoting;
        boolean bl = needsQuoting = arg.indexOf(32) >= 0 || arg.indexOf(34) >= 0;
        if (!needsQuoting) {
            return arg;
        }
        StringBuilder buf = new StringBuilder();
        boolean escaped = false;
        boolean quoted = false;
        char[] cArray = arg.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!(quoted || escaped || c != '\"' && c != ' ')) {
                buf.append("\\");
            }
            if (!escaped && c == '\'') {
                quoted = !quoted;
            }
            escaped = c == '\\';
            buf.append(c);
            ++n2;
        }
        return buf.toString();
    }

    public CommandLineBuilder() {
    }

    public CommandLineBuilder(String bin) {
        this();
        this.args.add(bin);
    }

    public void addArg(String arg) {
        if (arg != null) {
            this.args.add(CommandLineBuilder.quote(arg));
        }
    }

    public void addEqualsArg(String name, String value) {
        if (value != null && value.length() > 0) {
            this.args.add(CommandLineBuilder.quote(String.valueOf(name) + "=" + value));
        } else {
            this.args.add(CommandLineBuilder.quote(name));
        }
    }

    public void addRawArg(String arg) {
        if (arg != null) {
            this.args.add(arg);
        }
    }

    public List<String> getArgs() {
        return this.args;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        boolean delim = false;
        for (String arg : this.args) {
            if (delim) {
                buf.append(' ');
            }
            buf.append(CommandLineBuilder.quote(arg));
            delim = true;
        }
        return buf.toString();
    }
}

