/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.StartArgs;
import org.eclipse.jetty.start.UsageException;

public class StartLog {
    private static final StartLog INSTANCE = new StartLog();
    private boolean debug = false;

    public static void debug(String format, Object ... args) {
        if (StartLog.INSTANCE.debug) {
            System.out.printf(String.valueOf(format) + "%n", args);
        }
    }

    public static void debug(Throwable t) {
        if (StartLog.INSTANCE.debug) {
            t.printStackTrace(System.out);
        }
    }

    public static StartLog getInstance() {
        return INSTANCE;
    }

    public static void info(String format, Object ... args) {
        System.err.printf("INFO: " + format + "%n", args);
    }

    public static void warn(String format, Object ... args) {
        System.err.printf("WARNING: " + format + "%n", args);
    }

    public static void warn(Throwable t) {
        t.printStackTrace(System.err);
    }

    public static boolean isDebugEnabled() {
        return StartLog.INSTANCE.debug;
    }

    public void initialize(BaseHome baseHome, StartArgs args) throws IOException {
        Pattern debugBoolPat = Pattern.compile("(-D)?debug=(.*)");
        Pattern logFilePat = Pattern.compile("(-D)?start-log-file=(.*)");
        for (String arg : args.getCommandLine()) {
            if ("--debug".equals(arg)) {
                this.debug = true;
                continue;
            }
            Matcher matcher = debugBoolPat.matcher(arg);
            if (matcher.matches()) {
                this.debug = Boolean.parseBoolean(matcher.group(2));
                continue;
            }
            matcher = logFilePat.matcher(arg);
            if (!matcher.matches()) continue;
            String filename = matcher.group(2);
            File logfile = baseHome.getBaseFile(filename);
            this.initLogFile(logfile);
        }
    }

    public void initLogFile(File logfile) throws IOException {
        if (logfile != null) {
            File logDir = logfile.getParentFile();
            if (!logDir.exists() || !logDir.canWrite()) {
                String err = String.format("Cannot write %s to directory %s [directory doesn't exist or is read-only]", logfile.getName(), logDir.getAbsolutePath());
                throw new UsageException(-1, (Throwable)new IOException(err));
            }
            File startLog = logfile;
            if (!startLog.exists() && !startLog.createNewFile()) {
                throw new UsageException(-1, (Throwable)new IOException("Unable to create: " + startLog.getAbsolutePath()));
            }
            if (!startLog.canWrite()) {
                throw new UsageException(-1, (Throwable)new IOException("Unable to write to: " + startLog.getAbsolutePath()));
            }
            System.out.println("Logging to " + logfile);
            PrintStream logger = new PrintStream(new FileOutputStream(startLog, false));
            System.setOut(logger);
            System.setErr(logger);
            System.out.println("Establishing " + logfile + " on " + new Date());
        }
    }

    public static void enableDebug() {
        StartLog.getInstance().debug = true;
    }
}

