/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.util.AbstractTrie;
import org.eclipse.jetty.util.StringUtil;

public class ArrayTernaryTrie<V>
extends AbstractTrie<V> {
    private static int LO = 1;
    private static int EQ = 2;
    private static int HI = 3;
    private static final int ROW_SIZE = 4;
    private final char[] _tree;
    private final String[] _key;
    private final Object[] _value;
    private char _rows;

    public ArrayTernaryTrie() {
        this(128);
    }

    public ArrayTernaryTrie(boolean insensitive) {
        this(insensitive, 128);
    }

    public ArrayTernaryTrie(int capacityInNodes) {
        this(true, capacityInNodes);
    }

    public ArrayTernaryTrie(boolean insensitive, int capacityInNodes) {
        super(insensitive);
        this._value = new Object[capacityInNodes];
        this._tree = new char[capacityInNodes * 4];
        this._key = new String[capacityInNodes];
    }

    public ArrayTernaryTrie(ArrayTernaryTrie<V> trie, double factor) {
        this(trie.isCaseInsensitive(), (int)((double)trie._value.length * factor));
        this._rows = trie._rows;
        System.arraycopy(trie._value, 0, this._value, 0, trie._value.length);
        System.arraycopy(trie._tree, 0, this._tree, 0, trie._tree.length);
        System.arraycopy(trie._key, 0, this._key, 0, trie._key.length);
    }

    @Override
    public boolean put(String s, V v) {
        char t = '\u0000';
        int limit = s.length();
        int last = 0;
        int k = 0;
        while (k < limit) {
            int diff;
            char c = s.charAt(k);
            if (this.isCaseInsensitive() && c < '\u0080') {
                c = StringUtil.lowercases[c];
            }
            do {
                char n;
                int row = 4 * t;
                if (t == this._rows) {
                    this._rows = (char)(this._rows + '\u0001');
                    if (this._rows >= this._key.length) {
                        this._rows = (char)(this._rows - '\u0001');
                        return false;
                    }
                    this._tree[row] = c;
                }
                if ((diff = (n = this._tree[row]) - c) == 0) {
                    last = row + EQ;
                    t = this._tree[last];
                } else if (diff < 0) {
                    last = row + LO;
                    t = this._tree[last];
                } else {
                    last = row + HI;
                    t = this._tree[last];
                }
                if (t != '\u0000') continue;
                t = this._rows;
                this._tree[last] = t;
            } while (diff != 0);
            ++k;
        }
        if (t == this._rows) {
            this._rows = (char)(this._rows + '\u0001');
            if (this._rows >= this._key.length) {
                this._rows = (char)(this._rows - '\u0001');
                return false;
            }
        }
        this._key[t] = v == null ? null : s;
        this._value[t] = v;
        return true;
    }

    @Override
    public V get(String s, int offset, int len) {
        int t = 0;
        int i = 0;
        block0: while (i < len) {
            int diff;
            int row;
            char c = s.charAt(offset + i++);
            if (this.isCaseInsensitive() && c < '\u0080') {
                c = StringUtil.lowercases[c];
            }
            do {
                char n;
                if ((diff = (n = this._tree[row = 4 * t]) - c) != 0) continue;
                t = this._tree[row + EQ];
                if (t != 0) continue block0;
                return null;
            } while ((t = this._tree[row + ArrayTernaryTrie.hilo(diff)]) != 0);
            return null;
        }
        return (V)this._value[t];
    }

    @Override
    public V get(ByteBuffer b, int offset, int len) {
        int t = 0;
        offset += b.position();
        int i = 0;
        block0: while (i < len) {
            int diff;
            int row;
            byte c = (byte)(b.get(offset + i++) & 0x7F);
            if (this.isCaseInsensitive()) {
                c = (byte)StringUtil.lowercases[c];
            }
            do {
                char n;
                if ((diff = (n = this._tree[row = 4 * t]) - c) != 0) continue;
                t = this._tree[row + EQ];
                if (t != 0) continue block0;
                return null;
            } while ((t = this._tree[row + ArrayTernaryTrie.hilo(diff)]) != 0);
            return null;
        }
        return (V)this._value[t];
    }

    @Override
    public V getBest(String s) {
        return this.getBest(0, s, 0, s.length());
    }

    @Override
    public V getBest(String s, int offset, int length) {
        return this.getBest(0, s, offset, length);
    }

    private V getBest(int t, String s, int offset, int len) {
        int node = t;
        int i = 0;
        block0: while (i < len) {
            block4: {
                int diff;
                int row;
                char c = s.charAt(offset + i);
                if (this.isCaseInsensitive() && c < '\u0080') {
                    c = StringUtil.lowercases[c];
                }
                do {
                    char n;
                    if ((diff = (n = this._tree[row = 4 * t]) - c) != 0) continue;
                    t = this._tree[row + EQ];
                    if (t == 0) break block0;
                    if (this._key[t] == null) break block4;
                    node = t;
                    V best = this.getBest(t, s, offset + i + 1, len - i - 1);
                    if (best != null) {
                        return best;
                    }
                    break block4;
                } while ((t = this._tree[row + ArrayTernaryTrie.hilo(diff)]) != 0);
                break;
            }
            ++i;
        }
        return (V)this._value[node];
    }

    @Override
    public V getBest(ByteBuffer b, int offset, int len) {
        if (b.hasArray()) {
            return this.getBest(0, b.array(), b.arrayOffset() + b.position() + offset, len);
        }
        return this.getBest(0, b, offset, len);
    }

    private V getBest(int t, byte[] b, int offset, int len) {
        int node = t;
        int i = 0;
        block0: while (i < len) {
            block4: {
                int diff;
                int row;
                byte c = (byte)(b[offset + i] & 0x7F);
                if (this.isCaseInsensitive()) {
                    c = (byte)StringUtil.lowercases[c];
                }
                do {
                    char n;
                    if ((diff = (n = this._tree[row = 4 * t]) - c) != 0) continue;
                    t = this._tree[row + EQ];
                    if (t == 0) break block0;
                    if (this._key[t] == null) break block4;
                    node = t;
                    V best = this.getBest(t, b, offset + i + 1, len - i - 1);
                    if (best != null) {
                        return best;
                    }
                    break block4;
                } while ((t = this._tree[row + ArrayTernaryTrie.hilo(diff)]) != 0);
                break;
            }
            ++i;
        }
        return (V)this._value[node];
    }

    private V getBest(int t, ByteBuffer b, int offset, int len) {
        int node = t;
        int o = offset + b.position();
        int i = 0;
        block0: while (i < len) {
            block4: {
                int diff;
                int row;
                byte c = (byte)(b.get(o + i) & 0x7F);
                if (this.isCaseInsensitive()) {
                    c = (byte)StringUtil.lowercases[c];
                }
                do {
                    char n;
                    if ((diff = (n = this._tree[row = 4 * t]) - c) != 0) continue;
                    t = this._tree[row + EQ];
                    if (t == 0) break block0;
                    if (this._key[t] == null) break block4;
                    node = t;
                    V best = this.getBest(t, b, offset + i + 1, len - i - 1);
                    if (best != null) {
                        return best;
                    }
                    break block4;
                } while ((t = this._tree[row + ArrayTernaryTrie.hilo(diff)]) != 0);
                break;
            }
            ++i;
        }
        return (V)this._value[node];
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        int r = 0;
        while (r <= this._rows) {
            if (this._key[r] != null && this._value[r] != null) {
                buf.append(',');
                buf.append(this._key[r]);
                buf.append('=');
                buf.append(this._value[r].toString());
            }
            ++r;
        }
        if (buf.length() == 0) {
            return "{}";
        }
        buf.setCharAt(0, '{');
        buf.append('}');
        return buf.toString();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        int r = 0;
        while (r <= this._rows) {
            if (this._key[r] != null && this._value[r] != null) {
                keys.add(this._key[r]);
            }
            ++r;
        }
        return keys;
    }

    @Override
    public boolean isFull() {
        return this._rows + '\u0001' == this._key.length;
    }

    public static int hilo(int diff) {
        return 1 + (diff | Integer.MAX_VALUE) / 0x3FFFFFFF;
    }

    public void dump() {
        int r = 0;
        while (r < this._rows) {
            char c = this._tree[r * 4 + 0];
            System.err.printf("%4d [%s,%d,%d,%d] '%s':%s%n", r, c < ' ' || c > '\u007f' ? "" + c : "'" + c + "'", (int)this._tree[r * 4 + LO], (int)this._tree[r * 4 + EQ], (int)this._tree[r * 4 + HI], this._key[r], this._value[r]);
            ++r;
        }
    }
}

