/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.util.resource.Resource;

public class BufferUtil {
    static final int TEMP_BUFFER_SIZE = 4096;
    static final byte SPACE = 32;
    static final byte MINUS = 45;
    static final byte[] DIGIT = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    public static final ByteBuffer EMPTY_BUFFER = ByteBuffer.wrap(new byte[0]);
    private static final int[] decDivisors = new int[]{1000000000, 100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};
    private static final int[] hexDivisors = new int[]{0x10000000, 0x1000000, 0x100000, 65536, 4096, 256, 16, 1};
    private static final long[] decDivisorsL = new long[]{1000000000000000000L, 100000000000000000L, 10000000000000000L, 1000000000000000L, 100000000000000L, 10000000000000L, 1000000000000L, 100000000000L, 10000000000L, 1000000000L, 100000000L, 10000000L, 1000000L, 100000L, 10000L, 1000L, 100L, 10L, 1L};

    public static ByteBuffer allocate(int capacity) {
        ByteBuffer buf = ByteBuffer.allocate(capacity);
        buf.limit(0);
        return buf;
    }

    public static ByteBuffer allocateDirect(int capacity) {
        ByteBuffer buf = ByteBuffer.allocateDirect(capacity);
        buf.limit(0);
        return buf;
    }

    public static void clear(ByteBuffer buffer) {
        if (buffer != null) {
            buffer.position(0);
            buffer.limit(0);
        }
    }

    public static void clearToFill(ByteBuffer buffer) {
        if (buffer != null) {
            buffer.position(0);
            buffer.limit(buffer.capacity());
        }
    }

    public static int flipToFill(ByteBuffer buffer) {
        int limit;
        int position = buffer.position();
        if (position == (limit = buffer.limit())) {
            buffer.position(0);
            buffer.limit(buffer.capacity());
            return 0;
        }
        int capacity = buffer.capacity();
        if (limit == capacity) {
            buffer.compact();
            return 0;
        }
        buffer.position(limit);
        buffer.limit(capacity);
        return position;
    }

    public static void flipToFlush(ByteBuffer buffer, int position) {
        buffer.limit(buffer.position());
        buffer.position(position);
    }

    public static byte[] toArray(ByteBuffer buffer) {
        byte[] to = new byte[buffer.remaining()];
        if (buffer.hasArray()) {
            byte[] array = buffer.array();
            System.arraycopy(array, buffer.arrayOffset() + buffer.position(), to, 0, to.length);
        } else {
            buffer.slice().get(to);
        }
        return to;
    }

    public static boolean isEmpty(ByteBuffer buf) {
        return buf == null || buf.remaining() == 0;
    }

    public static boolean hasContent(ByteBuffer buf) {
        return buf != null && buf.remaining() > 0;
    }

    public static boolean isFull(ByteBuffer buf) {
        return buf != null && buf.limit() == buf.capacity();
    }

    public static int length(ByteBuffer buffer) {
        return buffer == null ? 0 : buffer.remaining();
    }

    public static int space(ByteBuffer buffer) {
        if (buffer == null) {
            return 0;
        }
        return buffer.capacity() - buffer.limit();
    }

    public static boolean compact(ByteBuffer buffer) {
        if (buffer.position() == 0) {
            return false;
        }
        boolean full = buffer.limit() == buffer.capacity();
        buffer.compact().flip();
        return full && buffer.limit() < buffer.capacity();
    }

    public static int put(ByteBuffer from, ByteBuffer to) {
        int put;
        int remaining = from.remaining();
        if (remaining > 0) {
            if (remaining <= to.remaining()) {
                to.put(from);
                put = remaining;
                from.position(0);
                from.limit(0);
            } else if (from.hasArray()) {
                put = to.remaining();
                to.put(from.array(), from.arrayOffset() + from.position(), put);
                from.position(from.position() + put);
            } else {
                put = to.remaining();
                ByteBuffer slice = from.slice();
                slice.limit(put);
                to.put(slice);
                from.position(from.position() + put);
            }
        } else {
            put = 0;
        }
        return put;
    }

    public static int flipPutFlip(ByteBuffer from, ByteBuffer to) {
        return BufferUtil.append(to, from);
    }

    public static void append(ByteBuffer to, byte[] b, int off, int len) throws BufferOverflowException {
        int pos = BufferUtil.flipToFill(to);
        try {
            to.put(b, off, len);
        }
        finally {
            BufferUtil.flipToFlush(to, pos);
        }
    }

    public static void append(ByteBuffer to, byte b) {
        int pos = BufferUtil.flipToFill(to);
        try {
            to.put(b);
        }
        finally {
            BufferUtil.flipToFlush(to, pos);
        }
    }

    public static int append(ByteBuffer to, ByteBuffer b) {
        int pos = BufferUtil.flipToFill(to);
        try {
            int n = BufferUtil.put(b, to);
            return n;
        }
        finally {
            BufferUtil.flipToFlush(to, pos);
        }
    }

    public static int fill(ByteBuffer to, byte[] b, int off, int len) {
        int pos = BufferUtil.flipToFill(to);
        try {
            int remaining = to.remaining();
            int take = remaining < len ? remaining : len;
            to.put(b, off, take);
            int n = take;
            return n;
        }
        finally {
            BufferUtil.flipToFlush(to, pos);
        }
    }

    public static void readFrom(File file, ByteBuffer buffer) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            FileChannel channel = raf.getChannel();
            long needed = raf.length();
            while (needed > 0L && buffer.hasRemaining()) {
                needed -= (long)channel.read(buffer);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void readFrom(InputStream is, int needed, ByteBuffer buffer) throws IOException {
        ByteBuffer tmp = BufferUtil.allocate(8192);
        while (needed > 0 && buffer.hasRemaining()) {
            int l = is.read(tmp.array(), 0, 8192);
            if (l < 0) break;
            tmp.position(0);
            tmp.limit(l);
            buffer.put(tmp);
        }
    }

    public static void writeTo(ByteBuffer buffer, OutputStream out) throws IOException {
        if (buffer.hasArray()) {
            out.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        } else {
            byte[] bytes = new byte[4096];
            while (buffer.hasRemaining()) {
                int byteCountToWrite = Math.min(buffer.remaining(), 4096);
                buffer.get(bytes, 0, byteCountToWrite);
                out.write(bytes, 0, byteCountToWrite);
            }
        }
    }

    public static String toString(ByteBuffer buffer) {
        return BufferUtil.toString(buffer, StandardCharsets.ISO_8859_1);
    }

    public static String toUTF8String(ByteBuffer buffer) {
        return BufferUtil.toString(buffer, StandardCharsets.UTF_8);
    }

    public static String toString(ByteBuffer buffer, Charset charset) {
        byte[] array;
        if (buffer == null) {
            return null;
        }
        byte[] byArray = array = buffer.hasArray() ? buffer.array() : null;
        if (array == null) {
            byte[] to = new byte[buffer.remaining()];
            buffer.slice().get(to);
            return new String(to, 0, to.length, charset);
        }
        return new String(array, buffer.arrayOffset() + buffer.position(), buffer.remaining(), charset);
    }

    public static String toString(ByteBuffer buffer, int position, int length, Charset charset) {
        byte[] array;
        if (buffer == null) {
            return null;
        }
        byte[] byArray = array = buffer.hasArray() ? buffer.array() : null;
        if (array == null) {
            ByteBuffer ro = buffer.asReadOnlyBuffer();
            ro.position(position);
            ro.limit(position + length);
            byte[] to = new byte[length];
            ro.get(to);
            return new String(to, 0, to.length, charset);
        }
        return new String(array, buffer.arrayOffset() + position, length, charset);
    }

    public static int toInt(ByteBuffer buffer) {
        int val = 0;
        boolean started = false;
        boolean minus = false;
        int i = buffer.position();
        while (i < buffer.limit()) {
            byte b = buffer.get(i);
            if (b <= 32) {
                if (started) {
                    break;
                }
            } else if (b >= 48 && b <= 57) {
                val = val * 10 + (b - 48);
                started = true;
            } else {
                if (b != 45 || started) break;
                minus = true;
            }
            ++i;
        }
        if (started) {
            return minus ? -val : val;
        }
        throw new NumberFormatException(BufferUtil.toString(buffer));
    }

    public static long toLong(ByteBuffer buffer) {
        long val = 0L;
        boolean started = false;
        boolean minus = false;
        int i = buffer.position();
        while (i < buffer.limit()) {
            byte b = buffer.get(i);
            if (b <= 32) {
                if (started) {
                    break;
                }
            } else if (b >= 48 && b <= 57) {
                val = val * 10L + (long)(b - 48);
                started = true;
            } else {
                if (b != 45 || started) break;
                minus = true;
            }
            ++i;
        }
        if (started) {
            return minus ? -val : val;
        }
        throw new NumberFormatException(BufferUtil.toString(buffer));
    }

    public static void putHexInt(ByteBuffer buffer, int n) {
        if (n < 0) {
            buffer.put((byte)45);
            if (n == Integer.MIN_VALUE) {
                buffer.put((byte)56);
                buffer.put((byte)48);
                buffer.put((byte)48);
                buffer.put((byte)48);
                buffer.put((byte)48);
                buffer.put((byte)48);
                buffer.put((byte)48);
                buffer.put((byte)48);
                return;
            }
            n = -n;
        }
        if (n < 16) {
            buffer.put(DIGIT[n]);
        } else {
            boolean started = false;
            int[] nArray = hexDivisors;
            int n2 = hexDivisors.length;
            int n3 = 0;
            while (n3 < n2) {
                int hexDivisor = nArray[n3];
                if (n < hexDivisor) {
                    if (started) {
                        buffer.put((byte)48);
                    }
                } else {
                    started = true;
                    int d = n / hexDivisor;
                    buffer.put(DIGIT[d]);
                    n -= d * hexDivisor;
                }
                ++n3;
            }
        }
    }

    public static void putDecInt(ByteBuffer buffer, int n) {
        if (n < 0) {
            buffer.put((byte)45);
            if (n == Integer.MIN_VALUE) {
                buffer.put((byte)50);
                n = 147483648;
            } else {
                n = -n;
            }
        }
        if (n < 10) {
            buffer.put(DIGIT[n]);
        } else {
            boolean started = false;
            int[] nArray = decDivisors;
            int n2 = decDivisors.length;
            int n3 = 0;
            while (n3 < n2) {
                int decDivisor = nArray[n3];
                if (n < decDivisor) {
                    if (started) {
                        buffer.put((byte)48);
                    }
                } else {
                    started = true;
                    int d = n / decDivisor;
                    buffer.put(DIGIT[d]);
                    n -= d * decDivisor;
                }
                ++n3;
            }
        }
    }

    public static void putDecLong(ByteBuffer buffer, long n) {
        if (n < 0L) {
            buffer.put((byte)45);
            if (n == Long.MIN_VALUE) {
                buffer.put((byte)57);
                n = 223372036854775808L;
            } else {
                n = -n;
            }
        }
        if (n < 10L) {
            buffer.put(DIGIT[(int)n]);
        } else {
            boolean started = false;
            long[] lArray = decDivisorsL;
            int n2 = decDivisorsL.length;
            int n3 = 0;
            while (n3 < n2) {
                long aDecDivisorsL = lArray[n3];
                if (n < aDecDivisorsL) {
                    if (started) {
                        buffer.put((byte)48);
                    }
                } else {
                    started = true;
                    long d = n / aDecDivisorsL;
                    buffer.put(DIGIT[(int)d]);
                    n -= d * aDecDivisorsL;
                }
                ++n3;
            }
        }
    }

    public static ByteBuffer toBuffer(int value) {
        ByteBuffer buf = ByteBuffer.allocate(32);
        BufferUtil.putDecInt(buf, value);
        return buf;
    }

    public static ByteBuffer toBuffer(long value) {
        ByteBuffer buf = ByteBuffer.allocate(32);
        BufferUtil.putDecLong(buf, value);
        return buf;
    }

    public static ByteBuffer toBuffer(String s) {
        return ByteBuffer.wrap(s.getBytes(StandardCharsets.ISO_8859_1));
    }

    public static ByteBuffer toDirectBuffer(String s) {
        byte[] bytes = s.getBytes(StandardCharsets.ISO_8859_1);
        ByteBuffer buf = ByteBuffer.allocateDirect(bytes.length);
        buf.put(bytes);
        buf.flip();
        return buf;
    }

    public static ByteBuffer toBuffer(String s, Charset charset) {
        return ByteBuffer.wrap(s.getBytes(charset));
    }

    public static ByteBuffer toDirectBuffer(String s, Charset charset) {
        byte[] bytes = s.getBytes(charset);
        ByteBuffer buf = ByteBuffer.allocateDirect(bytes.length);
        buf.put(bytes);
        buf.flip();
        return buf;
    }

    public static ByteBuffer toBuffer(byte[] array) {
        return ByteBuffer.wrap(array);
    }

    public static ByteBuffer toBuffer(byte[] array, int offset, int length) {
        return ByteBuffer.wrap(array, offset, length);
    }

    public static ByteBuffer toMappedBuffer(File file) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            return raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, raf.length());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static ByteBuffer toBuffer(Resource resource, boolean direct) throws IOException {
        int len = (int)resource.length();
        if (len < 0) {
            throw new IllegalArgumentException("invalid resource: " + String.valueOf(resource) + " len=" + len);
        }
        ByteBuffer buffer = direct ? BufferUtil.allocateDirect(len) : BufferUtil.allocate(len);
        int pos = BufferUtil.flipToFill(buffer);
        if (resource.getFile() != null) {
            BufferUtil.readFrom(resource.getFile(), buffer);
        } else {
            Throwable throwable = null;
            Object var6_7 = null;
            try (InputStream is = resource.getInputStream();){
                BufferUtil.readFrom(is, len, buffer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        BufferUtil.flipToFlush(buffer, pos);
        return buffer;
    }

    public static String toSummaryString(ByteBuffer buffer) {
        if (buffer == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("[p=");
        buf.append(buffer.position());
        buf.append(",l=");
        buf.append(buffer.limit());
        buf.append(",c=");
        buf.append(buffer.capacity());
        buf.append(",r=");
        buf.append(buffer.remaining());
        buf.append("]");
        return buf.toString();
    }

    public static String toDetailString(ByteBuffer[] buffer) {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        int i = 0;
        while (i < buffer.length) {
            if (i > 0) {
                builder.append(',');
            }
            builder.append(BufferUtil.toDetailString(buffer[i]));
            ++i;
        }
        builder.append(']');
        return builder.toString();
    }

    public static String toDetailString(ByteBuffer buffer) {
        char c;
        if (buffer == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder();
        buf.append(buffer.getClass().getSimpleName());
        buf.append("@");
        if (buffer.hasArray()) {
            buf.append(Integer.toHexString(buffer.array().hashCode()));
        } else {
            buf.append(Integer.toHexString(buf.hashCode()));
        }
        buf.append("[p=");
        buf.append(buffer.position());
        buf.append(",l=");
        buf.append(buffer.limit());
        buf.append(",c=");
        buf.append(buffer.capacity());
        buf.append(",r=");
        buf.append(buffer.remaining());
        buf.append("]={");
        int i = 0;
        while (i < buffer.position()) {
            c = (char)buffer.get(i);
            if (c >= ' ' && c <= '\u007f') {
                buf.append(c);
            } else if (c == '\r' || c == '\n') {
                buf.append('|');
            } else {
                buf.append('\ufffd');
            }
            if (i == 16 && buffer.position() > 32) {
                buf.append("...");
                i = buffer.position() - 16;
            }
            ++i;
        }
        buf.append("<<<");
        i = buffer.position();
        while (i < buffer.limit()) {
            c = (char)buffer.get(i);
            if (c >= ' ' && c <= '\u007f') {
                buf.append(c);
            } else if (c == '\r' || c == '\n') {
                buf.append('|');
            } else {
                buf.append('\ufffd');
            }
            if (i == buffer.position() + 16 && buffer.limit() > buffer.position() + 32) {
                buf.append("...");
                i = buffer.limit() - 16;
            }
            ++i;
        }
        buf.append(">>>");
        int limit = buffer.limit();
        buffer.limit(buffer.capacity());
        int i2 = limit;
        while (i2 < buffer.capacity()) {
            char c2 = (char)buffer.get(i2);
            if (c2 >= ' ' && c2 <= '\u007f') {
                buf.append(c2);
            } else if (c2 == '\r' || c2 == '\n') {
                buf.append('|');
            } else {
                buf.append('\ufffd');
            }
            if (i2 == limit + 16 && buffer.capacity() > limit + 32) {
                buf.append("...");
                i2 = buffer.capacity() - 16;
            }
            ++i2;
        }
        buffer.limit(limit);
        buf.append("}");
        return buf.toString();
    }

    public static void putCRLF(ByteBuffer buffer) {
        buffer.put((byte)13);
        buffer.put((byte)10);
    }

    public static boolean isPrefix(ByteBuffer prefix, ByteBuffer buffer) {
        if (prefix.remaining() > buffer.remaining()) {
            return false;
        }
        int bi = buffer.position();
        int i = prefix.position();
        while (i < prefix.limit()) {
            if (prefix.get(i) != buffer.get(bi++)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

