/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.util.Callback;

public abstract class IteratingCallback
implements Callback {
    private final AtomicReference<State> _state = new AtomicReference<State>(State.INACTIVE);

    protected abstract Action process() throws Exception;

    protected abstract void completed();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void iterate() {
        try {
            block6: while (true) {
                switch (this._state.get()) {
                    case INACTIVE: {
                        if (!this.processIterations()) continue block6;
                        return;
                    }
                    case ITERATING: {
                        if (this._state.compareAndSet(State.ITERATING, State.ITERATE_AGAIN)) return;
                        continue block6;
                    }
                }
                break;
            }
            return;
        }
        catch (Throwable x) {
            this.failed(x);
            return;
        }
    }

    private boolean processIterations() throws Exception {
        block6: while (this._state.compareAndSet(State.INACTIVE, State.ITERATING)) {
            Action action = this.process();
            switch (action) {
                case IDLE: {
                    if (this._state.compareAndSet(State.ITERATING, State.INACTIVE)) {
                        return true;
                    }
                    if (!this._state.compareAndSet(State.ITERATE_AGAIN, State.INACTIVE)) continue block6;
                    break;
                }
                case SCHEDULED: {
                    if (!this._state.compareAndSet(State.ITERATING, State.ACTIVE) && !this._state.compareAndSet(State.ITERATE_AGAIN, State.ACTIVE)) continue block6;
                    return true;
                }
                case SUCCEEDED: {
                    if (this.completeSuccess()) {
                        this.completed();
                    }
                    return true;
                }
                case FAILED: {
                    this.completeFailure();
                    return true;
                }
                default: {
                    throw new IllegalStateException(this.toString());
                }
            }
        }
        return false;
    }

    @Override
    public void succeeded() {
        block5: while (true) {
            State current = this._state.get();
            switch (current) {
                case ITERATING: 
                case ITERATE_AGAIN: {
                    if (!this._state.compareAndSet(current, State.INACTIVE)) continue block5;
                    return;
                }
                case ACTIVE: {
                    if (this._state.compareAndSet(current, State.INACTIVE)) {
                        this.iterate();
                    }
                    return;
                }
                case INACTIVE: {
                    this.iterate();
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException(this.toString());
    }

    @Override
    public void failed(Throwable x) {
        this.completeFailure();
    }

    private boolean completeSuccess() {
        State current;
        do {
            if ((current = this._state.get()) != State.FAILED) continue;
            return false;
        } while (!this._state.compareAndSet(current, State.SUCCEEDED));
        return true;
    }

    private void completeFailure() {
        State current;
        do {
            if ((current = this._state.get()) != State.SUCCEEDED) continue;
            return;
        } while (!this._state.compareAndSet(current, State.FAILED));
    }

    public boolean isIdle() {
        return this._state.get() == State.INACTIVE;
    }

    public boolean isFailed() {
        return this._state.get() == State.FAILED;
    }

    public boolean isSucceeded() {
        return this._state.get() == State.SUCCEEDED;
    }

    public String toString() {
        return String.format("%s[%s]", super.toString(), this._state);
    }

    protected static enum Action {
        IDLE,
        SCHEDULED,
        SUCCEEDED,
        FAILED;

    }

    private static enum State {
        INACTIVE,
        ACTIVE,
        ITERATING,
        ITERATE_AGAIN,
        SUCCEEDED,
        FAILED;

    }
}

