/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;

public class URIUtil
implements Cloneable {
    public static final String SLASH = "/";
    public static final String HTTP = "http";
    public static final String HTTP_COLON = "http:";
    public static final String HTTPS = "https";
    public static final String HTTPS_COLON = "https:";
    public static final Charset __CHARSET;

    static {
        String charset = System.getProperty("org.eclipse.jetty.util.URI.charset");
        __CHARSET = charset == null ? StandardCharsets.UTF_8 : Charset.forName(charset);
    }

    private URIUtil() {
    }

    public static String encodePath(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        StringBuilder buf = URIUtil.encodePath(null, path);
        return buf == null ? path : buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuilder encodePath(StringBuilder buf, String path) {
        byte[] bytes = null;
        if (buf == null) {
            int i = 0;
            block28: while (i < path.length()) {
                char c = path.charAt(i);
                switch (c) {
                    case ' ': 
                    case '\"': 
                    case '#': 
                    case '%': 
                    case '\'': 
                    case ';': 
                    case '<': 
                    case '>': 
                    case '?': {
                        buf = new StringBuilder(path.length() * 2);
                        break block28;
                    }
                    default: {
                        if (c > '\u007f') {
                            bytes = path.getBytes(__CHARSET);
                            buf = new StringBuilder(path.length() * 2);
                            break block28;
                        }
                        ++i;
                    }
                }
            }
            if (buf == null) {
                return null;
            }
        }
        StringBuilder stringBuilder = buf;
        synchronized (stringBuilder) {
            int i;
            if (bytes != null) {
                i = 0;
                while (i < bytes.length) {
                    byte c = bytes[i];
                    switch (c) {
                        case 37: {
                            buf.append("%25");
                            break;
                        }
                        case 63: {
                            buf.append("%3F");
                            break;
                        }
                        case 59: {
                            buf.append("%3B");
                            break;
                        }
                        case 35: {
                            buf.append("%23");
                            break;
                        }
                        case 34: {
                            buf.append("%22");
                            break;
                        }
                        case 39: {
                            buf.append("%27");
                            break;
                        }
                        case 60: {
                            buf.append("%3C");
                            break;
                        }
                        case 62: {
                            buf.append("%3E");
                            break;
                        }
                        case 32: {
                            buf.append("%20");
                            break;
                        }
                        default: {
                            if (c < 0) {
                                buf.append('%');
                                TypeUtil.toHex(c, (Appendable)buf);
                                break;
                            }
                            buf.append((char)c);
                        }
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < path.length()) {
                    char c = path.charAt(i);
                    switch (c) {
                        case '%': {
                            buf.append("%25");
                            break;
                        }
                        case '?': {
                            buf.append("%3F");
                            break;
                        }
                        case ';': {
                            buf.append("%3B");
                            break;
                        }
                        case '#': {
                            buf.append("%23");
                            break;
                        }
                        case '\"': {
                            buf.append("%22");
                            break;
                        }
                        case '\'': {
                            buf.append("%27");
                            break;
                        }
                        case '<': {
                            buf.append("%3C");
                            break;
                        }
                        case '>': {
                            buf.append("%3E");
                            break;
                        }
                        case ' ': {
                            buf.append("%20");
                            break;
                        }
                        default: {
                            buf.append(c);
                        }
                    }
                    ++i;
                }
            }
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuilder encodeString(StringBuilder buf, String path, String encode) {
        if (buf == null) {
            int i = 0;
            while (i < path.length()) {
                char c = path.charAt(i);
                if (c == '%' || encode.indexOf(c) >= 0) {
                    buf = new StringBuilder(path.length() << 1);
                    break;
                }
                ++i;
            }
            if (buf == null) {
                return null;
            }
        }
        StringBuilder stringBuilder = buf;
        synchronized (stringBuilder) {
            int i = 0;
            while (i < path.length()) {
                char c = path.charAt(i);
                if (c == '%' || encode.indexOf(c) >= 0) {
                    buf.append('%');
                    StringUtil.append(buf, (byte)(0xFF & c), 16);
                } else {
                    buf.append(c);
                }
                ++i;
            }
        }
        return buf;
    }

    public static String decodePath(String path) {
        if (path == null) {
            return null;
        }
        char[] chars = null;
        int n = 0;
        byte[] bytes = null;
        int b = 0;
        int len = path.length();
        int i = 0;
        while (i < len) {
            char c = path.charAt(i);
            if (c == '%' && i + 2 < len) {
                if (chars == null) {
                    chars = new char[len];
                    bytes = new byte[len];
                    path.getChars(0, i, chars, 0);
                }
                bytes[b++] = (byte)(0xFF & TypeUtil.parseInt(path, i + 1, 2, 16));
                i += 2;
            } else {
                if (c == ';') {
                    if (chars != null) break;
                    chars = new char[len];
                    path.getChars(0, i, chars, 0);
                    n = i;
                    break;
                }
                if (bytes == null) {
                    ++n;
                } else {
                    if (b > 0) {
                        String s = new String(bytes, 0, b, __CHARSET);
                        s.getChars(0, s.length(), chars, n);
                        n += s.length();
                        b = 0;
                    }
                    chars[n++] = c;
                }
            }
            ++i;
        }
        if (chars == null) {
            return path;
        }
        if (b > 0) {
            String s = new String(bytes, 0, b, __CHARSET);
            s.getChars(0, s.length(), chars, n);
            n += s.length();
        }
        return new String(chars, 0, n);
    }

    /*
     * Unable to fully structure code
     */
    public static String decodePath(byte[] buf, int offset, int length) {
        bytes = null;
        n = 0;
        i = 0;
        while (i < length) {
            block7: {
                b = buf[i + offset];
                if (b != 37 || i + 2 >= length) break block7;
                b = (byte)(255 & TypeUtil.parseInt(buf, i + offset + 1, 2, 16));
                i += 2;
                ** GOTO lbl-1000
            }
            if (b == 59) {
                length = i;
                break;
            }
            if (bytes == null) {
                ++n;
            } else lbl-1000:
            // 2 sources

            {
                if (bytes == null) {
                    bytes = new byte[length];
                    j = 0;
                    while (j < n) {
                        bytes[j] = buf[j + offset];
                        ++j;
                    }
                }
                bytes[n++] = b;
            }
            ++i;
        }
        if (bytes == null) {
            return new String(buf, offset, length, URIUtil.__CHARSET);
        }
        return new String(bytes, 0, n, URIUtil.__CHARSET);
    }

    public static String addPaths(String p1, String p2) {
        if (p1 == null || p1.length() == 0) {
            if (p1 != null && p2 == null) {
                return p1;
            }
            return p2;
        }
        if (p2 == null || p2.length() == 0) {
            return p1;
        }
        int split = p1.indexOf(59);
        if (split < 0) {
            split = p1.indexOf(63);
        }
        if (split == 0) {
            return String.valueOf(p2) + p1;
        }
        if (split < 0) {
            split = p1.length();
        }
        StringBuilder buf = new StringBuilder(p1.length() + p2.length() + 2);
        buf.append(p1);
        if (buf.charAt(split - 1) == '/') {
            if (p2.startsWith(SLASH)) {
                buf.deleteCharAt(split - 1);
                buf.insert(split - 1, p2);
            } else {
                buf.insert(split, p2);
            }
        } else if (p2.startsWith(SLASH)) {
            buf.insert(split, p2);
        } else {
            buf.insert(split, '/');
            buf.insert(split + 1, p2);
        }
        return buf.toString();
    }

    public static String parentPath(String p) {
        if (p == null || SLASH.equals(p)) {
            return null;
        }
        int slash = p.lastIndexOf(47, p.length() - 2);
        if (slash >= 0) {
            return p.substring(0, slash + 1);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String canonicalPath(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        int end = path.length();
        int start = path.lastIndexOf(47, end);
        block8: while (end > 0) {
            switch (end - start) {
                case 2: {
                    if (path.charAt(start + 1) == '.') break block8;
                    break;
                }
                case 3: {
                    if (path.charAt(start + 1) == '.' && path.charAt(start + 2) == '.') break block8;
                }
            }
            end = start;
            start = path.lastIndexOf(47, end - 1);
        }
        if (start >= end) {
            return path;
        }
        StringBuilder buf = new StringBuilder(path);
        int delStart = -1;
        int delEnd = -1;
        int skip = 0;
        block9: while (end > 0) {
            switch (end - start) {
                case 2: {
                    if (buf.charAt(start + 1) != '.') {
                        if (skip <= 0 || --skip != 0) break;
                        int n = delStart = start >= 0 ? start : 0;
                        if (delStart <= 0 || delEnd != buf.length() || buf.charAt(delEnd - 1) != '.') break;
                        ++delStart;
                        break;
                    }
                    if (start < 0 && buf.length() > 2 && buf.charAt(1) == '/' && buf.charAt(2) == '/') break;
                    if (delEnd < 0) {
                        delEnd = end;
                    }
                    if ((delStart = start) < 0 || delStart == 0 && buf.charAt(delStart) == '/') {
                        ++delStart;
                        if (delEnd >= buf.length() || buf.charAt(delEnd) != '/') break;
                        ++delEnd;
                        break;
                    }
                    if (end == buf.length()) {
                        ++delStart;
                    }
                    end = start--;
                    while (start >= 0 && buf.charAt(start) != '/') {
                        --start;
                    }
                    continue block9;
                }
                case 3: {
                    if (buf.charAt(start + 1) != '.' || buf.charAt(start + 2) != '.') {
                        if (skip <= 0 || --skip != 0) break;
                        int n = delStart = start >= 0 ? start : 0;
                        if (delStart <= 0 || delEnd != buf.length() || buf.charAt(delEnd - 1) != '.') break;
                        ++delStart;
                        break;
                    }
                    delStart = start;
                    if (delEnd < 0) {
                        delEnd = end;
                    }
                    ++skip;
                    end = start--;
                    while (start >= 0 && buf.charAt(start) != '/') {
                        --start;
                    }
                    continue block9;
                }
                default: {
                    if (skip <= 0 || --skip != 0) break;
                    int n = delStart = start >= 0 ? start : 0;
                    if (delEnd != buf.length() || buf.charAt(delEnd - 1) != '.') break;
                    ++delStart;
                }
            }
            if (skip <= 0 && delStart >= 0 && delEnd >= delStart) {
                buf.delete(delStart, delEnd);
                delEnd = -1;
                delStart = -1;
                if (skip > 0) {
                    delEnd = end;
                }
            }
            end = start--;
            while (start >= 0 && buf.charAt(start) != '/') {
                --start;
            }
        }
        if (skip > 0) {
            return null;
        }
        if (delEnd >= 0) {
            buf.delete(delStart, delEnd);
        }
        return buf.toString();
    }

    public static String compactPath(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        int state = 0;
        int end = path.length();
        int i = 0;
        block8: while (i < end) {
            char c = path.charAt(i);
            switch (c) {
                case '?': {
                    return path;
                }
                case '/': {
                    if (++state != 2) break;
                    break block8;
                }
                default: {
                    state = 0;
                }
            }
            ++i;
        }
        if (state < 2) {
            return path;
        }
        StringBuffer buf = new StringBuffer(path.length());
        buf.append(path, 0, i);
        block9: while (i < end) {
            char c = path.charAt(i);
            switch (c) {
                case '?': {
                    buf.append(path, i, end);
                    break block9;
                }
                case '/': {
                    if (state++ != 0) break;
                    buf.append(c);
                    break;
                }
                default: {
                    state = 0;
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static boolean hasScheme(String uri) {
        int i = 0;
        while (i < uri.length()) {
            char c = uri.charAt(i);
            if (c == ':') {
                return true;
            }
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || i > 0 && (c >= '0' && c <= '9' || c == '.' || c == '+' || c == '-'))) break;
            ++i;
        }
        return false;
    }

    public static void appendSchemeHostPort(StringBuilder url, String scheme, String server, int port) {
        if (server.indexOf(58) >= 0 && server.charAt(0) != '[') {
            url.append(scheme).append("://").append('[').append(server).append(']');
        } else {
            url.append(scheme).append("://").append(server);
        }
        if (port > 0 && (HTTP.equalsIgnoreCase(scheme) && port != 80 || HTTPS.equalsIgnoreCase(scheme) && port != 443)) {
            url.append(':').append(port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendSchemeHostPort(StringBuffer url, String scheme, String server, int port) {
        StringBuffer stringBuffer = url;
        synchronized (stringBuffer) {
            if (server.indexOf(58) >= 0 && server.charAt(0) != '[') {
                url.append(scheme).append("://").append('[').append(server).append(']');
            } else {
                url.append(scheme).append("://").append(server);
            }
            if (port > 0 && (HTTP.equalsIgnoreCase(scheme) && port != 80 || HTTPS.equalsIgnoreCase(scheme) && port != 443)) {
                url.append(':').append(port);
            }
        }
    }
}

