/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class Utf8Appendable {
    protected static final Logger LOG = Log.getLogger(Utf8Appendable.class);
    public static final char REPLACEMENT = '\ufffd';
    public static final byte[] REPLACEMENT_UTF8 = new byte[]{-17, -65, -67};
    private static final int UTF8_ACCEPT = 0;
    private static final int UTF8_REJECT = 12;
    protected final Appendable _appendable;
    protected int _state = 0;
    private static final byte[] BYTE_TABLE;
    private static final byte[] TRANS_TABLE;
    private int _codep;

    static {
        byte[] byArray = new byte[256];
        byArray[128] = 1;
        byArray[129] = 1;
        byArray[130] = 1;
        byArray[131] = 1;
        byArray[132] = 1;
        byArray[133] = 1;
        byArray[134] = 1;
        byArray[135] = 1;
        byArray[136] = 1;
        byArray[137] = 1;
        byArray[138] = 1;
        byArray[139] = 1;
        byArray[140] = 1;
        byArray[141] = 1;
        byArray[142] = 1;
        byArray[143] = 1;
        byArray[144] = 9;
        byArray[145] = 9;
        byArray[146] = 9;
        byArray[147] = 9;
        byArray[148] = 9;
        byArray[149] = 9;
        byArray[150] = 9;
        byArray[151] = 9;
        byArray[152] = 9;
        byArray[153] = 9;
        byArray[154] = 9;
        byArray[155] = 9;
        byArray[156] = 9;
        byArray[157] = 9;
        byArray[158] = 9;
        byArray[159] = 9;
        byArray[160] = 7;
        byArray[161] = 7;
        byArray[162] = 7;
        byArray[163] = 7;
        byArray[164] = 7;
        byArray[165] = 7;
        byArray[166] = 7;
        byArray[167] = 7;
        byArray[168] = 7;
        byArray[169] = 7;
        byArray[170] = 7;
        byArray[171] = 7;
        byArray[172] = 7;
        byArray[173] = 7;
        byArray[174] = 7;
        byArray[175] = 7;
        byArray[176] = 7;
        byArray[177] = 7;
        byArray[178] = 7;
        byArray[179] = 7;
        byArray[180] = 7;
        byArray[181] = 7;
        byArray[182] = 7;
        byArray[183] = 7;
        byArray[184] = 7;
        byArray[185] = 7;
        byArray[186] = 7;
        byArray[187] = 7;
        byArray[188] = 7;
        byArray[189] = 7;
        byArray[190] = 7;
        byArray[191] = 7;
        byArray[192] = 8;
        byArray[193] = 8;
        byArray[194] = 2;
        byArray[195] = 2;
        byArray[196] = 2;
        byArray[197] = 2;
        byArray[198] = 2;
        byArray[199] = 2;
        byArray[200] = 2;
        byArray[201] = 2;
        byArray[202] = 2;
        byArray[203] = 2;
        byArray[204] = 2;
        byArray[205] = 2;
        byArray[206] = 2;
        byArray[207] = 2;
        byArray[208] = 2;
        byArray[209] = 2;
        byArray[210] = 2;
        byArray[211] = 2;
        byArray[212] = 2;
        byArray[213] = 2;
        byArray[214] = 2;
        byArray[215] = 2;
        byArray[216] = 2;
        byArray[217] = 2;
        byArray[218] = 2;
        byArray[219] = 2;
        byArray[220] = 2;
        byArray[221] = 2;
        byArray[222] = 2;
        byArray[223] = 2;
        byArray[224] = 10;
        byArray[225] = 3;
        byArray[226] = 3;
        byArray[227] = 3;
        byArray[228] = 3;
        byArray[229] = 3;
        byArray[230] = 3;
        byArray[231] = 3;
        byArray[232] = 3;
        byArray[233] = 3;
        byArray[234] = 3;
        byArray[235] = 3;
        byArray[236] = 3;
        byArray[237] = 4;
        byArray[238] = 3;
        byArray[239] = 3;
        byArray[240] = 11;
        byArray[241] = 6;
        byArray[242] = 6;
        byArray[243] = 6;
        byArray[244] = 5;
        byArray[245] = 8;
        byArray[246] = 8;
        byArray[247] = 8;
        byArray[248] = 8;
        byArray[249] = 8;
        byArray[250] = 8;
        byArray[251] = 8;
        byArray[252] = 8;
        byArray[253] = 8;
        byArray[254] = 8;
        byArray[255] = 8;
        BYTE_TABLE = byArray;
        byte[] byArray2 = new byte[108];
        byArray2[1] = 12;
        byArray2[2] = 24;
        byArray2[3] = 36;
        byArray2[4] = 60;
        byArray2[5] = 96;
        byArray2[6] = 84;
        byArray2[7] = 12;
        byArray2[8] = 12;
        byArray2[9] = 12;
        byArray2[10] = 48;
        byArray2[11] = 72;
        byArray2[12] = 12;
        byArray2[13] = 12;
        byArray2[14] = 12;
        byArray2[15] = 12;
        byArray2[16] = 12;
        byArray2[17] = 12;
        byArray2[18] = 12;
        byArray2[19] = 12;
        byArray2[20] = 12;
        byArray2[21] = 12;
        byArray2[22] = 12;
        byArray2[23] = 12;
        byArray2[24] = 12;
        byArray2[26] = 12;
        byArray2[27] = 12;
        byArray2[28] = 12;
        byArray2[29] = 12;
        byArray2[30] = 12;
        byArray2[32] = 12;
        byArray2[34] = 12;
        byArray2[35] = 12;
        byArray2[36] = 12;
        byArray2[37] = 24;
        byArray2[38] = 12;
        byArray2[39] = 12;
        byArray2[40] = 12;
        byArray2[41] = 12;
        byArray2[42] = 12;
        byArray2[43] = 24;
        byArray2[44] = 12;
        byArray2[45] = 24;
        byArray2[46] = 12;
        byArray2[47] = 12;
        byArray2[48] = 12;
        byArray2[49] = 12;
        byArray2[50] = 12;
        byArray2[51] = 12;
        byArray2[52] = 12;
        byArray2[53] = 12;
        byArray2[54] = 12;
        byArray2[55] = 24;
        byArray2[56] = 12;
        byArray2[57] = 12;
        byArray2[58] = 12;
        byArray2[59] = 12;
        byArray2[60] = 12;
        byArray2[61] = 24;
        byArray2[62] = 12;
        byArray2[63] = 12;
        byArray2[64] = 12;
        byArray2[65] = 12;
        byArray2[66] = 12;
        byArray2[67] = 12;
        byArray2[68] = 12;
        byArray2[69] = 24;
        byArray2[70] = 12;
        byArray2[71] = 12;
        byArray2[72] = 12;
        byArray2[73] = 12;
        byArray2[74] = 12;
        byArray2[75] = 12;
        byArray2[76] = 12;
        byArray2[77] = 12;
        byArray2[78] = 12;
        byArray2[79] = 36;
        byArray2[80] = 12;
        byArray2[81] = 36;
        byArray2[82] = 12;
        byArray2[83] = 12;
        byArray2[84] = 12;
        byArray2[85] = 36;
        byArray2[86] = 12;
        byArray2[87] = 12;
        byArray2[88] = 12;
        byArray2[89] = 12;
        byArray2[90] = 12;
        byArray2[91] = 36;
        byArray2[92] = 12;
        byArray2[93] = 36;
        byArray2[94] = 12;
        byArray2[95] = 12;
        byArray2[96] = 12;
        byArray2[97] = 36;
        byArray2[98] = 12;
        byArray2[99] = 12;
        byArray2[100] = 12;
        byArray2[101] = 12;
        byArray2[102] = 12;
        byArray2[103] = 12;
        byArray2[104] = 12;
        byArray2[105] = 12;
        byArray2[106] = 12;
        byArray2[107] = 12;
        TRANS_TABLE = byArray2;
    }

    public Utf8Appendable(Appendable appendable) {
        this._appendable = appendable;
    }

    public abstract int length();

    protected void reset() {
        this._state = 0;
    }

    public void append(byte b) {
        try {
            this.appendByte(b);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void append(ByteBuffer buf) {
        try {
            while (buf.remaining() > 0) {
                this.appendByte(buf.get());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void append(byte[] b, int offset, int length) {
        try {
            int end = offset + length;
            int i = offset;
            while (i < end) {
                this.appendByte(b[i]);
                ++i;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean append(byte[] b, int offset, int length, int maxChars) {
        try {
            int end = offset + length;
            int i = offset;
            while (true) {
                if (i >= end) {
                    return true;
                }
                if (this.length() > maxChars) {
                    return false;
                }
                this.appendByte(b[i]);
                ++i;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void appendByte(byte b) throws IOException {
        if (b > 0 && this._state == 0) {
            this._appendable.append((char)(b & 0xFF));
        } else {
            int i = b & 0xFF;
            byte type = BYTE_TABLE[i];
            this._codep = this._state == 0 ? 255 >> type & i : i & 0x3F | this._codep << 6;
            int next = TRANS_TABLE[this._state + type];
            switch (next) {
                case 0: {
                    this._state = next;
                    if (this._codep < 55296) {
                        this._appendable.append((char)this._codep);
                        break;
                    }
                    char[] cArray = Character.toChars(this._codep);
                    int n = cArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char c = cArray[n2];
                        this._appendable.append(c);
                        ++n2;
                    }
                    break;
                }
                case 12: {
                    String reason = "byte " + TypeUtil.toHexString(b) + " in state " + this._state / 12;
                    this._codep = 0;
                    this._state = 0;
                    this._appendable.append('\ufffd');
                    throw new NotUtf8Exception(reason);
                }
                default: {
                    this._state = next;
                }
            }
        }
    }

    public boolean isUtf8SequenceComplete() {
        return this._state == 0;
    }

    protected void checkState() {
        if (!this.isUtf8SequenceComplete()) {
            this._codep = 0;
            this._state = 0;
            try {
                this._appendable.append('\ufffd');
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            throw new NotUtf8Exception("incomplete UTF8 sequence");
        }
    }

    public String toReplacedString() {
        if (!this.isUtf8SequenceComplete()) {
            this._codep = 0;
            this._state = 0;
            try {
                this._appendable.append('\ufffd');
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            NotUtf8Exception th = new NotUtf8Exception("incomplete UTF8 sequence");
            LOG.warn(th.toString(), new Object[0]);
            LOG.debug(th);
        }
        return this._appendable.toString();
    }

    public static class NotUtf8Exception
    extends IllegalArgumentException {
        public NotUtf8Exception(String reason) {
            super("Not valid UTF8! " + reason);
        }
    }
}

