/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.Destroyable;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Implementation of Container and LifeCycle")
public class ContainerLifeCycle
extends AbstractLifeCycle
implements Container,
Destroyable,
Dumpable {
    private static final Logger LOG = Log.getLogger(ContainerLifeCycle.class);
    private final List<Bean> _beans = new CopyOnWriteArrayList<Bean>();
    private final List<Container.Listener> _listeners = new CopyOnWriteArrayList<Container.Listener>();
    private boolean _started = false;

    @Override
    protected void doStart() throws Exception {
        this._started = true;
        for (Bean b : this._beans) {
            if (!(b._bean instanceof LifeCycle)) continue;
            LifeCycle l = (LifeCycle)b._bean;
            switch (b._managed) {
                case MANAGED: {
                    if (l.isRunning()) break;
                    this.start(l);
                    break;
                }
                case AUTO: {
                    if (l.isRunning()) {
                        this.unmanage(b);
                        break;
                    }
                    this.manage(b);
                    this.start(l);
                }
            }
        }
        super.doStart();
    }

    protected void start(LifeCycle l) throws Exception {
        l.start();
    }

    protected void stop(LifeCycle l) throws Exception {
        l.stop();
    }

    @Override
    protected void doStop() throws Exception {
        this._started = false;
        super.doStop();
        ArrayList<Bean> reverse = new ArrayList<Bean>(this._beans);
        Collections.reverse(reverse);
        for (Bean b : reverse) {
            LifeCycle l;
            if (b._managed != Managed.MANAGED || !(b._bean instanceof LifeCycle) || !(l = (LifeCycle)b._bean).isRunning()) continue;
            this.stop(l);
        }
    }

    @Override
    public void destroy() {
        ArrayList<Bean> reverse = new ArrayList<Bean>(this._beans);
        Collections.reverse(reverse);
        for (Bean b : reverse) {
            if (!(b._bean instanceof Destroyable) || b._managed != Managed.MANAGED && b._managed != Managed.POJO) continue;
            Destroyable d = (Destroyable)b._bean;
            d.destroy();
        }
        this._beans.clear();
    }

    public boolean contains(Object bean) {
        for (Bean b : this._beans) {
            if (b._bean != bean) continue;
            return true;
        }
        return false;
    }

    public boolean isManaged(Object bean) {
        for (Bean b : this._beans) {
            if (b._bean != bean) continue;
            return b.isManaged();
        }
        return false;
    }

    @Override
    public boolean addBean(Object o) {
        if (o instanceof LifeCycle) {
            LifeCycle l = (LifeCycle)o;
            return this.addBean(o, l.isRunning() ? Managed.UNMANAGED : Managed.AUTO);
        }
        return this.addBean(o, Managed.POJO);
    }

    public boolean addBean(Object o, boolean managed) {
        if (o instanceof LifeCycle) {
            return this.addBean(o, managed ? Managed.MANAGED : Managed.UNMANAGED);
        }
        return this.addBean(o, managed ? Managed.POJO : Managed.UNMANAGED);
    }

    public boolean addBean(Object o, Managed managed) {
        if (this.contains(o)) {
            return false;
        }
        Bean new_bean = new Bean(o);
        if (o instanceof Container.Listener) {
            this.addEventListener((Container.Listener)o);
        }
        this._beans.add(new_bean);
        for (Container.Listener listener : this._listeners) {
            listener.beanAdded(this, o);
        }
        try {
            switch (managed) {
                case UNMANAGED: {
                    this.unmanage(new_bean);
                    break;
                }
                case MANAGED: {
                    LifeCycle lifeCycle;
                    this.manage(new_bean);
                    if (this._started && !(lifeCycle = (LifeCycle)o).isRunning()) {
                        this.start(lifeCycle);
                    }
                    break;
                }
                case AUTO: {
                    if (o instanceof LifeCycle) {
                        LifeCycle lifeCycle = (LifeCycle)o;
                        if (this._started) {
                            if (lifeCycle.isRunning()) {
                                this.unmanage(new_bean);
                                break;
                            }
                            this.manage(new_bean);
                            this.start(lifeCycle);
                            break;
                        }
                        new_bean._managed = Managed.AUTO;
                        break;
                    }
                    new_bean._managed = Managed.POJO;
                    break;
                }
                case POJO: {
                    new_bean._managed = Managed.POJO;
                }
            }
        }
        catch (Error | RuntimeException throwable) {
            throw throwable;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        LOG.debug("{} added {}", this, new_bean);
        return true;
    }

    @Override
    public void addEventListener(Container.Listener listener) {
        if (this._listeners.contains(listener)) {
            return;
        }
        this._listeners.add(listener);
        for (Bean b : this._beans) {
            listener.beanAdded(this, b._bean);
            if (!(listener instanceof Container.InheritedListener) || !b.isManaged() || !(b._bean instanceof Container)) continue;
            if (b._bean instanceof ContainerLifeCycle) {
                ((ContainerLifeCycle)b._bean).addBean((Object)listener, false);
                continue;
            }
            ((Container)b._bean).addBean(listener);
        }
    }

    public void manage(Object bean) {
        for (Bean b : this._beans) {
            if (b._bean != bean) continue;
            this.manage(b);
            return;
        }
        throw new IllegalArgumentException("Unknown bean " + bean);
    }

    private void manage(Bean bean) {
        if (bean._managed != Managed.MANAGED) {
            bean._managed = Managed.MANAGED;
            if (bean._bean instanceof Container) {
                for (Container.Listener l : this._listeners) {
                    if (!(l instanceof Container.InheritedListener)) continue;
                    if (bean._bean instanceof ContainerLifeCycle) {
                        ((ContainerLifeCycle)bean._bean).addBean((Object)l, false);
                        continue;
                    }
                    ((Container)bean._bean).addBean(l);
                }
            }
            if (bean._bean instanceof AbstractLifeCycle) {
                ((AbstractLifeCycle)bean._bean).setStopTimeout(this.getStopTimeout());
            }
        }
    }

    public void unmanage(Object bean) {
        for (Bean b : this._beans) {
            if (b._bean != bean) continue;
            this.unmanage(b);
            return;
        }
        throw new IllegalArgumentException("Unknown bean " + bean);
    }

    private void unmanage(Bean bean) {
        if (bean._managed != Managed.UNMANAGED) {
            if (bean._managed == Managed.MANAGED && bean._bean instanceof Container) {
                for (Container.Listener l : this._listeners) {
                    if (!(l instanceof Container.InheritedListener)) continue;
                    ((Container)bean._bean).removeBean(l);
                }
            }
            bean._managed = Managed.UNMANAGED;
        }
    }

    @Override
    public Collection<Object> getBeans() {
        return this.getBeans(Object.class);
    }

    public void setBeans(Collection<Object> beans) {
        for (Object bean : beans) {
            this.addBean(bean);
        }
    }

    @Override
    public <T> Collection<T> getBeans(Class<T> clazz) {
        ArrayList<T> beans = new ArrayList<T>();
        for (Bean b : this._beans) {
            if (!clazz.isInstance(b._bean)) continue;
            beans.add(clazz.cast(b._bean));
        }
        return beans;
    }

    @Override
    public <T> T getBean(Class<T> clazz) {
        for (Bean b : this._beans) {
            if (!clazz.isInstance(b._bean)) continue;
            return clazz.cast(b._bean);
        }
        return null;
    }

    public void removeBeans() {
        ArrayList<Bean> beans = new ArrayList<Bean>(this._beans);
        for (Bean b : beans) {
            this.remove(b);
        }
    }

    private Bean getBean(Object o) {
        for (Bean b : this._beans) {
            if (b._bean != o) continue;
            return b;
        }
        return null;
    }

    @Override
    public boolean removeBean(Object o) {
        Bean b = this.getBean(o);
        return b != null && this.remove(b);
    }

    private boolean remove(Bean bean) {
        if (this._beans.remove(bean)) {
            this.unmanage(bean);
            for (Container.Listener l : this._listeners) {
                l.beanRemoved(this, bean._bean);
            }
            if (bean._bean instanceof Container.Listener) {
                this.removeEventListener((Container.Listener)bean._bean);
            }
            if (bean._managed == Managed.MANAGED && bean._bean instanceof LifeCycle) {
                try {
                    this.stop((LifeCycle)bean._bean);
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void removeEventListener(Container.Listener listener) {
        if (this._listeners.remove(listener)) {
            for (Bean b : this._beans) {
                listener.beanRemoved(this, b._bean);
                if (!(listener instanceof Container.InheritedListener) || !b.isManaged() || !(b._bean instanceof Container)) continue;
                ((Container)b._bean).removeBean(listener);
            }
        }
    }

    @Override
    public void setStopTimeout(long stopTimeout) {
        super.setStopTimeout(stopTimeout);
        for (Bean bean : this._beans) {
            if (!bean.isManaged() || !(bean._bean instanceof AbstractLifeCycle)) continue;
            ((AbstractLifeCycle)bean._bean).setStopTimeout(stopTimeout);
        }
    }

    @ManagedOperation(value="Dump the object to stderr")
    public void dumpStdErr() {
        try {
            this.dump(System.err, "");
        }
        catch (IOException e) {
            LOG.warn(e);
        }
    }

    @Override
    @ManagedOperation(value="Dump the object to a string")
    public String dump() {
        return ContainerLifeCycle.dump(this);
    }

    public static String dump(Dumpable dumpable) {
        StringBuilder b = new StringBuilder();
        try {
            dumpable.dump(b, "");
        }
        catch (IOException e) {
            LOG.warn(e);
        }
        return b.toString();
    }

    public void dump(Appendable out) throws IOException {
        this.dump(out, "");
    }

    protected void dumpThis(Appendable out) throws IOException {
        out.append(String.valueOf(this)).append(" - ").append(this.getState()).append("\n");
    }

    public static void dumpObject(Appendable out, Object o) throws IOException {
        try {
            if (o instanceof LifeCycle) {
                out.append(String.valueOf(o)).append(" - ").append(AbstractLifeCycle.getState((LifeCycle)o)).append("\n");
            } else {
                out.append(String.valueOf(o)).append("\n");
            }
        }
        catch (Throwable th) {
            out.append(" => ").append(th.toString()).append('\n');
        }
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        this.dumpBeans(out, indent, new Collection[0]);
    }

    protected void dumpBeans(Appendable out, String indent, Collection<?> ... collections) throws IOException {
        this.dumpThis(out);
        int size = this._beans.size();
        Collection<?>[] collectionArray = collections;
        int n = collections.length;
        int n2 = 0;
        while (n2 < n) {
            Collection<?> c = collectionArray[n2];
            size += c.size();
            ++n2;
        }
        if (size == 0) {
            return;
        }
        int i = 0;
        for (Bean b : this._beans) {
            ++i;
            switch (b._managed) {
                case POJO: {
                    out.append(indent).append(" +- ");
                    if (b._bean instanceof Dumpable) {
                        ((Dumpable)b._bean).dump(out, String.valueOf(indent) + (i == size ? "    " : " |  "));
                        break;
                    }
                    ContainerLifeCycle.dumpObject(out, b._bean);
                    break;
                }
                case MANAGED: {
                    out.append(indent).append(" += ");
                    if (b._bean instanceof Dumpable) {
                        ((Dumpable)b._bean).dump(out, String.valueOf(indent) + (i == size ? "    " : " |  "));
                        break;
                    }
                    ContainerLifeCycle.dumpObject(out, b._bean);
                    break;
                }
                case UNMANAGED: {
                    out.append(indent).append(" +~ ");
                    ContainerLifeCycle.dumpObject(out, b._bean);
                    break;
                }
                case AUTO: {
                    out.append(indent).append(" +? ");
                    if (b._bean instanceof Dumpable) {
                        ((Dumpable)b._bean).dump(out, String.valueOf(indent) + (i == size ? "    " : " |  "));
                        break;
                    }
                    ContainerLifeCycle.dumpObject(out, b._bean);
                }
            }
        }
        if (i < size) {
            out.append(indent).append(" |\n");
        }
        Collection<?>[] collectionArray2 = collections;
        int n3 = collections.length;
        int n4 = 0;
        while (n4 < n3) {
            Collection<?> c = collectionArray2[n4];
            for (Object o : c) {
                ++i;
                out.append(indent).append(" +> ");
                if (o instanceof Dumpable) {
                    ((Dumpable)o).dump(out, String.valueOf(indent) + (i == size ? "    " : " |  "));
                    continue;
                }
                ContainerLifeCycle.dumpObject(out, o);
            }
            ++n4;
        }
    }

    public static void dump(Appendable out, String indent, Collection<?> ... collections) throws IOException {
        if (collections.length == 0) {
            return;
        }
        int size = 0;
        Collection<?>[] collectionArray = collections;
        int n = collections.length;
        int n2 = 0;
        while (n2 < n) {
            Collection<?> c = collectionArray[n2];
            size += c.size();
            ++n2;
        }
        if (size == 0) {
            return;
        }
        int i = 0;
        Collection<?>[] collectionArray2 = collections;
        int n3 = collections.length;
        n = 0;
        while (n < n3) {
            Collection<?> c = collectionArray2[n];
            for (Object o : c) {
                ++i;
                out.append(indent).append(" +- ");
                if (o instanceof Dumpable) {
                    ((Dumpable)o).dump(out, String.valueOf(indent) + (i == size ? "    " : " |  "));
                    continue;
                }
                ContainerLifeCycle.dumpObject(out, o);
            }
            ++n;
        }
    }

    public void updateBean(Object oldBean, Object newBean) {
        if (newBean != oldBean) {
            if (oldBean != null) {
                this.removeBean(oldBean);
            }
            if (newBean != null) {
                this.addBean(newBean);
            }
        }
    }

    public void updateBeans(Object[] oldBeans, Object[] newBeans) {
        int n;
        int n2;
        Object[] objectArray;
        int n3;
        int n4;
        Object[] objectArray2;
        if (oldBeans != null) {
            objectArray2 = oldBeans;
            n4 = oldBeans.length;
            n3 = 0;
            while (n3 < n4) {
                Object o = objectArray2[n3];
                if (newBeans != null) {
                    objectArray = newBeans;
                    n2 = newBeans.length;
                    n = 0;
                    while (n < n2) {
                        Object n5 = objectArray[n];
                        if (o != n5) {
                            ++n;
                            continue;
                        }
                        break;
                    }
                } else {
                    this.removeBean(o);
                }
                ++n3;
            }
        }
        if (newBeans != null) {
            objectArray2 = newBeans;
            n4 = newBeans.length;
            n3 = 0;
            while (n3 < n4) {
                Object n6 = objectArray2[n3];
                if (oldBeans != null) {
                    objectArray = oldBeans;
                    n2 = oldBeans.length;
                    n = 0;
                    while (n < n2) {
                        Object o = objectArray[n];
                        if (o != n6) {
                            ++n;
                            continue;
                        }
                        break;
                    }
                } else {
                    this.addBean(n6);
                }
                ++n3;
            }
        }
    }

    private static class Bean {
        private final Object _bean;
        private volatile Managed _managed = Managed.POJO;

        private Bean(Object b) {
            this._bean = b;
        }

        public boolean isManaged() {
            return this._managed == Managed.MANAGED;
        }

        public String toString() {
            return String.format("{%s,%s}", new Object[]{this._bean, this._managed});
        }
    }

    static enum Managed {
        POJO,
        MANAGED,
        UNMANAGED,
        AUTO;

    }
}

