/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class ClasspathPattern {
    private final List<String> _patterns = new ArrayList<String>();
    private final List<Entry> _entries = new ArrayList<Entry>();

    public ClasspathPattern() {
    }

    public ClasspathPattern(String[] patterns) {
        this.setPatterns(patterns);
    }

    public ClasspathPattern(String pattern) {
        this.setPattern(pattern);
    }

    private void setPatterns(String[] patterns) {
        this._patterns.clear();
        this._entries.clear();
        this.addPatterns(patterns);
    }

    private void addPatterns(String[] patterns) {
        if (patterns != null) {
            Entry entry = null;
            String[] stringArray = patterns;
            int n = patterns.length;
            int n2 = 0;
            while (n2 < n) {
                String pattern = stringArray[n2];
                entry = this.createEntry(pattern);
                if (entry != null) {
                    this._patterns.add(pattern);
                    this._entries.add(entry);
                }
                ++n2;
            }
        }
    }

    private void prependPatterns(String[] patterns) {
        if (patterns != null) {
            Entry entry = null;
            int i = 0;
            String[] stringArray = patterns;
            int n = patterns.length;
            int n2 = 0;
            while (n2 < n) {
                String pattern = stringArray[n2];
                entry = this.createEntry(pattern);
                if (entry != null) {
                    this._patterns.add(i, pattern);
                    this._entries.add(i, entry);
                    ++i;
                }
                ++n2;
            }
        }
    }

    private Entry createEntry(String pattern) {
        String item;
        Entry entry = null;
        if (pattern != null && (item = pattern.trim()).length() > 0) {
            entry = new Entry();
            entry.result = !item.startsWith("-");
            entry.partial = item.endsWith(".");
            entry.classpath = entry.result ? item : item.substring(1).trim();
        }
        return entry;
    }

    public void setPattern(String pattern) {
        this._patterns.clear();
        this._entries.clear();
        this.addPattern(pattern);
    }

    public void addPattern(String pattern) {
        ArrayList<String> patterns = new ArrayList<String>();
        StringTokenizer entries = new StringTokenizer(pattern, ":,");
        while (entries.hasMoreTokens()) {
            patterns.add(entries.nextToken());
        }
        this.addPatterns(patterns.toArray(new String[patterns.size()]));
    }

    public void prependPattern(String classOrPackage) {
        ArrayList<String> patterns = new ArrayList<String>();
        StringTokenizer entries = new StringTokenizer(classOrPackage, ":,");
        while (entries.hasMoreTokens()) {
            patterns.add(entries.nextToken());
        }
        this.prependPatterns(patterns.toArray(new String[patterns.size()]));
    }

    public String[] getPatterns() {
        String[] patterns = null;
        if (this._patterns != null && this._patterns.size() > 0) {
            patterns = this._patterns.toArray(new String[this._patterns.size()]);
        }
        return patterns;
    }

    public boolean match(String name) {
        boolean result = false;
        if (this._entries != null) {
            name = name.replace('/', '.');
            int startIndex = 0;
            while (startIndex < name.length() && name.charAt(startIndex) == '.') {
                ++startIndex;
            }
            int dollar = name.indexOf("$");
            int endIndex = dollar != -1 ? dollar : name.length();
            for (Entry entry : this._entries) {
                if (entry == null) continue;
                if (entry.partial) {
                    if (!name.regionMatches(startIndex, entry.classpath, 0, entry.classpath.length())) continue;
                    result = entry.result;
                    break;
                }
                int regionLength = endIndex - startIndex;
                if (regionLength != entry.classpath.length() || !name.regionMatches(startIndex, entry.classpath, 0, regionLength)) continue;
                result = entry.result;
                break;
            }
        }
        return result;
    }

    private static class Entry {
        public String classpath = null;
        public boolean result = false;
        public boolean partial = false;

        private Entry() {
        }
    }
}

