/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.nio.ByteBuffer;
import java.util.List;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.api.ProtocolException;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.Extension;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.OpCode;

public class Generator {
    public static final int MAX_HEADER_LENGTH = 28;
    private final WebSocketBehavior behavior;
    private final ByteBufferPool bufferPool;
    private final boolean validating;
    private byte flagsInUse = 0;

    public Generator(WebSocketPolicy policy, ByteBufferPool bufferPool) {
        this(policy, bufferPool, true);
    }

    public Generator(WebSocketPolicy policy, ByteBufferPool bufferPool, boolean validating) {
        this.behavior = policy.getBehavior();
        this.bufferPool = bufferPool;
        this.validating = validating;
    }

    public void assertFrameValid(Frame frame) {
        if (!this.validating) {
            return;
        }
        if (frame.isRsv1() && !this.isRsv1InUse()) {
            throw new ProtocolException("RSV1 not allowed to be set");
        }
        if (frame.isRsv2() && !this.isRsv2InUse()) {
            throw new ProtocolException("RSV2 not allowed to be set");
        }
        if (frame.isRsv3() && !this.isRsv3InUse()) {
            throw new ProtocolException("RSV3 not allowed to be set");
        }
        if (OpCode.isControlFrame(frame.getOpCode())) {
            ByteBuffer payload;
            if (frame.getPayloadLength() > 125) {
                throw new ProtocolException("Invalid control frame payload length");
            }
            if (!frame.isFin()) {
                throw new ProtocolException("Control Frames must be FIN=true");
            }
            if (frame.getOpCode() == 8 && (payload = frame.getPayload()) != null) {
                new CloseInfo(payload, true);
            }
        }
    }

    public void configureFromExtensions(List<? extends Extension> exts) {
        this.flagsInUse = 0;
        for (Extension extension : exts) {
            if (extension.isRsv1User()) {
                this.flagsInUse = (byte)(this.flagsInUse | 0x40);
            }
            if (extension.isRsv2User()) {
                this.flagsInUse = (byte)(this.flagsInUse | 0x20);
            }
            if (!extension.isRsv3User()) continue;
            this.flagsInUse = (byte)(this.flagsInUse | 0x10);
        }
    }

    public ByteBuffer generateHeaderBytes(Frame frame) {
        ByteBuffer buffer = this.bufferPool.acquire(28, true);
        this.generateHeaderBytes(frame, buffer);
        return buffer;
    }

    public void generateHeaderBytes(Frame frame, ByteBuffer buffer) {
        int p = BufferUtil.flipToFill(buffer);
        this.assertFrameValid(frame);
        byte b = 0;
        if (frame.isFin()) {
            b = (byte)(b | 0x80);
        }
        if (frame.isRsv1()) {
            b = (byte)(b | 0x40);
        }
        if (frame.isRsv2()) {
            b = (byte)(b | 0x20);
        }
        if (frame.isRsv3()) {
            b = (byte)(b | 0x10);
        }
        byte opcode = frame.getOpCode();
        if (frame.getOpCode() == 0) {
            opcode = 0;
        }
        b = (byte)(b | opcode & 0xF);
        buffer.put(b);
        b = frame.isMasked() ? (byte)-128 : 0;
        int payloadLength = frame.getPayloadLength();
        if (payloadLength > 65535) {
            b = (byte)(b | 0x7F);
            buffer.put(b);
            buffer.put((byte)0);
            buffer.put((byte)0);
            buffer.put((byte)0);
            buffer.put((byte)0);
            buffer.put((byte)(payloadLength >> 24 & 0xFF));
            buffer.put((byte)(payloadLength >> 16 & 0xFF));
            buffer.put((byte)(payloadLength >> 8 & 0xFF));
            buffer.put((byte)(payloadLength & 0xFF));
        } else if (payloadLength >= 126) {
            b = (byte)(b | 0x7E);
            buffer.put(b);
            buffer.put((byte)(payloadLength >> 8));
            buffer.put((byte)(payloadLength & 0xFF));
        } else {
            b = (byte)(b | payloadLength & 0x7F);
            buffer.put(b);
        }
        if (frame.isMasked()) {
            byte[] mask = frame.getMask();
            buffer.put(mask);
            int maskInt = 0;
            byte[] byArray = mask;
            int n = mask.length;
            int n2 = 0;
            while (n2 < n) {
                byte maskByte = byArray[n2];
                maskInt = (maskInt << 8) + (maskByte & 0xFF);
                ++n2;
            }
            ByteBuffer payload = frame.getPayload();
            if (payload != null && payload.remaining() > 0) {
                int remaining;
                int maskOffset = 0;
                int start = payload.position();
                int end = payload.limit();
                while ((remaining = end - start) > 0) {
                    if (remaining >= 4) {
                        payload.putInt(start, payload.getInt(start) ^ maskInt);
                        start += 4;
                        continue;
                    }
                    payload.put(start, (byte)(payload.get(start) ^ mask[maskOffset & 3]));
                    ++start;
                    ++maskOffset;
                }
            }
        }
        BufferUtil.flipToFlush(buffer, p);
    }

    public void generateWholeFrame(Frame frame, ByteBuffer buf) {
        buf.put(this.generateHeaderBytes(frame));
        if (frame.hasPayload()) {
            buf.put(frame.getPayload());
        }
    }

    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    public void setRsv1InUse(boolean rsv1InUse) {
        this.flagsInUse = (byte)(this.flagsInUse & 0xBF | (rsv1InUse ? 64 : 0));
    }

    public void setRsv2InUse(boolean rsv2InUse) {
        this.flagsInUse = (byte)(this.flagsInUse & 0xDF | (rsv2InUse ? 32 : 0));
    }

    public void setRsv3InUse(boolean rsv3InUse) {
        this.flagsInUse = (byte)(this.flagsInUse & 0xEF | (rsv3InUse ? 16 : 0));
    }

    public boolean isRsv1InUse() {
        return (this.flagsInUse & 0x40) != 0;
    }

    public boolean isRsv2InUse() {
        return (this.flagsInUse & 0x20) != 0;
    }

    public boolean isRsv3InUse() {
        return (this.flagsInUse & 0x10) != 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Generator[");
        builder.append((Object)this.behavior);
        if (this.validating) {
            builder.append(",validating");
        }
        if (this.isRsv1InUse()) {
            builder.append(",+rsv1");
        }
        if (this.isRsv2InUse()) {
            builder.append(",+rsv2");
        }
        if (this.isRsv3InUse()) {
            builder.append(",+rsv3");
        }
        builder.append("]");
        return builder.toString();
    }
}

