/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.events.annotated;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.common.util.ReflectUtils;

public class CallableMethod {
    private static final Logger LOG = Log.getLogger(CallableMethod.class);
    protected final Class<?> pojo;
    protected final Method method;
    protected Class<?>[] paramTypes;

    public CallableMethod(Class<?> pojo, Method method) {
        Objects.requireNonNull(pojo, "Pojo cannot be null");
        Objects.requireNonNull(method, "Method cannot be null");
        this.pojo = pojo;
        this.method = method;
        this.paramTypes = method.getParameterTypes();
    }

    /*
     * Unable to fully structure code
     */
    public Object call(Object obj, Object ... args) {
        if (this.pojo == null || this.method == null) {
            CallableMethod.LOG.warn("Cannot execute call: pojo={}, method={}", new Object[]{this.pojo, this.method});
            return null;
        }
        if (obj == null) {
            CallableMethod.LOG.warn("Cannot call {} on null object", new Object[]{this.method});
            return null;
        }
        if (args.length < this.paramTypes.length) {
            throw new IllegalArgumentException("Call arguments length [" + args.length + "] must always be greater than or equal to captured args length [" + this.paramTypes.length + "]");
        }
        try {
            return this.method.invoke(obj, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            err = new StringBuilder();
            err.append("Cannot call method ");
            err.append(ReflectUtils.toString(this.pojo, this.method));
            err.append(" with args: [");
            delim = false;
            var9_6 = args;
            var8_7 = args.length;
            var7_8 = 0;
            ** while (var7_8 < var8_7)
        }
lbl-1000:
        // 1 sources

        {
            arg = var9_6[var7_8];
            if (delim) {
                err.append(", ");
            }
            if (arg == null) {
                err.append("<null>");
            } else {
                err.append(arg.getClass().getName());
            }
            delim = true;
            ++var7_8;
            continue;
        }
lbl37:
        // 1 sources

        err.append("]");
        throw new WebSocketException(err.toString(), e);
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?>[] getParamTypes() {
        return this.paramTypes;
    }

    public Class<?> getPojo() {
        return this.pojo;
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.method.toGenericString());
    }
}

