/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.events.annotated;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.websocket.api.InvalidWebSocketException;
import org.eclipse.jetty.websocket.common.events.ParamList;

public class InvalidSignatureException
extends InvalidWebSocketException {
    public static InvalidSignatureException build(Method method, Class<? extends Annotation> annoClass, ParamList ... paramlists) {
        StringBuilder err = new StringBuilder();
        err.append("Invalid declaration of ");
        err.append(method);
        err.append(StringUtil.__LINE_SEPARATOR);
        err.append("Acceptable method declarations for @");
        err.append(annoClass.getSimpleName());
        err.append(" are:");
        ParamList[] paramListArray = paramlists;
        int n = paramlists.length;
        int n2 = 0;
        while (n2 < n) {
            ParamList validParams = paramListArray[n2];
            for (Class[] params : validParams) {
                err.append(StringUtil.__LINE_SEPARATOR);
                err.append("public void ").append(method.getName());
                err.append('(');
                boolean delim = false;
                Class[] classArray = params;
                int n3 = params.length;
                int n4 = 0;
                while (n4 < n3) {
                    Class type = classArray[n4];
                    if (delim) {
                        err.append(',');
                    }
                    err.append(' ');
                    err.append(type.getName());
                    if (type.isArray()) {
                        err.append("[]");
                    }
                    delim = true;
                    ++n4;
                }
                err.append(')');
            }
            ++n2;
        }
        return new InvalidSignatureException(err.toString());
    }

    public InvalidSignatureException(String message) {
        super(message);
    }

    public InvalidSignatureException(String message, Throwable cause) {
        super(message, cause);
    }
}

