/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.compress;

import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.ConcurrentArrayQueue;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BadPayloadException;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.OpCode;
import org.eclipse.jetty.websocket.common.extensions.AbstractExtension;
import org.eclipse.jetty.websocket.common.extensions.compress.ByteAccumulator;
import org.eclipse.jetty.websocket.common.frames.DataFrame;

public abstract class CompressExtension
extends AbstractExtension {
    protected static final byte[] TAIL_BYTES;
    private static final Logger LOG;
    private final Queue<FrameEntry> entries = new ConcurrentArrayQueue<FrameEntry>();
    private final IteratingCallback flusher = new Flusher();
    private final Deflater compressor = new Deflater(9, true);
    private final Inflater decompressor = new Inflater(true);

    static {
        byte[] byArray = new byte[4];
        byArray[2] = -1;
        byArray[3] = -1;
        TAIL_BYTES = byArray;
        LOG = Log.getLogger(CompressExtension.class);
    }

    protected CompressExtension() {
    }

    public Deflater getDeflater() {
        return this.compressor;
    }

    public Inflater getInflater() {
        return this.decompressor;
    }

    @Override
    public boolean isRsv1User() {
        return true;
    }

    protected void forwardIncoming(Frame frame, ByteAccumulator accumulator) {
        DataFrame newFrame = new DataFrame(frame);
        newFrame.setRsv1(false);
        ByteBuffer buffer = this.getBufferPool().acquire(accumulator.getLength(), false);
        try {
            BufferUtil.flipToFill(buffer);
            accumulator.transferTo(buffer);
            newFrame.setPayload(buffer);
            this.nextIncomingFrame(newFrame);
        }
        finally {
            this.getBufferPool().release(buffer);
        }
    }

    protected ByteAccumulator decompress(byte[] input) {
        int maxSize = Math.max(this.getPolicy().getMaxTextMessageSize(), this.getPolicy().getMaxBinaryMessageBufferSize());
        ByteAccumulator accumulator = new ByteAccumulator(maxSize);
        this.decompressor.setInput(input, 0, input.length);
        LOG.debug("Decompressing {} bytes", input.length);
        try {
            while (this.decompressor.getRemaining() > 0 && !this.decompressor.finished()) {
                byte[] output = new byte[Math.min(input.length * 2, 32768)];
                int decompressed = this.decompressor.inflate(output);
                if (decompressed == 0) {
                    if (this.decompressor.needsInput()) {
                        throw new BadPayloadException("Unable to inflate frame, not enough input on frame");
                    }
                    if (!this.decompressor.needsDictionary()) continue;
                    throw new BadPayloadException("Unable to inflate frame, frame erroneously says it needs a dictionary");
                }
                accumulator.addChunk(output, 0, decompressed);
            }
            LOG.debug("Decompressed {}->{} bytes", input.length, accumulator.getLength());
            return accumulator;
        }
        catch (DataFormatException x) {
            throw new BadPayloadException(x);
        }
    }

    @Override
    public void outgoingFrame(Frame frame, WriteCallback callback, BatchMode batchMode) {
        if (this.flusher.isFailed()) {
            this.notifyCallbackFailure(callback, new ZipException());
            return;
        }
        FrameEntry entry = new FrameEntry(frame, callback, batchMode);
        LOG.debug("Queuing {}", entry);
        this.entries.offer(entry);
        this.flusher.iterate();
    }

    protected void notifyCallbackSuccess(WriteCallback callback) {
        try {
            if (callback != null) {
                callback.writeSuccess();
            }
        }
        catch (Throwable x) {
            LOG.debug("Exception while notifying success of callback " + callback, x);
        }
    }

    protected void notifyCallbackFailure(WriteCallback callback, Throwable failure) {
        try {
            if (callback != null) {
                callback.writeFailed(failure);
            }
        }
        catch (Throwable x) {
            LOG.debug("Exception while notifying failure of callback " + callback, x);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }

    private class Flusher
    extends IteratingCallback
    implements WriteCallback {
        private FrameEntry current;
        private ByteBuffer payload;
        private boolean finished = true;

        private Flusher() {
        }

        @Override
        protected IteratingCallback.Action process() throws Exception {
            if (this.finished) {
                this.current = (FrameEntry)CompressExtension.this.entries.poll();
                LOG.debug("Processing {}", this.current);
                if (this.current == null) {
                    return IteratingCallback.Action.IDLE;
                }
                this.deflate(this.current);
            } else {
                this.compress(this.current, false);
            }
            return IteratingCallback.Action.SCHEDULED;
        }

        private void deflate(FrameEntry entry) {
            Frame frame = entry.frame;
            BatchMode batchMode = entry.batchMode;
            if (OpCode.isControlFrame(frame.getOpCode()) || !frame.hasPayload()) {
                CompressExtension.this.nextOutgoingFrame(frame, this, batchMode);
                return;
            }
            this.compress(entry, true);
        }

        private void compress(FrameEntry entry, boolean first) {
            int inputOffset;
            byte[] input;
            Frame frame = entry.frame;
            ByteBuffer data = frame.getPayload();
            int remaining = data.remaining();
            int inputLength = Math.min(remaining, 32768);
            LOG.debug("Compressing {}: {} bytes in {} bytes chunk", entry, remaining, inputLength);
            if (data.hasArray()) {
                input = data.array();
                int position = data.position();
                inputOffset = position + data.arrayOffset();
                data.position(position + inputLength);
            } else {
                input = new byte[inputLength];
                inputOffset = 0;
                data.get(input, 0, inputLength);
            }
            this.finished = inputLength == remaining;
            CompressExtension.this.compressor.setInput(input, inputOffset, inputLength);
            byte[] output = new byte[inputLength + 64];
            int outputOffset = 0;
            int outputLength = 0;
            while (true) {
                int space = output.length - outputOffset;
                int compressed = CompressExtension.this.compressor.deflate(output, outputOffset, space, 2);
                outputLength += compressed;
                if (compressed < space) break;
                byte[] newOutput = new byte[output.length * 2];
                System.arraycopy(output, 0, newOutput, 0, output.length);
                outputOffset += output.length;
                output = newOutput;
            }
            this.payload = ByteBuffer.wrap(output, 0, outputLength - TAIL_BYTES.length);
            LOG.debug("Compressed {}: {}->{} chunk bytes", entry, inputLength, outputLength);
            boolean continuation = frame.getType().isContinuation() || !first;
            DataFrame chunk = new DataFrame(frame, continuation);
            chunk.setRsv1(true);
            chunk.setPayload(this.payload);
            boolean fin = frame.isFin() && this.finished;
            chunk.setFin(fin);
            CompressExtension.this.nextOutgoingFrame(chunk, this, entry.batchMode);
        }

        @Override
        protected void completed() {
        }

        @Override
        public void writeSuccess() {
            if (this.finished) {
                CompressExtension.this.notifyCallbackSuccess(this.current.callback);
            }
            this.succeeded();
        }

        @Override
        public void writeFailed(Throwable x) {
            FrameEntry entry;
            CompressExtension.this.notifyCallbackFailure(this.current.callback, x);
            this.failed(x);
            while ((entry = (FrameEntry)CompressExtension.this.entries.poll()) != null) {
                CompressExtension.this.notifyCallbackFailure(entry.callback, x);
            }
        }
    }

    private static class FrameEntry {
        private final Frame frame;
        private final WriteCallback callback;
        private final BatchMode batchMode;

        private FrameEntry(Frame frame, WriteCallback callback, BatchMode batchMode) {
            this.frame = frame;
            this.callback = callback;
            this.batchMode = batchMode;
        }

        public String toString() {
            return this.frame.toString();
        }
    }
}

