/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.pathmap;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.websocket.server.pathmap.PathSpec;
import org.eclipse.jetty.websocket.server.pathmap.PathSpecGroup;

public class RegexPathSpec
extends PathSpec {
    protected Pattern pattern;

    protected RegexPathSpec() {
    }

    public RegexPathSpec(String regex) {
        this.pathSpec = regex;
        boolean inGrouping = false;
        this.pathDepth = 0;
        this.specLength = this.pathSpec.length();
        StringBuilder signature = new StringBuilder();
        char[] cArray = this.pathSpec.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '[': {
                    inGrouping = true;
                    break;
                }
                case ']': {
                    inGrouping = false;
                    signature.append('g');
                    break;
                }
                case '*': {
                    signature.append('g');
                    break;
                }
                case '/': {
                    if (inGrouping) break;
                    ++this.pathDepth;
                    break;
                }
                default: {
                    if (inGrouping || !Character.isLetterOrDigit(c)) break;
                    signature.append('l');
                }
            }
            ++n2;
        }
        this.pattern = Pattern.compile(this.pathSpec);
        String sig = signature.toString();
        this.group = Pattern.matches("^l*$", sig) ? PathSpecGroup.EXACT : (Pattern.matches("^l*g+", sig) ? PathSpecGroup.PREFIX_GLOB : (Pattern.matches("^g+l+$", sig) ? PathSpecGroup.SUFFIX_GLOB : PathSpecGroup.MIDDLE_GLOB));
    }

    public Matcher getMatcher(String path) {
        return this.pattern.matcher(path);
    }

    @Override
    public String getPathInfo(String path) {
        Matcher matcher;
        if (this.group == PathSpecGroup.PREFIX_GLOB && (matcher = this.getMatcher(path)).matches() && matcher.groupCount() >= 1) {
            String pathInfo = matcher.group(1);
            if ("".equals(pathInfo)) {
                return "/";
            }
            return pathInfo;
        }
        return null;
    }

    @Override
    public String getPathMatch(String path) {
        Matcher matcher = this.getMatcher(path);
        if (matcher.matches()) {
            int idx;
            if (matcher.groupCount() >= 1 && (idx = matcher.start(1)) > 0) {
                if (path.charAt(idx - 1) == '/') {
                    --idx;
                }
                return path.substring(0, idx);
            }
            return path;
        }
        return null;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public String getRelativePath(String base, String path) {
        return null;
    }

    @Override
    public boolean matches(String path) {
        int idx = path.indexOf(63);
        if (idx >= 0) {
            return this.getMatcher(path.substring(0, idx)).matches();
        }
        return this.getMatcher(path).matches();
    }
}

